/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.helpers;

import io.intino.sumus.analytics.TimeRange;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.CatalogViewDisplayProvider;
import io.intino.sumus.datawarehouse.store.PathBuilder;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.TemporalRecord;
import io.intino.sumus.helpers.Helper;
import io.intino.sumus.queries.TemporalRecordQuery;
import io.intino.sumus.queries.temporalrecord.QueryExecutor;
import java.util.Collections;
import java.util.List;

public class TemporalRecordHelper
implements Helper {
    private final SumusBox box;

    public TemporalRecordHelper(SumusBox box) {
        this.box = box;
    }

    public int count(TemporalRecordQuery query) {
        return this.records(query).size();
    }

    public TimeRange recordRange(NameSpace ... nameSpaces) {
        return PathBuilder.range(nameSpaces);
    }

    public List<TemporalRecord> records(TemporalRecordQuery query, int start, int limit) {
        List<TemporalRecord> records = this.records(query);
        this.applySorting(query, records);
        return records.size() > start + limit ? records.subList(start, start + limit) : records;
    }

    public TemporalRecord record(String id) {
        return (TemporalRecord)this.box.graph().core$().load(id).as(TemporalRecord.class);
    }

    private List<TemporalRecord> records(TemporalRecordQuery query) {
        return QueryExecutor.execute(query.toRawQuery()).values();
    }

    private void applySorting(TemporalRecordQuery query, List<TemporalRecord> temporalRecordList) {
        CatalogViewDisplayProvider.Sorting sorting = query.sorting();
        if (sorting == null) {
            return;
        }
        temporalRecordList.sort(sorting::comparator);
        if (sorting.mode() == CatalogViewDisplayProvider.Sorting.Mode.Ascendant) {
            Collections.reverse(temporalRecordList);
        }
    }
}

