/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.helpers;

import io.intino.sumus.Category;
import io.intino.sumus.analytics.Scaler;
import io.intino.sumus.analytics.TimeRange;
import io.intino.sumus.analytics.viewmodels.Serie;
import io.intino.sumus.graph.AbstractCategorization;
import io.intino.sumus.graph.AbstractMetric;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Cube;
import io.intino.sumus.graph.Indicator;
import io.intino.sumus.graph.MeasureIndicator;
import io.intino.sumus.graph.Palette;
import io.intino.sumus.graph.StackedIndicator;
import io.intino.sumus.graph.Ticket;
import io.intino.sumus.helpers.Helper;
import io.intino.sumus.queries.Drill;
import io.intino.sumus.queries.digest.Query;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

abstract class QueryHelper
implements Helper {
    private static final String DrillLabel = "%s (%s)";

    QueryHelper() {
    }

    String labelOf(MeasureIndicator.Formula formula) {
        return ((MeasureIndicator)formula.core$().ownerAs(MeasureIndicator.class)).label();
    }

    String labelOf(MeasureIndicator.Formula formula, Drill drill) {
        List categories = drill.categories().stream().map(Category::label).collect(Collectors.toList());
        return String.format(DrillLabel, ((MeasureIndicator)formula.core$().ownerAs(MeasureIndicator.class)).label(), String.join((CharSequence)",", categories));
    }

    String colorOf(MeasureIndicator indicator) {
        return indicator.graph().palette().colorOf(this.ticketOf(indicator), indicator, Palette.Color.Type.Main);
    }

    String colorOf(MeasureIndicator indicator, int index) {
        return indicator.graph().palette().colorOf(this.ticketOf(indicator), indicator, Palette.Color.Type.valueOf("Drill" + index));
    }

    int drillIndexOf(Drill drill, Query query) {
        List<Drill> drills = query.drills();
        for (int i = 0; i < drills.size(); ++i) {
            if (drills.get(i) != drill) continue;
            return i + 1;
        }
        return 0;
    }

    List<MeasureIndicator.Formula> formulas(List<MeasureIndicator> measureIndicatorList) {
        if (measureIndicatorList.isEmpty()) {
            return Collections.emptyList();
        }
        List<Categorization> categorizationList = measureIndicatorList.get(0).graph().categorizationList();
        return new ArrayList<MeasureIndicator.Formula>(this.categorizationsByCube(categorizationList, measureIndicatorList).values());
    }

    void scaleValues(List<Serie> serieList) {
        if (serieList.isEmpty()) {
            return;
        }
        serieList.forEach(serie -> {
            AbstractMetric.Unit unit = serie.unit();
            AbstractMetric metric = (AbstractMetric)unit.core$().ownerAs(AbstractMetric.class);
            Scaler indicatorsScale = metric.scaler().scaler(serie.maxValue(), unit);
            serie.scaleValues(indicatorsScale);
        });
    }

    Ticket ticketOf(MeasureIndicator indicator) {
        return (Ticket)indicator.core$().ownerAs(Ticket.class);
    }

    Ticket ticketOf(MeasureIndicator.Formula formula) {
        Node owner = formula.core$().owner();
        if (owner.is(MeasureIndicator.class)) {
            return (Ticket)owner.ownerAs(Ticket.class);
        }
        return (Ticket)owner.owner().ownerAs(Ticket.class);
    }

    MeasureIndicator indicatorOf(MeasureIndicator.Formula formula) {
        return (MeasureIndicator)formula.core$().ownerAs(MeasureIndicator.class);
    }

    List<MeasureIndicator> measureIndicators(List<Ticket> ticketList, TimeRange range) {
        return ticketList.parallelStream().filter(ticket -> this.isTicketVisible((Ticket)((Object)ticket), range)).filter(ticket -> ticket.dataRetriever().core$().is(Indicator.class)).map(ticket -> this.measureIndicators((Indicator)ticket.dataRetriever().core$().as(Indicator.class))).flatMap(Collection::stream).collect(Collectors.toList());
    }

    List<MeasureIndicator> measureIndicators(Indicator indicator) {
        if (indicator.core$().is(MeasureIndicator.class)) {
            return Collections.singletonList(indicator.core$().as(MeasureIndicator.class));
        }
        return ((StackedIndicator)indicator.core$().as(StackedIndicator.class)).measureIndicatorList();
    }

    private boolean isTicketVisible(Ticket ticket, TimeRange range) {
        int queryScale = range.scale().ordinal();
        return ticket.range().max().ordinal() <= queryScale && queryScale <= ticket.range().min().ordinal();
    }

    public Map<MeasureIndicator, MeasureIndicator.Formula> categorizationsByCube(List<Categorization> categorizations, List<MeasureIndicator> indicators) {
        if (indicators.isEmpty()) {
            return Collections.emptyMap();
        }
        List<Cube> cubes = this.commonCubesOf(indicators);
        if (cubes.isEmpty()) {
            throw new RuntimeException("There are no common cubes in indicators provided");
        }
        Cube cube = this.cubeWithMostCategorizationCriteria(categorizations, cubes);
        return indicators.stream().map(i -> this.formulaOf((MeasureIndicator)((Object)i), cube)).collect(Collectors.toMap(f -> (MeasureIndicator)f.core$().ownerAs(MeasureIndicator.class), f -> f));
    }

    private MeasureIndicator.Formula formulaOf(MeasureIndicator indicator, Cube cube) {
        return indicator.formulaList().stream().filter(f -> ((Object)((Object)f.cube())).equals((Object)cube)).findFirst().get();
    }

    private Cube cubeWithMostCategorizationCriteria(List<Categorization> categorizations, List<Cube> cubes) {
        Cube maxCube = null;
        int maxCount = -1;
        for (Cube cube : cubes) {
            int count = this.categorizationCountAt(categorizations, cube);
            if (count <= maxCount) continue;
            maxCount = count;
            maxCube = cube;
        }
        return maxCube;
    }

    private int categorizationCountAt(List<Categorization> categorizations, Cube cube) {
        List<Concept> cubeEntities = cube.dimensionList().stream().map(Cube.Dimension::entity).collect(Collectors.toList());
        List categorizationEntities = categorizations.stream().map(AbstractCategorization::entity).collect(Collectors.toList());
        int[] coincidenceCount = new int[]{0};
        cubeEntities.forEach(c1 -> categorizationEntities.forEach(c2 -> {
            if (c2.equals(c1)) {
                coincidenceCount[0] = coincidenceCount[0] + 1;
            }
        }));
        return coincidenceCount[0];
    }

    private List<Cube> commonCubesOf(List<MeasureIndicator> indicators) {
        HashMap cubeMap = new HashMap();
        indicators.get(0).graph().cubeList().forEach(c -> {
            List cfr_ignored_0 = cubeMap.put(c, new ArrayList());
        });
        indicators.forEach(i -> i.formulaList().forEach(f -> ((List)cubeMap.get((Object)f.cube())).add(i)));
        return cubeMap.entrySet().stream().filter(e -> ((List)e.getValue()).size() == indicators.size()).map(Map.Entry::getKey).collect(Collectors.toList());
    }
}

