/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.helpers;

import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.CatalogViewDisplayProvider;
import io.intino.sumus.graph.Entity;
import io.intino.sumus.helpers.Helper;
import io.intino.sumus.queries.EntityQuery;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Layer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class EntityHelper
implements Helper {
    private final SumusBox box;

    public EntityHelper(SumusBox box) {
        this.box = box;
    }

    public int count(EntityQuery query) {
        return this.entities(query).size();
    }

    public List<Entity> entities(EntityQuery query, int start, int limit) {
        List<Entity> entities = this.entities(query);
        return entities.size() > start + limit ? entities.subList(start, start + limit) : entities;
    }

    public Entity entity(String id) {
        return (Entity)this.box.graph().core$().load(id).as(Entity.class);
    }

    private List<Entity> entities(EntityQuery query) {
        Concept entity = query.entity();
        Optional<Map<String, List<Entity>>> filter = query.filter();
        List<Entity> entityList = this.box.graph().core$().find(entity.layerClass()).stream().filter(e -> !filter.isPresent() || this.conforms((Layer)e, (Map)filter.get())).filter(e -> this.hasCondition((Layer)e, query.condition())).map(e -> (Entity)e.core$().as(Entity.class)).collect(Collectors.toList());
        this.applySorting(query, entityList);
        return entityList;
    }

    private void applySorting(EntityQuery query, List<Entity> entityList) {
        CatalogViewDisplayProvider.Sorting sorting = query.sorting();
        if (sorting == null) {
            return;
        }
        entityList.sort(sorting::comparator);
        if (sorting.mode() == CatalogViewDisplayProvider.Sorting.Mode.Ascendant) {
            Collections.reverse(entityList);
        }
    }

    private boolean hasCondition(Layer entity, String condition) {
        if (condition == null || condition.isEmpty()) {
            return true;
        }
        List<String> keys = Arrays.asList(condition.toLowerCase().split(" "));
        List<String> words = this.words(entity);
        return keys.stream().filter(key -> words.stream().filter(word -> word.toLowerCase().contains((CharSequence)key)).count() > 0L).count() == (long)keys.size();
    }

    private List<String> words(Layer entity) {
        List values = entity.core$().variables().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        List<String> words = values.stream().filter(v -> v instanceof String).map(v -> (String)v).collect(Collectors.toList());
        values.stream().filter(v -> v instanceof Layer).map(v -> (Layer)v).forEach(e -> words.addAll(this.words((Layer)e)));
        return words;
    }

    private boolean conforms(Layer entity, Map<String, List<Entity>> filter) {
        List entities = entity.core$().variables().values().stream().flatMap(Collection::stream).filter(s -> s instanceof Entity).map(s -> ((Entity)((Object)((Object)s))).core$().id()).collect(Collectors.toList());
        for (List<Entity> entityList : filter.values()) {
            List collect = entityList.stream().map(e -> e.core$().id()).collect(Collectors.toList());
            if (collect.contains(entity.core$().id())) continue;
            collect.retainAll(entities);
            if (collect.size() > 0) continue;
            return false;
        }
        return true;
    }
}

