/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.graph.rules;

import io.intino.tara.lang.model.rules.variable.VariableRule;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.WeekFields;

public enum TimeScale implements VariableRule<Enum>
{
    Year(ChronoUnit.YEARS){

        @Override
        public Instant normalise(Instant instant) {
            return this.instantOf(LocalDateTime.of(this.yearOf(instant), 1, 1, 0, 0, 0));
        }

        @Override
        public long toMillis(long value) {
            return Day.toMillis((long)((double)value * 365.25));
        }

        @Override
        public String symbol(String language) {
            return language.equals("es") ? "A" : "Y";
        }

        @Override
        public String category(Instant instant, String format, Translator translator) {
            return String.valueOf(this.yearOf(instant));
        }

        @Override
        public int sortingWeight(Instant instant, String format) {
            return this.yearOf(instant);
        }

        @Override
        public String toString(Instant instant) {
            return String.valueOf(this.yearOf(instant));
        }
    }
    ,
    QuarterOfYear(ChronoUnit.MONTHS){
        private final DateTimeFormatter Formatter = DateTimeFormatter.ofPattern("MM/yyyy");

        @Override
        public long instantsBetween(Instant start, Instant end) {
            return Math.max(ChronoUnit.MONTHS.between(this.dateTimeOf(start), this.dateTimeOf(end)) / 3L, 1L);
        }

        @Override
        public Instant addTo(Instant time, long amount) {
            return this.instantOf(ChronoUnit.MONTHS.addTo(this.dateTimeOf(time), 3L * amount));
        }

        @Override
        public Instant normalise(Instant instant) {
            return this.instantOf(this.dateTimeOf(instant).withMonth(this.firstMonthOfQuarter(instant)).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0));
        }

        @Override
        public long toMillis(long value) {
            return Month.toMillis(value * 3L);
        }

        @Override
        public String symbol(String language) {
            return language.equals("es") ? "C" : "Q";
        }

        @Override
        public String category(Instant instant, String format, Translator translator) {
            int quarter = this.quarterNumber(instant);
            String category = translator.translate("TemporalCategorization.Category.Quarter" + quarter);
            if (format.equalsIgnoreCase("QuarterOfYear")) {
                category = category + " " + this.yearOf(instant);
            }
            return category;
        }

        @Override
        public int sortingWeight(Instant instant, String format) {
            return this.quarterNumber(instant);
        }

        @Override
        public String toString(Instant instant) {
            return "Q" + this.quarterNumber(instant) + " (" + this.range(instant) + ")";
        }

        private String range(Instant instant) {
            return this.Formatter.format(this.dateTimeOf(instant)) + " - " + this.Formatter.format(this.dateTimeOf(this.nextTime(instant)));
        }

        private int quarterNumber(Instant instant) {
            return (this.monthNumberOf(instant) - 1) / 3 + 1;
        }

        private int firstMonthOfQuarter(Instant instant) {
            return (this.monthNumberOf(instant) - 1) / 3 * 3 + 1;
        }
    }
    ,
    Month(ChronoUnit.MONTHS){
        private final DateTimeFormatter Formatter = DateTimeFormatter.ofPattern("MM/yyyy");

        @Override
        public Instant normalise(Instant instant) {
            return this.instantOf(this.dateTimeOf(instant).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0));
        }

        @Override
        public long toMillis(long value) {
            return Day.toMillis(value * 30L);
        }

        @Override
        public String symbol(String language) {
            return "M";
        }

        @Override
        public String category(Instant instant, String format, Translator translator) {
            int month = this.dateTimeOf(instant).getMonthValue();
            String category = translator.translate("TemporalCategorization.Category.Month" + month);
            if (format.equalsIgnoreCase("MonthOfYear")) {
                category = category + " " + this.yearOf(instant);
            }
            return category;
        }

        @Override
        public int sortingWeight(Instant instant, String format) {
            return this.dateTimeOf(instant).getMonthValue();
        }

        @Override
        public String toString(Instant instant) {
            return this.Formatter.format(this.dateTimeOf(instant));
        }
    }
    ,
    Week(ChronoUnit.WEEKS){
        private final DateTimeFormatter Formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");

        @Override
        public Instant normalise(Instant instant) {
            return this.instantOf(this.dateTimeOf(instant).with(WeekFields.ISO.dayOfWeek(), 1L).withHour(0).withMinute(0).withSecond(0).withNano(0));
        }

        @Override
        public long toMillis(long value) {
            return Day.toMillis(value * 7L);
        }

        @Override
        public String symbol(String language) {
            return language.equals("es") ? "S" : "W";
        }

        @Override
        public String category(Instant instant, String format, Translator translator) {
            LocalDateTime dateTime = this.dateTimeOf(instant);
            int week = dateTime.get(ChronoField.ALIGNED_WEEK_OF_YEAR);
            String category = translator.translate("TemporalCategorization.Category.Week") + " " + TimeScale.format(week, 2);
            if (format.equalsIgnoreCase("WeekOfYear")) {
                category = category + " " + this.yearOf(instant);
            }
            return category;
        }

        @Override
        public int sortingWeight(Instant instant, String format) {
            LocalDateTime dateTime = this.dateTimeOf(instant);
            return dateTime.get(ChronoField.ALIGNED_WEEK_OF_YEAR);
        }

        @Override
        public String toString(Instant instant) {
            LocalDateTime dateTime = this.dateTimeOf(instant);
            return "Week " + TimeScale.format(dateTime.get(ChronoField.ALIGNED_WEEK_OF_YEAR), 2) + " (" + this.range(instant) + ")";
        }

        private String range(Instant instant) {
            LocalDateTime dateTime = this.dateTimeOf(instant);
            return this.Formatter.format(dateTime) + " - " + this.Formatter.format(this.dateTimeOf(this.nextTime(instant)));
        }
    }
    ,
    Day(ChronoUnit.DAYS){
        private final DateTimeFormatter Formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");

        @Override
        public Instant normalise(Instant instant) {
            return this.instantOf(this.dateTimeOf(instant).withHour(0).withMinute(0).withSecond(0).withNano(0));
        }

        @Override
        public long toMillis(long value) {
            return SixHours.toMillis(value * 4L);
        }

        @Override
        public String symbol(String language) {
            return "D";
        }

        @Override
        public String category(Instant instant, String format, Translator translator) {
            LocalDateTime dateTime = this.dateTimeOf(instant);
            if (format.equalsIgnoreCase("DayOfYear")) {
                return translator.translate("TemporalCategorization.Category.Day") + " " + dateTime.getDayOfYear();
            }
            if (format.equalsIgnoreCase("DayOfMonth")) {
                return translator.translate("TemporalCategorization.Category.Day") + " " + dateTime.getDayOfMonth();
            }
            return translator.translate("TemporalCategorization.Category.Day" + dateTime.getDayOfWeek().ordinal());
        }

        @Override
        public int sortingWeight(Instant instant, String format) {
            if (format.equalsIgnoreCase("DayOfYear")) {
                return this.dateTimeOf(instant).getDayOfYear();
            }
            if (format.equalsIgnoreCase("DayOfMonth")) {
                return this.dateTimeOf(instant).getDayOfMonth();
            }
            return this.dateTimeOf(instant).getDayOfWeek().ordinal();
        }

        @Override
        public String toString(Instant instant) {
            return this.Formatter.format(this.dateTimeOf(instant));
        }
    }
    ,
    SixHours(ChronoUnit.HOURS){
        private final DateTimeFormatter Formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");

        @Override
        public long instantsBetween(Instant start, Instant end) {
            return Math.max(ChronoUnit.HOURS.between(start, end) / 5L, 1L);
        }

        @Override
        public Instant addTo(Instant time, long amount) {
            return this.instantOf(ChronoUnit.HOURS.addTo(this.dateTimeOf(time), 6L * amount));
        }

        private int quarter(int hour) {
            return hour / 6 * 6;
        }

        @Override
        public Instant normalise(Instant instant) {
            LocalDateTime dateTime = this.dateTimeOf(instant);
            return this.instantOf(dateTime.withHour(this.quarter(dateTime.getHour())).withMinute(0).withSecond(0).withNano(0));
        }

        @Override
        public long toMillis(long value) {
            return Hour.toMillis(value * 6L);
        }

        @Override
        public String symbol(String language) {
            return "6h";
        }

        @Override
        public String category(Instant instant, String format, Translator translator) {
            int hourBefore = this.hourOf(this.addTo(instant, -1L));
            return TimeScale.format(hourBefore, 2) + " - " + TimeScale.format(this.hourOf(instant), 2);
        }

        @Override
        public int sortingWeight(Instant instant, String format) {
            return this.hourOf(this.addTo(instant, -1L));
        }

        @Override
        public String toString(Instant instant) {
            return this.Formatter.format(this.dateTimeOf(this.addTo(instant, -1L))) + " (" + TimeScale.format(this.hourOf(this.addTo(instant, -1L)), 2) + " - " + TimeScale.format(this.hourOf(instant), 2) + ")";
        }
    }
    ,
    Hour(ChronoUnit.HOURS){
        private final DateTimeFormatter Formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH");
        private final DateTimeFormatter CategoryFormatter = DateTimeFormatter.ofPattern("HH");

        @Override
        public Instant normalise(Instant instant) {
            return this.instantOf(this.dateTimeOf(instant).withMinute(0).withSecond(0).withNano(0));
        }

        @Override
        public long toMillis(long value) {
            return FifteenMinutes.toMillis(value * 4L);
        }

        @Override
        public String symbol(String language) {
            return "h";
        }

        @Override
        public String category(Instant instant, String format, Translator translator) {
            return this.CategoryFormatter.format(this.dateTimeOf(instant));
        }

        @Override
        public int sortingWeight(Instant instant, String format) {
            return this.hourOf(instant);
        }

        @Override
        public String toString(Instant instant) {
            return this.Formatter.format(this.dateTimeOf(instant));
        }
    }
    ,
    FifteenMinutes(ChronoUnit.MINUTES){
        private final DateTimeFormatter Formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH");

        @Override
        public Instant normalise(Instant instant) {
            LocalDateTime dateTime = this.dateTimeOf(instant);
            return this.instantOf(dateTime.withMinute(this.quarter(dateTime.getMinute())).withSecond(0).withNano(0));
        }

        @Override
        public long instantsBetween(Instant start, Instant end) {
            return Math.max(ChronoUnit.MINUTES.between(start, end) / 14L, 1L);
        }

        @Override
        public Instant addTo(Instant time, long amount) {
            return this.instantOf(ChronoUnit.MINUTES.addTo(this.dateTimeOf(time), 15L * amount));
        }

        @Override
        public long toMillis(long value) {
            return Minute.toMillis(value * 15L);
        }

        @Override
        public String symbol(String language) {
            return "15'";
        }

        @Override
        public String category(Instant instant, String format, Translator translator) {
            int beforeMinute = this.minuteOf(this.addTo(instant, -1L));
            return TimeScale.format(beforeMinute, 2) + " - " + TimeScale.format(this.minuteOf(instant), 2);
        }

        @Override
        public int sortingWeight(Instant instant, String format) {
            return this.minuteOf(this.addTo(instant, -1L));
        }

        @Override
        public String toString(Instant instant) {
            return this.Formatter.format(this.dateTimeOf(this.addTo(instant, -1L))) + " (" + TimeScale.format(this.minuteOf(this.addTo(instant, -1L)), 2) + " - " + TimeScale.format(this.minuteOf(instant), 2) + ")";
        }

        private int quarter(int minutes) {
            return minutes / 15 * 15;
        }
    }
    ,
    Minute(ChronoUnit.MINUTES){
        private final DateTimeFormatter Formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm");
        private final DateTimeFormatter CategoryFormatter = DateTimeFormatter.ofPattern("mm");

        @Override
        public Instant normalise(Instant instant) {
            return this.instantOf(this.dateTimeOf(instant).withSecond(0).withNano(0));
        }

        @Override
        public long toMillis(long value) {
            return Second.toMillis(value * 60L);
        }

        @Override
        public String symbol(String language) {
            return "m";
        }

        @Override
        public String category(Instant instant, String format, Translator translator) {
            return this.CategoryFormatter.format(this.dateTimeOf(instant));
        }

        @Override
        public int sortingWeight(Instant instant, String format) {
            return this.minuteOf(instant);
        }

        @Override
        public String toString(Instant instant) {
            return this.Formatter.format(this.dateTimeOf(instant));
        }
    }
    ,
    Second(ChronoUnit.SECONDS){
        private final DateTimeFormatter Formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
        private final DateTimeFormatter CategoryFormatter = DateTimeFormatter.ofPattern("ss");

        @Override
        public Instant normalise(Instant instant) {
            return instant;
        }

        @Override
        public long toMillis(long value) {
            return value * 1000L;
        }

        @Override
        public String symbol(String language) {
            return "s";
        }

        @Override
        public String category(Instant instant, String format, Translator translator) {
            return this.CategoryFormatter.format(this.dateTimeOf(instant));
        }

        @Override
        public int sortingWeight(Instant instant, String format) {
            return this.secondOf(instant);
        }

        @Override
        public String toString(Instant instant) {
            return this.Formatter.format(this.dateTimeOf(instant));
        }
    };

    private final ChronoUnit unit;
    private String label;

    private TimeScale(ChronoUnit unit) {
        this(unit, "");
    }

    private TimeScale(ChronoUnit unit, String label) {
        this.unit = unit;
        this.label = label;
    }

    private static String format(int number, int withDecimals) {
        return String.format("%0" + withDecimals + "d", number);
    }

    public String label() {
        return this.label;
    }

    public void label(String label) {
        this.label = label;
    }

    public abstract Instant normalise(Instant var1);

    public abstract String toString(Instant var1);

    public Instant nextTime(Instant time) {
        return this.addTo(time, 1L);
    }

    public long instantsBetween(Instant start, Instant end) {
        return Math.max(this.unit.between(this.dateTimeOf(start), this.unit.addTo(this.dateTimeOf(end), 1L)), 1L);
    }

    public abstract long toMillis(long var1);

    public Instant addTo(Instant time, long amount) {
        return this.instantOf(this.unit.addTo(this.dateTimeOf(time), amount));
    }

    public Instant floor(Instant time) {
        return time.truncatedTo(this.unit);
    }

    public boolean accept(Enum value) {
        return value instanceof TimeScale;
    }

    public abstract String symbol(String var1);

    public abstract String category(Instant var1, String var2, Translator var3);

    public abstract int sortingWeight(Instant var1, String var2);

    public TimeScale next() {
        int ordinal = this.ordinal();
        if (++ordinal > ChronoUnit.SECONDS.ordinal()) {
            return Second;
        }
        return TimeScale.values()[ordinal];
    }

    protected int yearOf(Instant instant) {
        return this.dateTimeOf(instant).getYear();
    }

    protected Month monthOf(Instant instant) {
        return this.dateTimeOf(instant).getMonth();
    }

    protected int monthNumberOf(Instant instant) {
        return this.dateTimeOf(instant).getMonthValue();
    }

    protected int dayOfYearOf(Instant instant) {
        return this.dateTimeOf(instant).getDayOfYear();
    }

    protected int dayOfMonthOf(Instant instant) {
        return this.dateTimeOf(instant).getDayOfMonth();
    }

    protected int hourOf(Instant instant) {
        return this.dateTimeOf(instant).getHour();
    }

    protected int minuteOf(Instant instant) {
        return this.dateTimeOf(instant).getMinute();
    }

    protected int secondOf(Instant instant) {
        return this.dateTimeOf(instant).getSecond();
    }

    protected ZoneId utc() {
        return ZoneId.of("UTC");
    }

    protected ZoneOffset utcOffset() {
        return ZoneOffset.UTC;
    }

    protected Instant instantOf(LocalDateTime dateTime) {
        return dateTime.toInstant(this.utcOffset());
    }

    LocalDateTime dateTimeOf(Instant instant) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(instant.toEpochMilli()), this.utc());
    }

    public static interface Translator {
        public String translate(String var1);
    }
}

