/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.graph;

import io.intino.sumus.graph.AbstractMetric;
import io.intino.sumus.graph.DataRetriever;
import io.intino.sumus.graph.Distribution;
import io.intino.sumus.graph.MeasureIndicator;
import io.intino.sumus.graph.StackedIndicator;
import io.intino.sumus.graph.SumusGraph;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Expression;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.ConceptLoader;
import io.intino.tara.magritte.loaders.FunctionLoader;
import io.intino.tara.magritte.loaders.IntegerLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Feature;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class Ticket
extends Layer
implements Terminal {
    protected String label;
    protected String shortLabel;
    protected List<Concept> events = new ArrayList<Concept>();
    protected List<Concept> catalogs = new ArrayList<Concept>();
    protected DataRetriever dataRetriever;
    protected Min min;
    protected Max max;
    protected DecimalPlaces decimalPlaces;
    protected Range range;
    protected Style style;

    public Ticket(Node node) {
        super(node);
    }

    public String label() {
        return this.label;
    }

    public String shortLabel() {
        return this.shortLabel;
    }

    public List<Concept> events() {
        return Collections.unmodifiableList(this.events);
    }

    public List<Concept> catalogs() {
        return Collections.unmodifiableList(this.catalogs);
    }

    public Ticket events(List<Concept> value) {
        this.events = value;
        return this;
    }

    public Ticket catalogs(List<Concept> value) {
        this.catalogs = value;
        return this;
    }

    public DataRetriever dataRetriever() {
        return this.dataRetriever;
    }

    public Min min() {
        return this.min;
    }

    public Max max() {
        return this.max;
    }

    public DecimalPlaces decimalPlaces() {
        return this.decimalPlaces;
    }

    public Range range() {
        return this.range;
    }

    public Style style() {
        return this.style;
    }

    public Ticket dataRetriever(DataRetriever value) {
        this.dataRetriever = value;
        return this;
    }

    public Ticket min(Min value) {
        this.min = value;
        return this;
    }

    public Ticket max(Max value) {
        this.max = value;
        return this;
    }

    public Ticket decimalPlaces(DecimalPlaces value) {
        this.decimalPlaces = value;
        return this;
    }

    public Ticket range(Range value) {
        this.range = value;
        return this;
    }

    public Ticket style(Style value) {
        this.style = value;
        return this;
    }

    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        if (this.dataRetriever != null) {
            components.add(this.dataRetriever.core$());
        }
        if (this.min != null) {
            components.add(this.min.core$());
        }
        if (this.max != null) {
            components.add(this.max.core$());
        }
        if (this.decimalPlaces != null) {
            components.add(this.decimalPlaces.core$());
        }
        if (this.range != null) {
            components.add(this.range.core$());
        }
        if (this.style != null) {
            components.add(this.style.core$());
        }
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
        map.put("shortLabel", new ArrayList<String>(Collections.singletonList(this.shortLabel)));
        map.put("events", this.events);
        map.put("catalogs", this.catalogs);
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("DataRetriever")) {
            this.dataRetriever = (DataRetriever)node.as(DataRetriever.class);
        }
        if (node.is("Ticket$Min")) {
            this.min = (Min)node.as(Min.class);
        }
        if (node.is("Ticket$Max")) {
            this.max = (Max)node.as(Max.class);
        }
        if (node.is("Ticket$DecimalPlaces")) {
            this.decimalPlaces = (DecimalPlaces)node.as(DecimalPlaces.class);
        }
        if (node.is("Ticket$Range")) {
            this.range = (Range)node.as(Range.class);
        }
        if (node.is("Ticket$Style")) {
            this.style = (Style)node.as(Style.class);
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("DataRetriever")) {
            this.dataRetriever = null;
        }
        if (node.is("Ticket$Min")) {
            this.min = null;
        }
        if (node.is("Ticket$Max")) {
            this.max = null;
        }
        if (node.is("Ticket$DecimalPlaces")) {
            this.decimalPlaces = null;
        }
        if (node.is("Ticket$Range")) {
            this.range = null;
        }
        if (node.is("Ticket$Style")) {
            this.style = null;
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("label")) {
            this.label = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("shortLabel")) {
            this.shortLabel = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("events")) {
            this.events = ConceptLoader.load(values, (Layer)this);
        } else if (name.equalsIgnoreCase("catalogs")) {
            this.catalogs = ConceptLoader.load(values, (Layer)this);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("label")) {
            this.label = (String)values.get(0);
        } else if (name.equalsIgnoreCase("shortLabel")) {
            this.shortLabel = (String)values.get(0);
        } else if (name.equalsIgnoreCase("events")) {
            this.events = new ArrayList(values);
        } else if (name.equalsIgnoreCase("catalogs")) {
            this.catalogs = new ArrayList(values);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public SumusGraph graph() {
        return (SumusGraph)this.core$().graph().as(SumusGraph.class);
    }

    public static class Style
    extends Layer
    implements Feature,
    Terminal {
        protected Line line;
        protected Stacked stacked;
        protected Expression<String> color;

        public Style(Node node) {
            super(node);
        }

        public Line line() {
            return this.line;
        }

        public Stacked stacked() {
            return this.stacked;
        }

        public String color() {
            return (String)this.color.value();
        }

        public Style line(Line value) {
            this.line = value;
            return this;
        }

        public Style stacked(Stacked value) {
            this.stacked = value;
            return this;
        }

        public Style color(Expression<String> value) {
            this.color = (Expression)FunctionLoader.load(value, (Layer)this, Expression.class);
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("line", new ArrayList<Line>(Collections.singletonList(this.line)));
            map.put("stacked", new ArrayList<Stacked>(Collections.singletonList(this.stacked)));
            map.put("color", new ArrayList<Expression<String>>(Collections.singletonList(this.color)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("line")) {
                this.line = (Line)((Object)WordLoader.load(values, Line.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("stacked")) {
                this.stacked = (Stacked)((Object)WordLoader.load(values, Stacked.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("color")) {
                this.color = (Expression)FunctionLoader.load(values, (Layer)this, Expression.class).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("line")) {
                this.line = (Line)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("stacked")) {
                this.stacked = (Stacked)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("color")) {
                this.color = (Expression)FunctionLoader.load(values.get(0), (Layer)this, Expression.class);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Clear {
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }

        public static enum Stacked {
            None,
            Absolute,
            Percentage;

        }

        public static enum Line {
            Continuous,
            ContinuousWithZeros,
            Dotted;

        }
    }

    public static class Range
    extends Layer
    implements Terminal {
        protected TimeScale max;
        protected TimeScale eventHorizon;
        protected TimeScale min;

        public Range(Node node) {
            super(node);
        }

        public TimeScale max() {
            return this.max;
        }

        public TimeScale eventHorizon() {
            return this.eventHorizon;
        }

        public TimeScale min() {
            return this.min;
        }

        public Range max(TimeScale value) {
            this.max = value;
            return this;
        }

        public Range eventHorizon(TimeScale value) {
            this.eventHorizon = value;
            return this;
        }

        public Range min(TimeScale value) {
            this.min = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("max", new ArrayList<TimeScale>(Collections.singletonList(this.max)));
            map.put("eventHorizon", new ArrayList<TimeScale>(Collections.singletonList(this.eventHorizon)));
            map.put("min", new ArrayList<TimeScale>(Collections.singletonList(this.min)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("max")) {
                this.max = (TimeScale)((Object)WordLoader.load(values, TimeScale.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("eventHorizon")) {
                this.eventHorizon = (TimeScale)((Object)WordLoader.load(values, TimeScale.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("min")) {
                this.min = (TimeScale)((Object)WordLoader.load(values, TimeScale.class, (Layer)this).get(0));
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("max")) {
                this.max = (TimeScale)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("eventHorizon")) {
                this.eventHorizon = (TimeScale)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("min")) {
                this.min = (TimeScale)((Object)values.get(0));
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Clear {
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public static class DecimalPlaces
    extends Layer
    implements Feature,
    Terminal {
        protected int absolute;
        protected int percentage;

        public DecimalPlaces(Node node) {
            super(node);
        }

        public int absolute() {
            return this.absolute;
        }

        public int percentage() {
            return this.percentage;
        }

        public DecimalPlaces absolute(int value) {
            this.absolute = value;
            return this;
        }

        public DecimalPlaces percentage(int value) {
            this.percentage = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("absolute", new ArrayList<Integer>(Collections.singletonList(this.absolute)));
            map.put("percentage", new ArrayList<Integer>(Collections.singletonList(this.percentage)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("absolute")) {
                this.absolute = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("percentage")) {
                this.percentage = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("absolute")) {
                this.absolute = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("percentage")) {
                this.percentage = (Integer)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Clear {
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public static class Max
    extends Layer
    implements Terminal {
        protected int value;

        public Max(Node node) {
            super(node);
        }

        public int value() {
            return this.value;
        }

        public Max value(int value) {
            this.value = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("value", new ArrayList<Integer>(Collections.singletonList(this.value)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("value")) {
                this.value = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("value")) {
                this.value = (Integer)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Clear {
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public static class Min
    extends Layer
    implements Terminal {
        protected int value;

        public Min(Node node) {
            super(node);
        }

        public int value() {
            return this.value;
        }

        public Min value(int value) {
            this.value = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("value", new ArrayList<Integer>(Collections.singletonList(this.value)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("value")) {
                this.value = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("value")) {
                this.value = (Integer)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Clear {
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public class Clear {
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Min min(int value) {
            Min newElement = (Min)Ticket.this.core$().graph().concept(Min.class).createNode(this.name, Ticket.this.core$()).as(Min.class);
            newElement.core$().set((Layer)newElement, "value", Collections.singletonList(value));
            return newElement;
        }

        public Max max(int value) {
            Max newElement = (Max)Ticket.this.core$().graph().concept(Max.class).createNode(this.name, Ticket.this.core$()).as(Max.class);
            newElement.core$().set((Layer)newElement, "value", Collections.singletonList(value));
            return newElement;
        }

        public DecimalPlaces decimalPlaces(int absolute) {
            DecimalPlaces newElement = (DecimalPlaces)Ticket.this.core$().graph().concept(DecimalPlaces.class).createNode(this.name, Ticket.this.core$()).as(DecimalPlaces.class);
            newElement.core$().set((Layer)newElement, "absolute", Collections.singletonList(absolute));
            return newElement;
        }

        public Range range(TimeScale max, TimeScale eventHorizon, TimeScale min) {
            Range newElement = (Range)Ticket.this.core$().graph().concept(Range.class).createNode(this.name, Ticket.this.core$()).as(Range.class);
            newElement.core$().set((Layer)newElement, "max", Collections.singletonList(max));
            newElement.core$().set((Layer)newElement, "eventHorizon", Collections.singletonList(eventHorizon));
            newElement.core$().set((Layer)newElement, "min", Collections.singletonList(min));
            return newElement;
        }

        public Style style() {
            Style newElement = (Style)Ticket.this.core$().graph().concept(Style.class).createNode(this.name, Ticket.this.core$()).as(Style.class);
            return newElement;
        }

        public Distribution distribution() {
            Distribution newElement = (Distribution)Ticket.this.core$().graph().concept(Distribution.class).createNode(this.name, Ticket.this.core$()).as(Distribution.class);
            return newElement;
        }

        public StackedIndicator stackedIndicator(String label) {
            StackedIndicator newElement = (StackedIndicator)Ticket.this.core$().graph().concept(StackedIndicator.class).createNode(this.name, Ticket.this.core$()).as(StackedIndicator.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        public MeasureIndicator measureIndicator(String label, AbstractMetric.Unit unit) {
            MeasureIndicator newElement = (MeasureIndicator)Ticket.this.core$().graph().concept(MeasureIndicator.class).createNode(this.name, Ticket.this.core$()).as(MeasureIndicator.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "unit", Collections.singletonList(unit));
            return newElement;
        }
    }
}

