/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.graph;

import io.intino.sumus.graph.DataRetriever;
import io.intino.sumus.graph.SumusGraph;
import io.intino.sumus.graph.Ticket;
import io.intino.sumus.graph.functions.ColorOf;
import io.intino.tara.magritte.Expression;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.FunctionLoader;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Palette
extends Layer
implements Terminal {
    protected ColorOf colorOf;
    protected List<Color> colorList = new ArrayList<Color>();

    public Palette(Node node) {
        super(node);
    }

    public String colorOf(Ticket ticket, DataRetriever dataRetriever, Color.Type type) {
        return this.colorOf.colorOf(ticket, dataRetriever, type);
    }

    public Palette colorOf(ColorOf value) {
        this.colorOf = (ColorOf)FunctionLoader.load((Object)this.colorOf, (Layer)this, ColorOf.class);
        return this;
    }

    public List<Color> colorList() {
        return Collections.unmodifiableList(this.colorList);
    }

    public Color color(int index) {
        return this.colorList.get(index);
    }

    public List<Color> colorList(Predicate<Color> predicate) {
        return this.colorList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        this.colorList.stream().forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("colorOf", this.colorOf != null ? new ArrayList<ColorOf>(Collections.singletonList(this.colorOf)) : Collections.emptyList());
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Palette$Color")) {
            this.colorList.add((Color)node.as(Color.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Palette$Color")) {
            this.colorList.remove(node.as(Color.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("colorOf")) {
            this.colorOf = (ColorOf)FunctionLoader.load(values, (Layer)this, ColorOf.class).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("colorOf")) {
            this.colorOf = (ColorOf)FunctionLoader.load(values.get(0), (Layer)this, ColorOf.class);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public SumusGraph graph() {
        return (SumusGraph)this.core$().graph().as(SumusGraph.class);
    }

    public static class Color
    extends Layer
    implements Terminal {
        protected Ticket ticket;
        protected DataRetriever dataRetriever;
        protected Type type;
        protected Expression<String> id;
        protected String colorCode;

        public Color(Node node) {
            super(node);
        }

        public Ticket ticket() {
            return this.ticket;
        }

        public DataRetriever dataRetriever() {
            return this.dataRetriever;
        }

        public Type type() {
            return this.type;
        }

        public String id() {
            return (String)this.id.value();
        }

        public String colorCode() {
            return this.colorCode;
        }

        public Color ticket(Ticket value) {
            this.ticket = value;
            return this;
        }

        public Color dataRetriever(DataRetriever value) {
            this.dataRetriever = value;
            return this;
        }

        public Color type(Type value) {
            this.type = value;
            return this;
        }

        public Color id(Expression<String> value) {
            this.id = (Expression)FunctionLoader.load(value, (Layer)this, Expression.class);
            return this;
        }

        public Color colorCode(String value) {
            this.colorCode = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("ticket", this.ticket != null ? new ArrayList<Ticket>(Collections.singletonList(this.ticket)) : Collections.emptyList());
            map.put("dataRetriever", this.dataRetriever != null ? new ArrayList<DataRetriever>(Collections.singletonList(this.dataRetriever)) : Collections.emptyList());
            map.put("type", new ArrayList<Type>(Collections.singletonList(this.type)));
            map.put("id", new ArrayList<Expression<String>>(Collections.singletonList(this.id)));
            map.put("colorCode", new ArrayList<String>(Collections.singletonList(this.colorCode)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("ticket")) {
                this.ticket = (Ticket)((Object)NodeLoader.load(values, Ticket.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("dataRetriever")) {
                this.dataRetriever = (DataRetriever)((Object)NodeLoader.load(values, DataRetriever.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("type")) {
                this.type = (Type)((Object)WordLoader.load(values, Type.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("id")) {
                this.id = (Expression)FunctionLoader.load(values, (Layer)this, Expression.class).get(0);
            } else if (name.equalsIgnoreCase("colorCode")) {
                this.colorCode = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("ticket")) {
                this.ticket = values.get(0) != null ? (Ticket)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Ticket.class) : null;
            } else if (name.equalsIgnoreCase("dataRetriever")) {
                this.dataRetriever = values.get(0) != null ? (DataRetriever)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(DataRetriever.class) : null;
            } else if (name.equalsIgnoreCase("type")) {
                this.type = (Type)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("id")) {
                this.id = (Expression)FunctionLoader.load(values.get(0), (Layer)this, Expression.class);
            } else if (name.equalsIgnoreCase("colorCode")) {
                this.colorCode = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Clear {
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }

        public static enum Type {
            Main,
            Max,
            Min,
            Drill1,
            Drill2,
            Drill3,
            Drill4,
            Drill5;

        }
    }

    public class Clear {
        public void color(Predicate<Color> filter) {
            new ArrayList<Color>(Palette.this.colorList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Color color(Ticket ticket, DataRetriever dataRetriever, String colorCode) {
            Color newElement = (Color)Palette.this.core$().graph().concept(Color.class).createNode(this.name, Palette.this.core$()).as(Color.class);
            newElement.core$().set((Layer)newElement, "ticket", Collections.singletonList(ticket));
            newElement.core$().set((Layer)newElement, "dataRetriever", Collections.singletonList(dataRetriever));
            newElement.core$().set((Layer)newElement, "colorCode", Collections.singletonList(colorCode));
            return newElement;
        }
    }
}

