/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.graph;

import io.intino.sumus.datawarehouse.store.Digest;
import io.intino.sumus.graph.AbstractMetric;
import io.intino.sumus.graph.Cube;
import io.intino.sumus.graph.Indicator;
import io.intino.sumus.graph.SumusGraph;
import io.intino.sumus.graph.functions.Calculate;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.FunctionLoader;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.tags.Component;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class MeasureIndicator
extends Indicator
implements Component,
Terminal {
    protected AbstractMetric.Unit unit;
    protected List<Formula> formulaList = new ArrayList<Formula>();

    public MeasureIndicator(Node node) {
        super(node);
    }

    public AbstractMetric.Unit unit() {
        return this.unit;
    }

    public MeasureIndicator unit(AbstractMetric.Unit value) {
        this.unit = value;
        return this;
    }

    public List<Formula> formulaList() {
        return Collections.unmodifiableList(this.formulaList);
    }

    public Formula formula(int index) {
        return this.formulaList.get(index);
    }

    public List<Formula> formulaList(Predicate<Formula> predicate) {
        return this.formulaList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        this.formulaList.stream().forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("unit", this.unit != null ? new ArrayList<AbstractMetric.Unit>(Collections.singletonList(this.unit)) : Collections.emptyList());
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("MeasureIndicator$Formula")) {
            this.formulaList.add((Formula)node.as(Formula.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("MeasureIndicator$Formula")) {
            this.formulaList.remove(node.as(Formula.class));
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("unit")) {
            this.unit = (AbstractMetric.Unit)((Object)NodeLoader.load(values, AbstractMetric.Unit.class, (Layer)this).get(0));
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("unit")) {
            this.unit = values.get(0) != null ? (AbstractMetric.Unit)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(AbstractMetric.Unit.class) : null;
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    @Override
    public Clear clear() {
        return new Clear();
    }

    @Override
    public SumusGraph graph() {
        return (SumusGraph)this.core$().graph().as(SumusGraph.class);
    }

    public static class Formula
    extends Layer
    implements Terminal {
        protected Cube cube;
        protected Calculate calculate;

        public Formula(Node node) {
            super(node);
        }

        public Cube cube() {
            return this.cube;
        }

        public double calculate(List<Digest> digests) {
            return this.calculate.calculate(digests);
        }

        public Formula cube(Cube value) {
            this.cube = value;
            return this;
        }

        public Formula calculate(Calculate value) {
            this.calculate = (Calculate)FunctionLoader.load((Object)this.calculate, (Layer)this, Calculate.class);
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("cube", this.cube != null ? new ArrayList<Cube>(Collections.singletonList(this.cube)) : Collections.emptyList());
            map.put("calculate", this.calculate != null ? new ArrayList<Calculate>(Collections.singletonList(this.calculate)) : Collections.emptyList());
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("cube")) {
                this.cube = (Cube)((Object)NodeLoader.load(values, Cube.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("calculate")) {
                this.calculate = (Calculate)FunctionLoader.load(values, (Layer)this, Calculate.class).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("cube")) {
                this.cube = values.get(0) != null ? (Cube)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Cube.class) : null;
            } else if (name.equalsIgnoreCase("calculate")) {
                this.calculate = (Calculate)FunctionLoader.load(values.get(0), (Layer)this, Calculate.class);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Clear {
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public class Clear
    extends Indicator.Clear {
        public void formula(Predicate<Formula> filter) {
            new ArrayList<Formula>(MeasureIndicator.this.formulaList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create
    extends Indicator.Create {
        public Create(String name) {
            super(name);
        }

        public Formula formula(Cube cube, Calculate calculate) {
            Formula newElement = (Formula)MeasureIndicator.this.core$().graph().concept(Formula.class).createNode(this.name, MeasureIndicator.this.core$()).as(Formula.class);
            newElement.core$().set((Layer)newElement, "cube", Collections.singletonList(cube));
            newElement.core$().set((Layer)newElement, "calculate", Collections.singletonList(calculate));
            return newElement;
        }
    }
}

