/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.graph;

import io.intino.sumus.CategoryMap;
import io.intino.sumus.graph.SumusGraph;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.ObjectLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Filter
extends Layer
implements Terminal {
    protected String label;
    protected String username;
    protected List<Categorization> categorizationList = new ArrayList<Categorization>();

    public Filter(Node node) {
        super(node);
    }

    public String label() {
        return this.label;
    }

    public String username() {
        return this.username;
    }

    public Filter label(String value) {
        this.label = value;
        return this;
    }

    public Filter username(String value) {
        this.username = value;
        return this;
    }

    public List<Categorization> categorizationList() {
        return Collections.unmodifiableList(this.categorizationList);
    }

    public Categorization categorization(int index) {
        return this.categorizationList.get(index);
    }

    public List<Categorization> categorizationList(Predicate<Categorization> predicate) {
        return this.categorizationList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        this.categorizationList.stream().forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
        map.put("username", new ArrayList<String>(Collections.singletonList(this.username)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Filter$Categorization")) {
            this.categorizationList.add((Categorization)node.as(Categorization.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Filter$Categorization")) {
            this.categorizationList.remove(node.as(Categorization.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("label")) {
            this.label = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("username")) {
            this.username = (String)StringLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("label")) {
            this.label = (String)values.get(0);
        } else if (name.equalsIgnoreCase("username")) {
            this.username = (String)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public SumusGraph graph() {
        return (SumusGraph)this.core$().graph().as(SumusGraph.class);
    }

    public static class Categorization
    extends Layer
    implements Terminal {
        protected String name;
        protected CategoryMap categoryMap;

        public Categorization(Node node) {
            super(node);
        }

        public String name() {
            return this.name;
        }

        public CategoryMap categoryMap() {
            return this.categoryMap;
        }

        public Categorization name(String value) {
            this.name = value;
            return this;
        }

        public Categorization categoryMap(CategoryMap value) {
            this.categoryMap = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("name", new ArrayList<String>(Collections.singletonList(this.name)));
            map.put("categoryMap", new ArrayList<CategoryMap>(Collections.singletonList(this.categoryMap)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("name")) {
                this.name = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("categoryMap")) {
                this.categoryMap = (CategoryMap)ObjectLoader.load(values, CategoryMap.class, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("name")) {
                this.name = (String)values.get(0);
            } else if (name.equalsIgnoreCase("categoryMap")) {
                this.categoryMap = (CategoryMap)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Clear {
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public class Clear {
        public void categorization(Predicate<Categorization> filter) {
            new ArrayList<Categorization>(Filter.this.categorizationList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Categorization categorization(String name) {
            Categorization newElement = (Categorization)Filter.this.core$().graph().concept(Categorization.class).createNode(name, Filter.this.core$()).as(Categorization.class);
            newElement.core$().set((Layer)newElement, "name", Collections.singletonList(name));
            return newElement;
        }
    }
}

