/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.graph;

import io.intino.sumus.graph.Event;
import io.intino.sumus.graph.SumusGraph;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.BooleanLoader;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Episode
extends Event {
    protected boolean isClosed;
    protected List<Event> eventList = new ArrayList<Event>();

    public Episode(Node node) {
        super(node);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public Episode isClosed(boolean value) {
        this.isClosed = value;
        return this;
    }

    public List<Event> eventList() {
        return Collections.unmodifiableList(this.eventList);
    }

    public Event event(int index) {
        return this.eventList.get(index);
    }

    public List<Event> eventList(Predicate<Event> predicate) {
        return this.eventList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        this.eventList.stream().forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("isClosed", new ArrayList<Boolean>(Collections.singletonList(this.isClosed)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Event")) {
            this.eventList.add((Event)node.as(Event.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Event")) {
            this.eventList.remove(node.as(Event.class));
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("isClosed")) {
            this.isClosed = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("isClosed")) {
            this.isClosed = (Boolean)values.get(0);
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    @Override
    public Clear clear() {
        return new Clear();
    }

    @Override
    public SumusGraph graph() {
        return (SumusGraph)this.core$().graph().as(SumusGraph.class);
    }

    public class Clear
    extends Event.Clear {
        public Clear() {
            super(Episode.this);
        }

        public void event(Predicate<Event> filter) {
            new ArrayList<Event>(Episode.this.eventList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create
    extends Event.Create {
        public Create(String name) {
            super(Episode.this, name);
        }

        public Event event(Instant created) {
            Event newElement = (Event)Episode.this.core$().graph().concept(Event.class).createNode(this.name, Episode.this.core$()).as(Event.class);
            newElement.core$().set((Layer)newElement, "created", Collections.singletonList(created));
            return newElement;
        }
    }
}

