/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.graph;

import io.intino.sumus.datawarehouse.store.Bucket;
import io.intino.sumus.datawarehouse.store.Digest;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.SumusGraph;
import io.intino.sumus.graph.functions.GetBucket;
import io.intino.sumus.graph.functions.GetDigest;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.BooleanLoader;
import io.intino.tara.magritte.loaders.ConceptLoader;
import io.intino.tara.magritte.loaders.FunctionLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Cube
extends Layer
implements Terminal {
    protected GetBucket getBucket;
    protected GetBucket getOrCreateBucket;
    protected GetDigest getDigest;
    protected List<Dimension> dimensionList = new ArrayList<Dimension>();
    protected List<Property> propertyList = new ArrayList<Property>();

    public Cube(Node node) {
        super(node);
    }

    public Bucket getBucket(NameSpace nameSpace, TimeScale scale, Instant instant) {
        return this.getBucket.get(nameSpace, scale, instant);
    }

    public Bucket getOrCreateBucket(NameSpace nameSpace, TimeScale scale, Instant instant) {
        return this.getOrCreateBucket.get(nameSpace, scale, instant);
    }

    public Digest getDigest(String ref) {
        return this.getDigest.digest(ref);
    }

    public Cube getBucket(GetBucket value) {
        this.getBucket = (GetBucket)FunctionLoader.load((Object)this.getBucket, (Layer)this, GetBucket.class);
        return this;
    }

    public Cube getOrCreateBucket(GetBucket value) {
        this.getOrCreateBucket = (GetBucket)FunctionLoader.load((Object)this.getOrCreateBucket, (Layer)this, GetBucket.class);
        return this;
    }

    public Cube getDigest(GetDigest value) {
        this.getDigest = (GetDigest)FunctionLoader.load((Object)this.getDigest, (Layer)this, GetDigest.class);
        return this;
    }

    public List<Dimension> dimensionList() {
        return Collections.unmodifiableList(this.dimensionList);
    }

    public Dimension dimension(int index) {
        return this.dimensionList.get(index);
    }

    public List<Dimension> dimensionList(Predicate<Dimension> predicate) {
        return this.dimensionList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Property> propertyList() {
        return Collections.unmodifiableList(this.propertyList);
    }

    public Property property(int index) {
        return this.propertyList.get(index);
    }

    public List<Property> propertyList(Predicate<Property> predicate) {
        return this.propertyList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        this.dimensionList.stream().forEach(c -> components.add(c.core$()));
        this.propertyList.stream().forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("getBucket", this.getBucket != null ? new ArrayList<GetBucket>(Collections.singletonList(this.getBucket)) : Collections.emptyList());
        map.put("getOrCreateBucket", this.getOrCreateBucket != null ? new ArrayList<GetBucket>(Collections.singletonList(this.getOrCreateBucket)) : Collections.emptyList());
        map.put("getDigest", this.getDigest != null ? new ArrayList<GetDigest>(Collections.singletonList(this.getDigest)) : Collections.emptyList());
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Cube$Dimension")) {
            this.dimensionList.add((Dimension)node.as(Dimension.class));
        }
        if (node.is("Cube$Property")) {
            this.propertyList.add((Property)node.as(Property.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Cube$Dimension")) {
            this.dimensionList.remove(node.as(Dimension.class));
        }
        if (node.is("Cube$Property")) {
            this.propertyList.remove(node.as(Property.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("getBucket")) {
            this.getBucket = (GetBucket)FunctionLoader.load(values, (Layer)this, GetBucket.class).get(0);
        } else if (name.equalsIgnoreCase("getOrCreateBucket")) {
            this.getOrCreateBucket = (GetBucket)FunctionLoader.load(values, (Layer)this, GetBucket.class).get(0);
        } else if (name.equalsIgnoreCase("getDigest")) {
            this.getDigest = (GetDigest)FunctionLoader.load(values, (Layer)this, GetDigest.class).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("getBucket")) {
            this.getBucket = (GetBucket)FunctionLoader.load(values.get(0), (Layer)this, GetBucket.class);
        } else if (name.equalsIgnoreCase("getOrCreateBucket")) {
            this.getOrCreateBucket = (GetBucket)FunctionLoader.load(values.get(0), (Layer)this, GetBucket.class);
        } else if (name.equalsIgnoreCase("getDigest")) {
            this.getDigest = (GetDigest)FunctionLoader.load(values.get(0), (Layer)this, GetDigest.class);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public SumusGraph graph() {
        return (SumusGraph)this.core$().graph().as(SumusGraph.class);
    }

    public static class Property
    extends Layer
    implements Terminal {
        protected String label;
        protected Type type;
        protected boolean extended;

        public Property(Node node) {
            super(node);
        }

        public String label() {
            return this.label;
        }

        public Type type() {
            return this.type;
        }

        public boolean extended() {
            return this.extended;
        }

        public Property label(String value) {
            this.label = value;
            return this;
        }

        public Property type(Type value) {
            this.type = value;
            return this;
        }

        public Property extended(boolean value) {
            this.extended = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
            map.put("type", new ArrayList<Type>(Collections.singletonList(this.type)));
            map.put("extended", new ArrayList<Boolean>(Collections.singletonList(this.extended)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("label")) {
                this.label = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("type")) {
                this.type = (Type)((Object)WordLoader.load(values, Type.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("extended")) {
                this.extended = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("label")) {
                this.label = (String)values.get(0);
            } else if (name.equalsIgnoreCase("type")) {
                this.type = (Type)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("extended")) {
                this.extended = (Boolean)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Clear {
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }

        public static enum Type {
            Integer,
            Float;

        }
    }

    public static class Dimension
    extends Layer
    implements Terminal {
        protected Concept entity;

        public Dimension(Node node) {
            super(node);
        }

        public Concept entity() {
            return this.entity;
        }

        public Dimension entity(Concept value) {
            this.entity = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("entity", this.entity != null ? new ArrayList<Concept>(Collections.singletonList(this.entity)) : Collections.emptyList());
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("entity")) {
                this.entity = (Concept)ConceptLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("entity")) {
                this.entity = (Concept)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Clear {
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public class Clear {
        public void dimension(Predicate<Dimension> filter) {
            new ArrayList<Dimension>(Cube.this.dimensionList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void property(Predicate<Property> filter) {
            new ArrayList<Property>(Cube.this.propertyList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Dimension dimension(Concept entity) {
            Dimension newElement = (Dimension)Cube.this.core$().graph().concept(Dimension.class).createNode(this.name, Cube.this.core$()).as(Dimension.class);
            newElement.core$().set((Layer)newElement, "entity", Collections.singletonList(entity));
            return newElement;
        }

        public Property property(String label, Property.Type type) {
            Property newElement = (Property)Cube.this.core$().graph().concept(Property.class).createNode(this.name, Cube.this.core$()).as(Property.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "type", Collections.singletonList(type));
            return newElement;
        }
    }
}

