/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.graph;

import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Cluster;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Olap;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.SumusGraph;
import io.intino.sumus.graph.base64icon.catalog.mold.block.Base64IconStamp;
import io.intino.sumus.graph.breadcrumbs.catalog.mold.block.BreadcrumbsStamp;
import io.intino.sumus.graph.container.ContainerCatalog;
import io.intino.sumus.graph.description.catalog.mold.block.DescriptionStamp;
import io.intino.sumus.graph.display.catalog.mold.block.DisplayStamp;
import io.intino.sumus.graph.downloadoperation.catalog.mold.block.DownloadOperationStamp;
import io.intino.sumus.graph.entitycontainer.EntityContainerCatalog;
import io.intino.sumus.graph.eventcontainer.EventContainerCatalog;
import io.intino.sumus.graph.expanded.catalog.mold.ExpandedBlock;
import io.intino.sumus.graph.externalpage.catalog.mold.block.ExternalPageStamp;
import io.intino.sumus.graph.functions.CatalogSortingComparator;
import io.intino.sumus.graph.functions.CatalogStampBreadcrumbsTree;
import io.intino.sumus.graph.functions.CatalogStampColor;
import io.intino.sumus.graph.functions.CatalogStampDoubleValue;
import io.intino.sumus.graph.functions.CatalogStampDownload;
import io.intino.sumus.graph.functions.CatalogStampHyperlinks;
import io.intino.sumus.graph.functions.CatalogStampPagePath;
import io.intino.sumus.graph.functions.CatalogStampPageUrl;
import io.intino.sumus.graph.functions.CatalogStampResourceValue;
import io.intino.sumus.graph.functions.CatalogStampTextValue;
import io.intino.sumus.graph.functions.CatalogStampValue;
import io.intino.sumus.graph.highlight.catalog.mold.block.HighlightStamp;
import io.intino.sumus.graph.hyperlinks.catalog.mold.block.HyperlinksStamp;
import io.intino.sumus.graph.icon.catalog.mold.block.IconStamp;
import io.intino.sumus.graph.internalpage.catalog.mold.block.InternalPageStamp;
import io.intino.sumus.graph.location.catalog.mold.block.LocationStamp;
import io.intino.sumus.graph.opendialogoperation.catalog.mold.block.OpenDialogOperationStamp;
import io.intino.sumus.graph.operation.catalog.mold.block.OperationStamp;
import io.intino.sumus.graph.page.catalog.mold.block.PageStamp;
import io.intino.sumus.graph.picture.catalog.mold.block.PictureStamp;
import io.intino.sumus.graph.polymericon.catalog.mold.block.PolymerIconStamp;
import io.intino.sumus.graph.rating.catalog.mold.block.RatingStamp;
import io.intino.sumus.graph.reportcontainer.ReportContainerCatalog;
import io.intino.sumus.graph.resourceicon.catalog.mold.block.ResourceIconStamp;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.sumus.graph.shape.catalog.mold.block.ShapeStamp;
import io.intino.sumus.graph.snippet.catalog.mold.block.SnippetStamp;
import io.intino.sumus.graph.temporalcontainer.TemporalContainerCatalog;
import io.intino.sumus.graph.title.catalog.mold.block.TitleStamp;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Expression;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.BooleanLoader;
import io.intino.tara.magritte.loaders.DoubleLoader;
import io.intino.tara.magritte.loaders.FunctionLoader;
import io.intino.tara.magritte.loaders.IntegerLoader;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Catalog
extends Layer
implements Terminal {
    protected String label;
    protected List<View> viewList = new ArrayList<View>();
    protected List<MagazineView> magazineViewList = new ArrayList<MagazineView>();
    protected List<ListView> listViewList = new ArrayList<ListView>();
    protected List<GridView> gridViewList = new ArrayList<GridView>();
    protected List<MapView> mapViewList = new ArrayList<MapView>();
    protected List<OlapView> olapViewList = new ArrayList<OlapView>();
    protected List<Mold> moldList = new ArrayList<Mold>();
    protected List<Sorting> sortingList = new ArrayList<Sorting>();
    protected List<AbstractGrouping> abstractGroupingList = new ArrayList<AbstractGrouping>();
    protected List<Grouping> groupingList = new ArrayList<Grouping>();
    protected List<ClusterGrouping> clusterGroupingList = new ArrayList<ClusterGrouping>();

    public Catalog(Node node) {
        super(node);
    }

    public String label() {
        return this.label;
    }

    public Catalog label(String value) {
        this.label = value;
        return this;
    }

    public List<View> viewList() {
        return Collections.unmodifiableList(this.viewList);
    }

    public View view(int index) {
        return this.viewList.get(index);
    }

    public List<View> viewList(Predicate<View> predicate) {
        return this.viewList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<MagazineView> magazineViewList() {
        return Collections.unmodifiableList(this.magazineViewList);
    }

    public MagazineView magazineView(int index) {
        return this.magazineViewList.get(index);
    }

    public List<MagazineView> magazineViewList(Predicate<MagazineView> predicate) {
        return this.magazineViewList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<ListView> listViewList() {
        return Collections.unmodifiableList(this.listViewList);
    }

    public ListView listView(int index) {
        return this.listViewList.get(index);
    }

    public List<ListView> listViewList(Predicate<ListView> predicate) {
        return this.listViewList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<GridView> gridViewList() {
        return Collections.unmodifiableList(this.gridViewList);
    }

    public GridView gridView(int index) {
        return this.gridViewList.get(index);
    }

    public List<GridView> gridViewList(Predicate<GridView> predicate) {
        return this.gridViewList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<MapView> mapViewList() {
        return Collections.unmodifiableList(this.mapViewList);
    }

    public MapView mapView(int index) {
        return this.mapViewList.get(index);
    }

    public List<MapView> mapViewList(Predicate<MapView> predicate) {
        return this.mapViewList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<OlapView> olapViewList() {
        return Collections.unmodifiableList(this.olapViewList);
    }

    public OlapView olapView(int index) {
        return this.olapViewList.get(index);
    }

    public List<OlapView> olapViewList(Predicate<OlapView> predicate) {
        return this.olapViewList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Mold> moldList() {
        return Collections.unmodifiableList(this.moldList);
    }

    public Mold mold(int index) {
        return this.moldList.get(index);
    }

    public List<Mold> moldList(Predicate<Mold> predicate) {
        return this.moldList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Sorting> sortingList() {
        return Collections.unmodifiableList(this.sortingList);
    }

    public Sorting sorting(int index) {
        return this.sortingList.get(index);
    }

    public List<Sorting> sortingList(Predicate<Sorting> predicate) {
        return this.sortingList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<AbstractGrouping> abstractGroupingList() {
        return Collections.unmodifiableList(this.abstractGroupingList);
    }

    public AbstractGrouping abstractGrouping(int index) {
        return this.abstractGroupingList.get(index);
    }

    public List<AbstractGrouping> abstractGroupingList(Predicate<AbstractGrouping> predicate) {
        return this.abstractGroupingList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Grouping> groupingList() {
        return Collections.unmodifiableList(this.groupingList);
    }

    public Grouping grouping(int index) {
        return this.groupingList.get(index);
    }

    public List<Grouping> groupingList(Predicate<Grouping> predicate) {
        return this.groupingList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<ClusterGrouping> clusterGroupingList() {
        return Collections.unmodifiableList(this.clusterGroupingList);
    }

    public ClusterGrouping clusterGrouping(int index) {
        return this.clusterGroupingList.get(index);
    }

    public List<ClusterGrouping> clusterGroupingList(Predicate<ClusterGrouping> predicate) {
        return this.clusterGroupingList().stream().filter(predicate).collect(Collectors.toList());
    }

    public ContainerCatalog asContainer() {
        Layer as = this.core$().as(ContainerCatalog.class);
        return as != null ? (ContainerCatalog)as : null;
    }

    public boolean isContainer() {
        return this.core$().is(ContainerCatalog.class);
    }

    public EventContainerCatalog asEventContainer() {
        return (EventContainerCatalog)this.core$().as(EventContainerCatalog.class);
    }

    public EventContainerCatalog asEventContainer(List<TimeScale> scales, NameSpace nameSpace, Concept event) {
        EventContainerCatalog newElement = (EventContainerCatalog)this.core$().addFacet(EventContainerCatalog.class);
        newElement.core$().set((Layer)newElement, "scales", scales);
        newElement.core$().set((Layer)newElement, "nameSpace", Collections.singletonList(nameSpace));
        newElement.core$().set((Layer)newElement, "event", Collections.singletonList(event));
        return newElement;
    }

    public boolean isEventContainer() {
        return this.core$().is(EventContainerCatalog.class);
    }

    public void removeEventContainer() {
        this.core$().removeFacet(EventContainerCatalog.class);
    }

    public EntityContainerCatalog asEntityContainer() {
        return (EntityContainerCatalog)this.core$().as(EntityContainerCatalog.class);
    }

    public EntityContainerCatalog asEntityContainer(Concept entity) {
        EntityContainerCatalog newElement = (EntityContainerCatalog)this.core$().addFacet(EntityContainerCatalog.class);
        newElement.core$().set((Layer)newElement, "entity", Collections.singletonList(entity));
        return newElement;
    }

    public boolean isEntityContainer() {
        return this.core$().is(EntityContainerCatalog.class);
    }

    public void removeEntityContainer() {
        this.core$().removeFacet(EntityContainerCatalog.class);
    }

    public ReportContainerCatalog asReportContainer() {
        return (ReportContainerCatalog)this.core$().as(ReportContainerCatalog.class);
    }

    public ReportContainerCatalog asReportContainer(List<TimeScale> scales, NameSpace nameSpace, Concept report) {
        ReportContainerCatalog newElement = (ReportContainerCatalog)this.core$().addFacet(ReportContainerCatalog.class);
        newElement.core$().set((Layer)newElement, "scales", scales);
        newElement.core$().set((Layer)newElement, "nameSpace", Collections.singletonList(nameSpace));
        newElement.core$().set((Layer)newElement, "report", Collections.singletonList(report));
        return newElement;
    }

    public boolean isReportContainer() {
        return this.core$().is(ReportContainerCatalog.class);
    }

    public void removeReportContainer() {
        this.core$().removeFacet(ReportContainerCatalog.class);
    }

    public TemporalContainerCatalog asTemporalContainer() {
        return (TemporalContainerCatalog)this.core$().as(TemporalContainerCatalog.class);
    }

    public TemporalContainerCatalog asTemporalContainer(List<TimeScale> scales, NameSpace nameSpace) {
        TemporalContainerCatalog newElement = (TemporalContainerCatalog)this.core$().addFacet(TemporalContainerCatalog.class);
        newElement.core$().set((Layer)newElement, "scales", scales);
        newElement.core$().set((Layer)newElement, "nameSpace", Collections.singletonList(nameSpace));
        return newElement;
    }

    public boolean isTemporalContainer() {
        return this.core$().is(TemporalContainerCatalog.class);
    }

    public void removeTemporalContainer() {
        this.core$().removeFacet(TemporalContainerCatalog.class);
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        this.viewList.stream().forEach(c -> components.add(c.core$()));
        this.magazineViewList.stream().forEach(c -> components.add(c.core$()));
        this.listViewList.stream().forEach(c -> components.add(c.core$()));
        this.gridViewList.stream().forEach(c -> components.add(c.core$()));
        this.mapViewList.stream().forEach(c -> components.add(c.core$()));
        this.olapViewList.stream().forEach(c -> components.add(c.core$()));
        this.moldList.stream().forEach(c -> components.add(c.core$()));
        this.sortingList.stream().forEach(c -> components.add(c.core$()));
        this.abstractGroupingList.stream().forEach(c -> components.add(c.core$()));
        this.groupingList.stream().forEach(c -> components.add(c.core$()));
        this.clusterGroupingList.stream().forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Catalog$View")) {
            this.viewList.add((View)node.as(View.class));
        }
        if (node.is("Catalog$MagazineView")) {
            this.magazineViewList.add((MagazineView)node.as(MagazineView.class));
        }
        if (node.is("Catalog$ListView")) {
            this.listViewList.add((ListView)node.as(ListView.class));
        }
        if (node.is("Catalog$GridView")) {
            this.gridViewList.add((GridView)node.as(GridView.class));
        }
        if (node.is("Catalog$MapView")) {
            this.mapViewList.add((MapView)node.as(MapView.class));
        }
        if (node.is("Catalog$OlapView")) {
            this.olapViewList.add((OlapView)node.as(OlapView.class));
        }
        if (node.is("Catalog$Mold")) {
            this.moldList.add((Mold)node.as(Mold.class));
        }
        if (node.is("Catalog$Sorting")) {
            this.sortingList.add((Sorting)node.as(Sorting.class));
        }
        if (node.is("Catalog$AbstractGrouping")) {
            this.abstractGroupingList.add((AbstractGrouping)node.as(AbstractGrouping.class));
        }
        if (node.is("Catalog$Grouping")) {
            this.groupingList.add((Grouping)node.as(Grouping.class));
        }
        if (node.is("Catalog$ClusterGrouping")) {
            this.clusterGroupingList.add((ClusterGrouping)node.as(ClusterGrouping.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Catalog$View")) {
            this.viewList.remove(node.as(View.class));
        }
        if (node.is("Catalog$MagazineView")) {
            this.magazineViewList.remove(node.as(MagazineView.class));
        }
        if (node.is("Catalog$ListView")) {
            this.listViewList.remove(node.as(ListView.class));
        }
        if (node.is("Catalog$GridView")) {
            this.gridViewList.remove(node.as(GridView.class));
        }
        if (node.is("Catalog$MapView")) {
            this.mapViewList.remove(node.as(MapView.class));
        }
        if (node.is("Catalog$OlapView")) {
            this.olapViewList.remove(node.as(OlapView.class));
        }
        if (node.is("Catalog$Mold")) {
            this.moldList.remove(node.as(Mold.class));
        }
        if (node.is("Catalog$Sorting")) {
            this.sortingList.remove(node.as(Sorting.class));
        }
        if (node.is("Catalog$AbstractGrouping")) {
            this.abstractGroupingList.remove(node.as(AbstractGrouping.class));
        }
        if (node.is("Catalog$Grouping")) {
            this.groupingList.remove(node.as(Grouping.class));
        }
        if (node.is("Catalog$ClusterGrouping")) {
            this.clusterGroupingList.remove(node.as(ClusterGrouping.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("label")) {
            this.label = (String)StringLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("label")) {
            this.label = (String)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public SumusGraph graph() {
        return (SumusGraph)this.core$().graph().as(SumusGraph.class);
    }

    public static class ClusterGrouping
    extends AbstractGrouping
    implements Terminal {
        protected Cluster cluster;

        public ClusterGrouping(Node node) {
            super(node);
        }

        public Cluster cluster() {
            return this.cluster;
        }

        public ClusterGrouping cluster(Cluster value) {
            this.cluster = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("cluster", this.cluster != null ? new ArrayList<Cluster>(Collections.singletonList(this.cluster)) : Collections.emptyList());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("cluster")) {
                this.cluster = (Cluster)((Object)NodeLoader.load(values, Cluster.class, (Layer)this).get(0));
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("cluster")) {
                this.cluster = values.get(0) != null ? (Cluster)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Cluster.class) : null;
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public Clear clear() {
            return new Clear();
        }

        @Override
        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Clear
        extends AbstractGrouping.Clear {
        }

        public class Create
        extends AbstractGrouping.Create {
            public Create(String name) {
                super(name);
            }
        }
    }

    public static class Grouping
    extends AbstractGrouping
    implements Terminal {
        protected Categorization categorization;

        public Grouping(Node node) {
            super(node);
        }

        public Categorization categorization() {
            return this.categorization;
        }

        public Grouping categorization(Categorization value) {
            this.categorization = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("categorization", this.categorization != null ? new ArrayList<Categorization>(Collections.singletonList(this.categorization)) : Collections.emptyList());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("categorization")) {
                this.categorization = (Categorization)((Object)NodeLoader.load(values, Categorization.class, (Layer)this).get(0));
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("categorization")) {
                this.categorization = values.get(0) != null ? (Categorization)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Categorization.class) : null;
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public Clear clear() {
            return new Clear();
        }

        @Override
        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Clear
        extends AbstractGrouping.Clear {
        }

        public class Create
        extends AbstractGrouping.Create {
            public Create(String name) {
                super(name);
            }
        }
    }

    public static abstract class AbstractGrouping
    extends Layer
    implements Terminal {
        protected Expression<String> label;
        protected Histogram histogram;

        public AbstractGrouping(Node node) {
            super(node);
        }

        public String label() {
            return (String)this.label.value();
        }

        public Histogram histogram() {
            return this.histogram;
        }

        public AbstractGrouping label(Expression<String> value) {
            this.label = (Expression)FunctionLoader.load(value, (Layer)this, Expression.class);
            return this;
        }

        public AbstractGrouping histogram(Histogram value) {
            this.histogram = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("label", new ArrayList<Expression<String>>(Collections.singletonList(this.label)));
            map.put("histogram", new ArrayList<Histogram>(Collections.singletonList(this.histogram)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("label")) {
                this.label = (Expression)FunctionLoader.load(values, (Layer)this, Expression.class).get(0);
            } else if (name.equalsIgnoreCase("histogram")) {
                this.histogram = (Histogram)((Object)WordLoader.load(values, Histogram.class, (Layer)this).get(0));
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("label")) {
                this.label = (Expression)FunctionLoader.load(values.get(0), (Layer)this, Expression.class);
            } else if (name.equalsIgnoreCase("histogram")) {
                this.histogram = (Histogram)((Object)values.get(0));
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Clear {
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }

        public static enum Histogram {
            Percentage,
            Absolute;

        }
    }

    public static class Sorting
    extends Layer
    implements Terminal {
        protected String label;
        protected CatalogSortingComparator comparator;

        public Sorting(Node node) {
            super(node);
        }

        public String label() {
            return this.label;
        }

        public int comparator(Record record1, Record record2) {
            return this.comparator.compare(record1, record2);
        }

        public Sorting label(String value) {
            this.label = value;
            return this;
        }

        public Sorting comparator(CatalogSortingComparator value) {
            this.comparator = (CatalogSortingComparator)FunctionLoader.load((Object)this.comparator, (Layer)this, CatalogSortingComparator.class);
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
            map.put("comparator", this.comparator != null ? new ArrayList<CatalogSortingComparator>(Collections.singletonList(this.comparator)) : Collections.emptyList());
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("label")) {
                this.label = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("comparator")) {
                this.comparator = (CatalogSortingComparator)FunctionLoader.load(values, (Layer)this, CatalogSortingComparator.class).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("label")) {
                this.label = (String)values.get(0);
            } else if (name.equalsIgnoreCase("comparator")) {
                this.comparator = (CatalogSortingComparator)FunctionLoader.load(values.get(0), (Layer)this, CatalogSortingComparator.class);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Clear {
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public static class Mold
    extends Layer
    implements Terminal {
        protected List<Block> blockList = new ArrayList<Block>();

        public Mold(Node node) {
            super(node);
        }

        public List<Block> blockList() {
            return Collections.unmodifiableList(this.blockList);
        }

        public Block block(int index) {
            return this.blockList.get(index);
        }

        public List<Block> blockList(Predicate<Block> predicate) {
            return this.blockList().stream().filter(predicate).collect(Collectors.toList());
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            this.blockList.stream().forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Catalog$Mold$Block")) {
                this.blockList.add((Block)node.as(Block.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Catalog$Mold$Block")) {
                this.blockList.remove(node.as(Block.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public static class Block
        extends Layer
        implements Terminal {
            protected List<Layout> layout = new ArrayList<Layout>();
            protected int width;
            protected boolean hiddenIfMobile;
            protected List<Block> blockList = new ArrayList<Block>();
            protected List<Stamp> stampList = new ArrayList<Stamp>();

            public Block(Node node) {
                super(node);
            }

            public List<Layout> layout() {
                return this.layout;
            }

            public int width() {
                return this.width;
            }

            public boolean hiddenIfMobile() {
                return this.hiddenIfMobile;
            }

            public Block width(int value) {
                this.width = value;
                return this;
            }

            public Block hiddenIfMobile(boolean value) {
                this.hiddenIfMobile = value;
                return this;
            }

            public List<Block> blockList() {
                return Collections.unmodifiableList(this.blockList);
            }

            public Block block(int index) {
                return this.blockList.get(index);
            }

            public List<Block> blockList(Predicate<Block> predicate) {
                return this.blockList().stream().filter(predicate).collect(Collectors.toList());
            }

            public List<Stamp> stampList() {
                return Collections.unmodifiableList(this.stampList);
            }

            public Stamp stamp(int index) {
                return this.stampList.get(index);
            }

            public List<Stamp> stampList(Predicate<Stamp> predicate) {
                return this.stampList().stream().filter(predicate).collect(Collectors.toList());
            }

            public ExpandedBlock asExpanded() {
                Layer as = this.core$().as(ExpandedBlock.class);
                return as != null ? (ExpandedBlock)as : (ExpandedBlock)this.core$().addFacet(ExpandedBlock.class);
            }

            public boolean isExpanded() {
                return this.core$().is(ExpandedBlock.class);
            }

            protected List<Node> componentList$() {
                LinkedHashSet components = new LinkedHashSet(super.componentList$());
                this.blockList.stream().forEach(c -> components.add(c.core$()));
                this.stampList.stream().forEach(c -> components.add(c.core$()));
                return new ArrayList<Node>(components);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("layout", this.layout);
                map.put("width", new ArrayList<Integer>(Collections.singletonList(this.width)));
                map.put("hiddenIfMobile", new ArrayList<Boolean>(Collections.singletonList(this.hiddenIfMobile)));
                return map;
            }

            protected void addNode$(Node node) {
                super.addNode$(node);
                if (node.is("Catalog$Mold$Block")) {
                    this.blockList.add((Block)node.as(Block.class));
                }
                if (node.is("Catalog$Mold$Block$Stamp")) {
                    this.stampList.add((Stamp)node.as(Stamp.class));
                }
            }

            protected void removeNode$(Node node) {
                super.removeNode$(node);
                if (node.is("Catalog$Mold$Block")) {
                    this.blockList.remove(node.as(Block.class));
                }
                if (node.is("Catalog$Mold$Block$Stamp")) {
                    this.stampList.remove(node.as(Stamp.class));
                }
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("layout")) {
                    this.layout = WordLoader.load(values, Layout.class, (Layer)this);
                } else if (name.equalsIgnoreCase("width")) {
                    this.width = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("hiddenIfMobile")) {
                    this.hiddenIfMobile = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("layout")) {
                    this.layout = new ArrayList(values);
                } else if (name.equalsIgnoreCase("width")) {
                    this.width = (Integer)values.get(0);
                } else if (name.equalsIgnoreCase("hiddenIfMobile")) {
                    this.hiddenIfMobile = (Boolean)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }

            public static class Stamp
            extends Layer
            implements Terminal {
                protected String label;
                protected CatalogStampValue internalValue;
                protected Layout layout;
                protected int height;

                public Stamp(Node node) {
                    super(node);
                }

                public String label() {
                    return this.label;
                }

                public Object internalValue(Record record) {
                    return this.internalValue.value(record);
                }

                public Layout layout() {
                    return this.layout;
                }

                public int height() {
                    return this.height;
                }

                public Stamp label(String value) {
                    this.label = value;
                    return this;
                }

                public Stamp internalValue(CatalogStampValue value) {
                    this.internalValue = (CatalogStampValue)FunctionLoader.load((Object)this.internalValue, (Layer)this, CatalogStampValue.class);
                    return this;
                }

                public Stamp layout(Layout value) {
                    this.layout = value;
                    return this;
                }

                public Stamp height(int value) {
                    this.height = value;
                    return this;
                }

                public PolymerIconStamp asPolymerIcon() {
                    return (PolymerIconStamp)this.core$().as(PolymerIconStamp.class);
                }

                public PolymerIconStamp asPolymerIcon(CatalogStampTextValue icon) {
                    PolymerIconStamp newElement = (PolymerIconStamp)this.core$().addFacet(PolymerIconStamp.class);
                    newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
                    return newElement;
                }

                public boolean isPolymerIcon() {
                    return this.core$().is(PolymerIconStamp.class);
                }

                public void removePolymerIcon() {
                    this.core$().removeFacet(PolymerIconStamp.class);
                }

                public ShapeStamp asShape() {
                    Layer as = this.core$().as(ShapeStamp.class);
                    return as != null ? (ShapeStamp)as : null;
                }

                public boolean isShape() {
                    return this.core$().is(ShapeStamp.class);
                }

                public HighlightStamp asHighlight() {
                    return (HighlightStamp)this.core$().as(HighlightStamp.class);
                }

                public HighlightStamp asHighlight(CatalogStampTextValue value, CatalogStampColor color) {
                    HighlightStamp newElement = (HighlightStamp)this.core$().addFacet(HighlightStamp.class);
                    newElement.core$().set((Layer)newElement, "value", Collections.singletonList(value));
                    newElement.core$().set((Layer)newElement, "color", Collections.singletonList(color));
                    return newElement;
                }

                public boolean isHighlight() {
                    return this.core$().is(HighlightStamp.class);
                }

                public void removeHighlight() {
                    this.core$().removeFacet(HighlightStamp.class);
                }

                public DescriptionStamp asDescription() {
                    return (DescriptionStamp)this.core$().as(DescriptionStamp.class);
                }

                public DescriptionStamp asDescription(CatalogStampTextValue description) {
                    DescriptionStamp newElement = (DescriptionStamp)this.core$().addFacet(DescriptionStamp.class);
                    newElement.core$().set((Layer)newElement, "description", Collections.singletonList(description));
                    return newElement;
                }

                public boolean isDescription() {
                    return this.core$().is(DescriptionStamp.class);
                }

                public void removeDescription() {
                    this.core$().removeFacet(DescriptionStamp.class);
                }

                public DownloadOperationStamp asDownloadOperation() {
                    return (DownloadOperationStamp)this.core$().as(DownloadOperationStamp.class);
                }

                public DownloadOperationStamp asDownloadOperation(CatalogStampDownload execute) {
                    DownloadOperationStamp newElement = (DownloadOperationStamp)this.core$().addFacet(DownloadOperationStamp.class);
                    newElement.core$().set((Layer)newElement, "execute", Collections.singletonList(execute));
                    return newElement;
                }

                public boolean isDownloadOperation() {
                    return this.core$().is(DownloadOperationStamp.class);
                }

                public void removeDownloadOperation() {
                    this.core$().removeFacet(DownloadOperationStamp.class);
                }

                public OpenDialogOperationStamp asOpenDialogOperation() {
                    return (OpenDialogOperationStamp)this.core$().as(OpenDialogOperationStamp.class);
                }

                public OpenDialogOperationStamp asOpenDialogOperation(CatalogStampPagePath path) {
                    OpenDialogOperationStamp newElement = (OpenDialogOperationStamp)this.core$().addFacet(OpenDialogOperationStamp.class);
                    newElement.core$().set((Layer)newElement, "path", Collections.singletonList(path));
                    return newElement;
                }

                public boolean isOpenDialogOperation() {
                    return this.core$().is(OpenDialogOperationStamp.class);
                }

                public void removeOpenDialogOperation() {
                    this.core$().removeFacet(OpenDialogOperationStamp.class);
                }

                public RatingStamp asRating() {
                    return (RatingStamp)this.core$().as(RatingStamp.class);
                }

                public RatingStamp asRating(CatalogStampDoubleValue rating) {
                    RatingStamp newElement = (RatingStamp)this.core$().addFacet(RatingStamp.class);
                    newElement.core$().set((Layer)newElement, "rating", Collections.singletonList(rating));
                    return newElement;
                }

                public boolean isRating() {
                    return this.core$().is(RatingStamp.class);
                }

                public void removeRating() {
                    this.core$().removeFacet(RatingStamp.class);
                }

                public BreadcrumbsStamp asBreadcrumbs() {
                    return (BreadcrumbsStamp)this.core$().as(BreadcrumbsStamp.class);
                }

                public BreadcrumbsStamp asBreadcrumbs(CatalogStampBreadcrumbsTree tree) {
                    BreadcrumbsStamp newElement = (BreadcrumbsStamp)this.core$().addFacet(BreadcrumbsStamp.class);
                    newElement.core$().set((Layer)newElement, "tree", Collections.singletonList(tree));
                    return newElement;
                }

                public boolean isBreadcrumbs() {
                    return this.core$().is(BreadcrumbsStamp.class);
                }

                public void removeBreadcrumbs() {
                    this.core$().removeFacet(BreadcrumbsStamp.class);
                }

                public HyperlinksStamp asHyperlinks() {
                    return (HyperlinksStamp)this.core$().as(HyperlinksStamp.class);
                }

                public HyperlinksStamp asHyperlinks(CatalogStampHyperlinks links) {
                    HyperlinksStamp newElement = (HyperlinksStamp)this.core$().addFacet(HyperlinksStamp.class);
                    newElement.core$().set((Layer)newElement, "links", Collections.singletonList(links));
                    return newElement;
                }

                public boolean isHyperlinks() {
                    return this.core$().is(HyperlinksStamp.class);
                }

                public void removeHyperlinks() {
                    this.core$().removeFacet(HyperlinksStamp.class);
                }

                public TitleStamp asTitle() {
                    return (TitleStamp)this.core$().as(TitleStamp.class);
                }

                public TitleStamp asTitle(CatalogStampTextValue title) {
                    TitleStamp newElement = (TitleStamp)this.core$().addFacet(TitleStamp.class);
                    newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                    return newElement;
                }

                public boolean isTitle() {
                    return this.core$().is(TitleStamp.class);
                }

                public void removeTitle() {
                    this.core$().removeFacet(TitleStamp.class);
                }

                public InternalPageStamp asInternalPage() {
                    return (InternalPageStamp)this.core$().as(InternalPageStamp.class);
                }

                public InternalPageStamp asInternalPage(CatalogStampPagePath path) {
                    InternalPageStamp newElement = (InternalPageStamp)this.core$().addFacet(InternalPageStamp.class);
                    newElement.core$().set((Layer)newElement, "path", Collections.singletonList(path));
                    return newElement;
                }

                public boolean isInternalPage() {
                    return this.core$().is(InternalPageStamp.class);
                }

                public void removeInternalPage() {
                    this.core$().removeFacet(InternalPageStamp.class);
                }

                public PageStamp asPage() {
                    Layer as = this.core$().as(PageStamp.class);
                    return as != null ? (PageStamp)as : null;
                }

                public boolean isPage() {
                    return this.core$().is(PageStamp.class);
                }

                public OperationStamp asOperation() {
                    Layer as = this.core$().as(OperationStamp.class);
                    return as != null ? (OperationStamp)as : (OperationStamp)this.core$().addFacet(OperationStamp.class);
                }

                public boolean isOperation() {
                    return this.core$().is(OperationStamp.class);
                }

                public SnippetStamp asSnippet() {
                    return (SnippetStamp)this.core$().as(SnippetStamp.class);
                }

                public SnippetStamp asSnippet(CatalogStampTextValue code) {
                    SnippetStamp newElement = (SnippetStamp)this.core$().addFacet(SnippetStamp.class);
                    newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
                    return newElement;
                }

                public boolean isSnippet() {
                    return this.core$().is(SnippetStamp.class);
                }

                public void removeSnippet() {
                    this.core$().removeFacet(SnippetStamp.class);
                }

                public PictureStamp asPicture() {
                    return (PictureStamp)this.core$().as(PictureStamp.class);
                }

                public PictureStamp asPicture(URL defaultPicture) {
                    PictureStamp newElement = (PictureStamp)this.core$().addFacet(PictureStamp.class);
                    newElement.core$().set((Layer)newElement, "defaultPicture", Collections.singletonList(defaultPicture));
                    return newElement;
                }

                public boolean isPicture() {
                    return this.core$().is(PictureStamp.class);
                }

                public void removePicture() {
                    this.core$().removeFacet(PictureStamp.class);
                }

                public Base64IconStamp asBase64Icon() {
                    return (Base64IconStamp)this.core$().as(Base64IconStamp.class);
                }

                public Base64IconStamp asBase64Icon(CatalogStampTextValue icon) {
                    Base64IconStamp newElement = (Base64IconStamp)this.core$().addFacet(Base64IconStamp.class);
                    newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
                    return newElement;
                }

                public boolean isBase64Icon() {
                    return this.core$().is(Base64IconStamp.class);
                }

                public void removeBase64Icon() {
                    this.core$().removeFacet(Base64IconStamp.class);
                }

                public ExternalPageStamp asExternalPage() {
                    return (ExternalPageStamp)this.core$().as(ExternalPageStamp.class);
                }

                public ExternalPageStamp asExternalPage(CatalogStampPageUrl url) {
                    ExternalPageStamp newElement = (ExternalPageStamp)this.core$().addFacet(ExternalPageStamp.class);
                    newElement.core$().set((Layer)newElement, "url", Collections.singletonList(url));
                    return newElement;
                }

                public boolean isExternalPage() {
                    return this.core$().is(ExternalPageStamp.class);
                }

                public void removeExternalPage() {
                    this.core$().removeFacet(ExternalPageStamp.class);
                }

                public ResourceIconStamp asResourceIcon() {
                    return (ResourceIconStamp)this.core$().as(ResourceIconStamp.class);
                }

                public ResourceIconStamp asResourceIcon(CatalogStampResourceValue icon) {
                    ResourceIconStamp newElement = (ResourceIconStamp)this.core$().addFacet(ResourceIconStamp.class);
                    newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
                    return newElement;
                }

                public boolean isResourceIcon() {
                    return this.core$().is(ResourceIconStamp.class);
                }

                public void removeResourceIcon() {
                    this.core$().removeFacet(ResourceIconStamp.class);
                }

                public IconStamp asIcon() {
                    Layer as = this.core$().as(IconStamp.class);
                    return as != null ? (IconStamp)as : null;
                }

                public boolean isIcon() {
                    return this.core$().is(IconStamp.class);
                }

                public LocationStamp asLocation() {
                    return (LocationStamp)this.core$().as(LocationStamp.class);
                }

                public LocationStamp asLocation(CatalogStampTextValue wkt) {
                    LocationStamp newElement = (LocationStamp)this.core$().addFacet(LocationStamp.class);
                    newElement.core$().set((Layer)newElement, "wkt", Collections.singletonList(wkt));
                    return newElement;
                }

                public boolean isLocation() {
                    return this.core$().is(LocationStamp.class);
                }

                public void removeLocation() {
                    this.core$().removeFacet(LocationStamp.class);
                }

                public DisplayStamp asDisplay() {
                    Layer as = this.core$().as(DisplayStamp.class);
                    return as != null ? (DisplayStamp)as : (DisplayStamp)this.core$().addFacet(DisplayStamp.class);
                }

                public boolean isDisplay() {
                    return this.core$().is(DisplayStamp.class);
                }

                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
                    map.put("internalValue", this.internalValue != null ? new ArrayList<CatalogStampValue>(Collections.singletonList(this.internalValue)) : Collections.emptyList());
                    map.put("layout", new ArrayList<Layout>(Collections.singletonList(this.layout)));
                    map.put("height", new ArrayList<Integer>(Collections.singletonList(this.height)));
                    return map;
                }

                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                    if (name.equalsIgnoreCase("label")) {
                        this.label = (String)StringLoader.load(values, (Layer)this).get(0);
                    } else if (name.equalsIgnoreCase("internalValue")) {
                        this.internalValue = (CatalogStampValue)FunctionLoader.load(values, (Layer)this, CatalogStampValue.class).get(0);
                    } else if (name.equalsIgnoreCase("layout")) {
                        this.layout = (Layout)((Object)WordLoader.load(values, Layout.class, (Layer)this).get(0));
                    } else if (name.equalsIgnoreCase("height")) {
                        this.height = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                    }
                }

                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                    if (name.equalsIgnoreCase("label")) {
                        this.label = (String)values.get(0);
                    } else if (name.equalsIgnoreCase("internalValue")) {
                        this.internalValue = (CatalogStampValue)FunctionLoader.load(values.get(0), (Layer)this, CatalogStampValue.class);
                    } else if (name.equalsIgnoreCase("layout")) {
                        this.layout = (Layout)((Object)values.get(0));
                    } else if (name.equalsIgnoreCase("height")) {
                        this.height = (Integer)values.get(0);
                    }
                }

                public Create create() {
                    return new Create(null);
                }

                public Create create(String name) {
                    return new Create(name);
                }

                public Clear clear() {
                    return new Clear();
                }

                public SumusGraph graph() {
                    return (SumusGraph)this.core$().graph().as(SumusGraph.class);
                }

                public class Clear {
                }

                public class Create {
                    protected final String name;

                    public Create(String name) {
                        this.name = name;
                    }
                }

                public static enum Layout {
                    Fixed,
                    Flexible;

                }
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Block.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void stamp(Predicate<Stamp> filter) {
                    new ArrayList<Stamp>(Block.this.stampList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Block block() {
                    Block newElement = (Block)Block.this.core$().graph().concept(Block.class).createNode(this.name, Block.this.core$()).as(Block.class);
                    return newElement;
                }

                public Stamp stamp(String label) {
                    Stamp newElement = (Stamp)Block.this.core$().graph().concept(Stamp.class).createNode(this.name, Block.this.core$()).as(Stamp.class);
                    newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                    return newElement;
                }
            }

            public static enum Layout {
                Vertical,
                Horizontal,
                Fixed,
                Flexible,
                Wrap,
                Center,
                StartJustified,
                CenterJustified,
                EndJustified;

            }
        }

        public class Clear {
            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Mold.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Block block() {
                Block newElement = (Block)Mold.this.core$().graph().concept(Block.class).createNode(this.name, Mold.this.core$()).as(Block.class);
                return newElement;
            }
        }
    }

    public static class OlapView
    extends View
    implements Terminal {
        protected String label;
        protected Olap olap;

        public OlapView(Node node) {
            super(node);
        }

        public String label() {
            return this.label;
        }

        public Olap olap() {
            return this.olap;
        }

        public OlapView label(String value) {
            this.label = value;
            return this;
        }

        public OlapView olap(Olap value) {
            this.olap = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
            map.put("olap", this.olap != null ? new ArrayList<Olap>(Collections.singletonList(this.olap)) : Collections.emptyList());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("label")) {
                this.label = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("olap")) {
                this.olap = (Olap)((Object)NodeLoader.load(values, Olap.class, (Layer)this).get(0));
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("label")) {
                this.label = (String)values.get(0);
            } else if (name.equalsIgnoreCase("olap")) {
                this.olap = values.get(0) != null ? (Olap)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Olap.class) : null;
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public Clear clear() {
            return new Clear();
        }

        @Override
        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Clear
        extends View.Clear {
        }

        public class Create
        extends View.Create {
            public Create(String name) {
                super(name);
            }
        }
    }

    public static class MapView
    extends View
    implements Terminal {
        protected Mold mold;
        protected String label;
        protected Center center;
        protected Zoom zoom;

        public MapView(Node node) {
            super(node);
        }

        public Mold mold() {
            return this.mold;
        }

        public String label() {
            return this.label;
        }

        public MapView mold(Mold value) {
            this.mold = value;
            return this;
        }

        public MapView label(String value) {
            this.label = value;
            return this;
        }

        public Center center() {
            return this.center;
        }

        public Zoom zoom() {
            return this.zoom;
        }

        public MapView center(Center value) {
            this.center = value;
            return this;
        }

        public MapView zoom(Zoom value) {
            this.zoom = value;
            return this;
        }

        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            if (this.center != null) {
                components.add(this.center.core$());
            }
            if (this.zoom != null) {
                components.add(this.zoom.core$());
            }
            return new ArrayList<Node>(components);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("mold", this.mold != null ? new ArrayList<Mold>(Collections.singletonList(this.mold)) : Collections.emptyList());
            map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Catalog$MapView$Center")) {
                this.center = (Center)node.as(Center.class);
            }
            if (node.is("Catalog$MapView$Zoom")) {
                this.zoom = (Zoom)node.as(Zoom.class);
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Catalog$MapView$Center")) {
                this.center = null;
            }
            if (node.is("Catalog$MapView$Zoom")) {
                this.zoom = null;
            }
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("mold")) {
                this.mold = (Mold)((Object)NodeLoader.load(values, Mold.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("label")) {
                this.label = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("mold")) {
                this.mold = values.get(0) != null ? (Mold)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Mold.class) : null;
            } else if (name.equalsIgnoreCase("label")) {
                this.label = (String)values.get(0);
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public Clear clear() {
            return new Clear();
        }

        @Override
        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public static class Zoom
        extends Layer
        implements Terminal {
            protected int default$;
            protected int min;
            protected int max;

            public Zoom(Node node) {
                super(node);
            }

            public int default$() {
                return this.default$;
            }

            public int min() {
                return this.min;
            }

            public int max() {
                return this.max;
            }

            public Zoom default$(int value) {
                this.default$ = value;
                return this;
            }

            public Zoom min(int value) {
                this.min = value;
                return this;
            }

            public Zoom max(int value) {
                this.max = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("default", new ArrayList<Integer>(Collections.singletonList(this.default$)));
                map.put("min", new ArrayList<Integer>(Collections.singletonList(this.min)));
                map.put("max", new ArrayList<Integer>(Collections.singletonList(this.max)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("default")) {
                    this.default$ = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("min")) {
                    this.min = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("max")) {
                    this.max = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("default")) {
                    this.default$ = (Integer)values.get(0);
                } else if (name.equalsIgnoreCase("min")) {
                    this.min = (Integer)values.get(0);
                } else if (name.equalsIgnoreCase("max")) {
                    this.max = (Integer)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }

            public class Clear {
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }
        }

        public static class Center
        extends Layer
        implements Terminal {
            protected double latitude;
            protected double longitude;

            public Center(Node node) {
                super(node);
            }

            public double latitude() {
                return this.latitude;
            }

            public double longitude() {
                return this.longitude;
            }

            public Center latitude(double value) {
                this.latitude = value;
                return this;
            }

            public Center longitude(double value) {
                this.longitude = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("latitude", new ArrayList<Double>(Collections.singletonList(this.latitude)));
                map.put("longitude", new ArrayList<Double>(Collections.singletonList(this.longitude)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("latitude")) {
                    this.latitude = (Double)DoubleLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("longitude")) {
                    this.longitude = (Double)DoubleLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("latitude")) {
                    this.latitude = (Double)values.get(0);
                } else if (name.equalsIgnoreCase("longitude")) {
                    this.longitude = (Double)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }

            public class Clear {
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }
        }

        public class Clear
        extends View.Clear {
        }

        public class Create
        extends View.Create {
            public Create(String name) {
                super(name);
            }

            public Center center(double latitude, double longitude) {
                Center newElement = (Center)MapView.this.core$().graph().concept(Center.class).createNode(this.name, MapView.this.core$()).as(Center.class);
                newElement.core$().set((Layer)newElement, "latitude", Collections.singletonList(latitude));
                newElement.core$().set((Layer)newElement, "longitude", Collections.singletonList(longitude));
                return newElement;
            }

            public Zoom zoom(int default$) {
                Zoom newElement = (Zoom)MapView.this.core$().graph().concept(Zoom.class).createNode(this.name, MapView.this.core$()).as(Zoom.class);
                newElement.core$().set((Layer)newElement, "default", Collections.singletonList(default$));
                return newElement;
            }
        }
    }

    public static class GridView
    extends View
    implements Terminal {
        protected Mold mold;
        protected String label;

        public GridView(Node node) {
            super(node);
        }

        public Mold mold() {
            return this.mold;
        }

        public String label() {
            return this.label;
        }

        public GridView mold(Mold value) {
            this.mold = value;
            return this;
        }

        public GridView label(String value) {
            this.label = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("mold", this.mold != null ? new ArrayList<Mold>(Collections.singletonList(this.mold)) : Collections.emptyList());
            map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("mold")) {
                this.mold = (Mold)((Object)NodeLoader.load(values, Mold.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("label")) {
                this.label = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("mold")) {
                this.mold = values.get(0) != null ? (Mold)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Mold.class) : null;
            } else if (name.equalsIgnoreCase("label")) {
                this.label = (String)values.get(0);
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public Clear clear() {
            return new Clear();
        }

        @Override
        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Clear
        extends View.Clear {
        }

        public class Create
        extends View.Create {
            public Create(String name) {
                super(name);
            }
        }
    }

    public static class ListView
    extends View
    implements Terminal {
        protected Mold mold;
        protected String label;

        public ListView(Node node) {
            super(node);
        }

        public Mold mold() {
            return this.mold;
        }

        public String label() {
            return this.label;
        }

        public ListView mold(Mold value) {
            this.mold = value;
            return this;
        }

        public ListView label(String value) {
            this.label = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("mold", this.mold != null ? new ArrayList<Mold>(Collections.singletonList(this.mold)) : Collections.emptyList());
            map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("mold")) {
                this.mold = (Mold)((Object)NodeLoader.load(values, Mold.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("label")) {
                this.label = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("mold")) {
                this.mold = values.get(0) != null ? (Mold)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Mold.class) : null;
            } else if (name.equalsIgnoreCase("label")) {
                this.label = (String)values.get(0);
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public Clear clear() {
            return new Clear();
        }

        @Override
        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Clear
        extends View.Clear {
        }

        public class Create
        extends View.Create {
            public Create(String name) {
                super(name);
            }
        }
    }

    public static class MagazineView
    extends View
    implements Terminal {
        protected Mold mold;
        protected String label;

        public MagazineView(Node node) {
            super(node);
        }

        public Mold mold() {
            return this.mold;
        }

        public String label() {
            return this.label;
        }

        public MagazineView mold(Mold value) {
            this.mold = value;
            return this;
        }

        public MagazineView label(String value) {
            this.label = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("mold", this.mold != null ? new ArrayList<Mold>(Collections.singletonList(this.mold)) : Collections.emptyList());
            map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("mold")) {
                this.mold = (Mold)((Object)NodeLoader.load(values, Mold.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("label")) {
                this.label = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("mold")) {
                this.mold = values.get(0) != null ? (Mold)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Mold.class) : null;
            } else if (name.equalsIgnoreCase("label")) {
                this.label = (String)values.get(0);
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public Clear clear() {
            return new Clear();
        }

        @Override
        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Clear
        extends View.Clear {
        }

        public class Create
        extends View.Create {
            public Create(String name) {
                super(name);
            }
        }
    }

    public static abstract class View
    extends Layer
    implements Terminal {
        public View(Node node) {
            super(node);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Clear {
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public class Clear {
        public void magazineView(Predicate<MagazineView> filter) {
            new ArrayList<MagazineView>(Catalog.this.magazineViewList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void listView(Predicate<ListView> filter) {
            new ArrayList<ListView>(Catalog.this.listViewList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void gridView(Predicate<GridView> filter) {
            new ArrayList<GridView>(Catalog.this.gridViewList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void mapView(Predicate<MapView> filter) {
            new ArrayList<MapView>(Catalog.this.mapViewList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void olapView(Predicate<OlapView> filter) {
            new ArrayList<OlapView>(Catalog.this.olapViewList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void mold(Predicate<Mold> filter) {
            new ArrayList<Mold>(Catalog.this.moldList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void sorting(Predicate<Sorting> filter) {
            new ArrayList<Sorting>(Catalog.this.sortingList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void grouping(Predicate<Grouping> filter) {
            new ArrayList<Grouping>(Catalog.this.groupingList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void clusterGrouping(Predicate<ClusterGrouping> filter) {
            new ArrayList<ClusterGrouping>(Catalog.this.clusterGroupingList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public MagazineView magazineView(Mold mold, String label) {
            MagazineView newElement = (MagazineView)Catalog.this.core$().graph().concept(MagazineView.class).createNode(this.name, Catalog.this.core$()).as(MagazineView.class);
            newElement.core$().set((Layer)newElement, "mold", Collections.singletonList(mold));
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        public ListView listView(Mold mold, String label) {
            ListView newElement = (ListView)Catalog.this.core$().graph().concept(ListView.class).createNode(this.name, Catalog.this.core$()).as(ListView.class);
            newElement.core$().set((Layer)newElement, "mold", Collections.singletonList(mold));
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        public GridView gridView(Mold mold, String label) {
            GridView newElement = (GridView)Catalog.this.core$().graph().concept(GridView.class).createNode(this.name, Catalog.this.core$()).as(GridView.class);
            newElement.core$().set((Layer)newElement, "mold", Collections.singletonList(mold));
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        public MapView mapView(Mold mold) {
            MapView newElement = (MapView)Catalog.this.core$().graph().concept(MapView.class).createNode(this.name, Catalog.this.core$()).as(MapView.class);
            newElement.core$().set((Layer)newElement, "mold", Collections.singletonList(mold));
            return newElement;
        }

        public OlapView olapView(Olap olap) {
            OlapView newElement = (OlapView)Catalog.this.core$().graph().concept(OlapView.class).createNode(this.name, Catalog.this.core$()).as(OlapView.class);
            newElement.core$().set((Layer)newElement, "olap", Collections.singletonList(olap));
            return newElement;
        }

        public Mold mold() {
            Mold newElement = (Mold)Catalog.this.core$().graph().concept(Mold.class).createNode(this.name, Catalog.this.core$()).as(Mold.class);
            return newElement;
        }

        public Sorting sorting(String label, CatalogSortingComparator comparator) {
            Sorting newElement = (Sorting)Catalog.this.core$().graph().concept(Sorting.class).createNode(this.name, Catalog.this.core$()).as(Sorting.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "comparator", Collections.singletonList(comparator));
            return newElement;
        }

        public Grouping grouping(Categorization categorization) {
            Grouping newElement = (Grouping)Catalog.this.core$().graph().concept(Grouping.class).createNode(this.name, Catalog.this.core$()).as(Grouping.class);
            newElement.core$().set((Layer)newElement, "categorization", Collections.singletonList(categorization));
            return newElement;
        }

        public ClusterGrouping clusterGrouping(Cluster cluster) {
            ClusterGrouping newElement = (ClusterGrouping)Catalog.this.core$().graph().concept(ClusterGrouping.class).createNode(this.name, Catalog.this.core$()).as(ClusterGrouping.class);
            newElement.core$().set((Layer)newElement, "cluster", Collections.singletonList(cluster));
            return newElement;
        }
    }
}

