/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.graph;

import io.intino.sumus.graph.AbstractMetric;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Checker;
import io.intino.sumus.graph.Cluster;
import io.intino.sumus.graph.Cube;
import io.intino.sumus.graph.Entity;
import io.intino.sumus.graph.Episode;
import io.intino.sumus.graph.Event;
import io.intino.sumus.graph.Filter;
import io.intino.sumus.graph.KeyStore;
import io.intino.sumus.graph.Metric;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Olap;
import io.intino.sumus.graph.Palette;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.Report;
import io.intino.sumus.graph.TemporalMetric;
import io.intino.sumus.graph.TemporalRecord;
import io.intino.sumus.graph.Ticket;
import io.intino.sumus.graph.aspect.AspectEntity;
import io.intino.sumus.graph.base64icon.catalog.mold.block.Base64IconStamp;
import io.intino.sumus.graph.breadcrumbs.catalog.mold.block.BreadcrumbsStamp;
import io.intino.sumus.graph.container.ContainerCatalog;
import io.intino.sumus.graph.description.catalog.mold.block.DescriptionStamp;
import io.intino.sumus.graph.display.catalog.mold.block.DisplayStamp;
import io.intino.sumus.graph.downloadoperation.catalog.mold.block.DownloadOperationStamp;
import io.intino.sumus.graph.dynamic.DynamicEntity;
import io.intino.sumus.graph.entitycontainer.EntityContainerCatalog;
import io.intino.sumus.graph.eventcontainer.EventContainerCatalog;
import io.intino.sumus.graph.expanded.catalog.mold.ExpandedBlock;
import io.intino.sumus.graph.externalpage.catalog.mold.block.ExternalPageStamp;
import io.intino.sumus.graph.functions.Attribute;
import io.intino.sumus.graph.functions.CatalogStampBreadcrumbsTree;
import io.intino.sumus.graph.functions.CatalogStampColor;
import io.intino.sumus.graph.functions.CatalogStampDoubleValue;
import io.intino.sumus.graph.functions.CatalogStampDownload;
import io.intino.sumus.graph.functions.CatalogStampHyperlinks;
import io.intino.sumus.graph.functions.CatalogStampPagePath;
import io.intino.sumus.graph.functions.CatalogStampPageUrl;
import io.intino.sumus.graph.functions.CatalogStampResourceValue;
import io.intino.sumus.graph.functions.CatalogStampTextValue;
import io.intino.sumus.graph.geolocated.GeolocatedEntity;
import io.intino.sumus.graph.highlight.catalog.mold.block.HighlightStamp;
import io.intino.sumus.graph.hyperlinks.catalog.mold.block.HyperlinksStamp;
import io.intino.sumus.graph.icon.catalog.mold.block.IconStamp;
import io.intino.sumus.graph.internalpage.catalog.mold.block.InternalPageStamp;
import io.intino.sumus.graph.location.catalog.mold.block.LocationStamp;
import io.intino.sumus.graph.lock.LockEntity;
import io.intino.sumus.graph.opendialogoperation.catalog.mold.block.OpenDialogOperationStamp;
import io.intino.sumus.graph.operation.catalog.mold.block.OperationStamp;
import io.intino.sumus.graph.page.catalog.mold.block.PageStamp;
import io.intino.sumus.graph.picture.catalog.mold.block.PictureStamp;
import io.intino.sumus.graph.polymericon.catalog.mold.block.PolymerIconStamp;
import io.intino.sumus.graph.rating.catalog.mold.block.RatingStamp;
import io.intino.sumus.graph.reportcontainer.ReportContainerCatalog;
import io.intino.sumus.graph.resourceicon.catalog.mold.block.ResourceIconStamp;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.sumus.graph.shape.catalog.mold.block.ShapeStamp;
import io.intino.sumus.graph.snippet.catalog.mold.block.SnippetStamp;
import io.intino.sumus.graph.temporalcontainer.TemporalContainerCatalog;
import io.intino.sumus.graph.title.catalog.mold.block.TitleStamp;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Graph;
import io.intino.tara.magritte.GraphWrapper;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.utils.I18n;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class AbstractGraph
extends GraphWrapper {
    protected Graph graph;
    private List<Record> recordList;
    private List<TemporalRecord> temporalRecordList;
    private List<Entity> entityList;
    private List<Event> eventList;
    private List<Episode> episodeList;
    private List<Report> reportList;
    private List<Cube> cubeList;
    private List<Checker> checkerList;
    private List<GeolocatedEntity> geolocatedEntityList;
    private List<DynamicEntity> dynamicEntityList;
    private List<LockEntity> lockEntityList;
    private List<AspectEntity> aspectEntityList;
    private List<KeyStore> keyStoreList;
    private List<Categorization> categorizationList;
    private List<AbstractMetric> abstractMetricList;
    private List<Metric> metricList;
    private List<TemporalMetric> temporalMetricList;
    private List<Ticket> ticketList;
    private List<NameSpace> nameSpaceList;
    private List<Olap> olapList;
    private List<Catalog> catalogList;
    private List<ContainerCatalog> containerCatalogList;
    private List<EntityContainerCatalog> entityContainerCatalogList;
    private List<TemporalContainerCatalog> temporalContainerCatalogList;
    private List<EventContainerCatalog> eventContainerCatalogList;
    private List<ReportContainerCatalog> reportContainerCatalogList;
    private List<ShapeStamp> shapeStampList;
    private List<PictureStamp> pictureStampList;
    private List<IconStamp> iconStampList;
    private List<PolymerIconStamp> polymerIconStampList;
    private List<Base64IconStamp> base64IconStampList;
    private List<ResourceIconStamp> resourceIconStampList;
    private List<HighlightStamp> highlightStampList;
    private List<TitleStamp> titleStampList;
    private List<DescriptionStamp> descriptionStampList;
    private List<RatingStamp> ratingStampList;
    private List<OperationStamp> operationStampList;
    private List<OpenDialogOperationStamp> openDialogOperationStampList;
    private List<DownloadOperationStamp> downloadOperationStampList;
    private List<LocationStamp> locationStampList;
    private List<BreadcrumbsStamp> breadcrumbsStampList;
    private List<HyperlinksStamp> hyperlinksStampList;
    private List<DisplayStamp> displayStampList;
    private List<PageStamp> pageStampList;
    private List<InternalPageStamp> internalPageStampList;
    private List<ExternalPageStamp> externalPageStampList;
    private List<SnippetStamp> snippetStampList;
    private List<ExpandedBlock> expandedBlockList;
    private List<Cluster> clusterList;
    private List<Filter> filterList;
    private Palette palette;

    public AbstractGraph(Graph graph) {
        this.graph = graph;
        this.graph.i18n().register("Sumus");
    }

    public void update() {
        this.recordList = this.graph.rootList(Record.class);
        this.temporalRecordList = this.graph.rootList(TemporalRecord.class);
        this.entityList = this.graph.rootList(Entity.class);
        this.eventList = this.graph.rootList(Event.class);
        this.episodeList = this.graph.rootList(Episode.class);
        this.reportList = this.graph.rootList(Report.class);
        this.cubeList = this.graph.rootList(Cube.class);
        this.checkerList = this.graph.rootList(Checker.class);
        this.geolocatedEntityList = this.graph.rootList(GeolocatedEntity.class);
        this.dynamicEntityList = this.graph.rootList(DynamicEntity.class);
        this.lockEntityList = this.graph.rootList(LockEntity.class);
        this.aspectEntityList = this.graph.rootList(AspectEntity.class);
        this.keyStoreList = this.graph.rootList(KeyStore.class);
        this.categorizationList = this.graph.rootList(Categorization.class);
        this.abstractMetricList = this.graph.rootList(AbstractMetric.class);
        this.metricList = this.graph.rootList(Metric.class);
        this.temporalMetricList = this.graph.rootList(TemporalMetric.class);
        this.ticketList = this.graph.rootList(Ticket.class);
        this.nameSpaceList = this.graph.rootList(NameSpace.class);
        this.olapList = this.graph.rootList(Olap.class);
        this.catalogList = this.graph.rootList(Catalog.class);
        this.containerCatalogList = this.graph.rootList(ContainerCatalog.class);
        this.entityContainerCatalogList = this.graph.rootList(EntityContainerCatalog.class);
        this.temporalContainerCatalogList = this.graph.rootList(TemporalContainerCatalog.class);
        this.eventContainerCatalogList = this.graph.rootList(EventContainerCatalog.class);
        this.reportContainerCatalogList = this.graph.rootList(ReportContainerCatalog.class);
        this.shapeStampList = this.graph.rootList(ShapeStamp.class);
        this.pictureStampList = this.graph.rootList(PictureStamp.class);
        this.iconStampList = this.graph.rootList(IconStamp.class);
        this.polymerIconStampList = this.graph.rootList(PolymerIconStamp.class);
        this.base64IconStampList = this.graph.rootList(Base64IconStamp.class);
        this.resourceIconStampList = this.graph.rootList(ResourceIconStamp.class);
        this.highlightStampList = this.graph.rootList(HighlightStamp.class);
        this.titleStampList = this.graph.rootList(TitleStamp.class);
        this.descriptionStampList = this.graph.rootList(DescriptionStamp.class);
        this.ratingStampList = this.graph.rootList(RatingStamp.class);
        this.operationStampList = this.graph.rootList(OperationStamp.class);
        this.openDialogOperationStampList = this.graph.rootList(OpenDialogOperationStamp.class);
        this.downloadOperationStampList = this.graph.rootList(DownloadOperationStamp.class);
        this.locationStampList = this.graph.rootList(LocationStamp.class);
        this.breadcrumbsStampList = this.graph.rootList(BreadcrumbsStamp.class);
        this.hyperlinksStampList = this.graph.rootList(HyperlinksStamp.class);
        this.displayStampList = this.graph.rootList(DisplayStamp.class);
        this.pageStampList = this.graph.rootList(PageStamp.class);
        this.internalPageStampList = this.graph.rootList(InternalPageStamp.class);
        this.externalPageStampList = this.graph.rootList(ExternalPageStamp.class);
        this.snippetStampList = this.graph.rootList(SnippetStamp.class);
        this.expandedBlockList = this.graph.rootList(ExpandedBlock.class);
        this.clusterList = this.graph.rootList(Cluster.class);
        this.filterList = this.graph.rootList(Filter.class);
        this.palette = this.graph.rootList(Palette.class).stream().findFirst().orElse(null);
    }

    protected void addNode$(Node node) {
        if (node.is("Record")) {
            this.recordList.add((Record)node.as(Record.class));
        }
        if (node.is("TemporalRecord")) {
            this.temporalRecordList.add((TemporalRecord)node.as(TemporalRecord.class));
        }
        if (node.is("Entity")) {
            this.entityList.add((Entity)node.as(Entity.class));
        }
        if (node.is("Event")) {
            this.eventList.add((Event)node.as(Event.class));
        }
        if (node.is("Episode")) {
            this.episodeList.add((Episode)node.as(Episode.class));
        }
        if (node.is("Report")) {
            this.reportList.add((Report)node.as(Report.class));
        }
        if (node.is("Cube")) {
            this.cubeList.add((Cube)node.as(Cube.class));
        }
        if (node.is("Checker")) {
            this.checkerList.add((Checker)node.as(Checker.class));
        }
        if (node.is("Geolocated#Entity")) {
            this.geolocatedEntityList.add((GeolocatedEntity)node.as(GeolocatedEntity.class));
        }
        if (node.is("Dynamic#Entity")) {
            this.dynamicEntityList.add((DynamicEntity)node.as(DynamicEntity.class));
        }
        if (node.is("Lock#Entity")) {
            this.lockEntityList.add((LockEntity)node.as(LockEntity.class));
        }
        if (node.is("Aspect#Entity")) {
            this.aspectEntityList.add((AspectEntity)node.as(AspectEntity.class));
        }
        if (node.is("KeyStore")) {
            this.keyStoreList.add((KeyStore)node.as(KeyStore.class));
        }
        if (node.is("Categorization")) {
            this.categorizationList.add((Categorization)node.as(Categorization.class));
        }
        if (node.is("AbstractMetric")) {
            this.abstractMetricList.add((AbstractMetric)node.as(AbstractMetric.class));
        }
        if (node.is("Metric")) {
            this.metricList.add((Metric)node.as(Metric.class));
        }
        if (node.is("TemporalMetric")) {
            this.temporalMetricList.add((TemporalMetric)node.as(TemporalMetric.class));
        }
        if (node.is("Ticket")) {
            this.ticketList.add((Ticket)node.as(Ticket.class));
        }
        if (node.is("NameSpace")) {
            this.nameSpaceList.add((NameSpace)node.as(NameSpace.class));
        }
        if (node.is("Olap")) {
            this.olapList.add((Olap)node.as(Olap.class));
        }
        if (node.is("Catalog")) {
            this.catalogList.add((Catalog)node.as(Catalog.class));
        }
        if (node.is("Container#Catalog")) {
            this.containerCatalogList.add((ContainerCatalog)node.as(ContainerCatalog.class));
        }
        if (node.is("EntityContainer#Catalog")) {
            this.entityContainerCatalogList.add((EntityContainerCatalog)node.as(EntityContainerCatalog.class));
        }
        if (node.is("TemporalContainer#Catalog")) {
            this.temporalContainerCatalogList.add((TemporalContainerCatalog)node.as(TemporalContainerCatalog.class));
        }
        if (node.is("EventContainer#Catalog")) {
            this.eventContainerCatalogList.add((EventContainerCatalog)node.as(EventContainerCatalog.class));
        }
        if (node.is("ReportContainer#Catalog")) {
            this.reportContainerCatalogList.add((ReportContainerCatalog)node.as(ReportContainerCatalog.class));
        }
        if (node.is("Shape#Catalog$Mold$Block$Stamp")) {
            this.shapeStampList.add((ShapeStamp)node.as(ShapeStamp.class));
        }
        if (node.is("Picture#Catalog$Mold$Block$Stamp")) {
            this.pictureStampList.add((PictureStamp)node.as(PictureStamp.class));
        }
        if (node.is("Icon#Catalog$Mold$Block$Stamp")) {
            this.iconStampList.add((IconStamp)node.as(IconStamp.class));
        }
        if (node.is("PolymerIcon#Catalog$Mold$Block$Stamp")) {
            this.polymerIconStampList.add((PolymerIconStamp)node.as(PolymerIconStamp.class));
        }
        if (node.is("Base64Icon#Catalog$Mold$Block$Stamp")) {
            this.base64IconStampList.add((Base64IconStamp)node.as(Base64IconStamp.class));
        }
        if (node.is("ResourceIcon#Catalog$Mold$Block$Stamp")) {
            this.resourceIconStampList.add((ResourceIconStamp)node.as(ResourceIconStamp.class));
        }
        if (node.is("Highlight#Catalog$Mold$Block$Stamp")) {
            this.highlightStampList.add((HighlightStamp)node.as(HighlightStamp.class));
        }
        if (node.is("Title#Catalog$Mold$Block$Stamp")) {
            this.titleStampList.add((TitleStamp)node.as(TitleStamp.class));
        }
        if (node.is("Description#Catalog$Mold$Block$Stamp")) {
            this.descriptionStampList.add((DescriptionStamp)node.as(DescriptionStamp.class));
        }
        if (node.is("Rating#Catalog$Mold$Block$Stamp")) {
            this.ratingStampList.add((RatingStamp)node.as(RatingStamp.class));
        }
        if (node.is("Operation#Catalog$Mold$Block$Stamp")) {
            this.operationStampList.add((OperationStamp)node.as(OperationStamp.class));
        }
        if (node.is("OpenDialogOperation#Catalog$Mold$Block$Stamp")) {
            this.openDialogOperationStampList.add((OpenDialogOperationStamp)node.as(OpenDialogOperationStamp.class));
        }
        if (node.is("DownloadOperation#Catalog$Mold$Block$Stamp")) {
            this.downloadOperationStampList.add((DownloadOperationStamp)node.as(DownloadOperationStamp.class));
        }
        if (node.is("Location#Catalog$Mold$Block$Stamp")) {
            this.locationStampList.add((LocationStamp)node.as(LocationStamp.class));
        }
        if (node.is("Breadcrumbs#Catalog$Mold$Block$Stamp")) {
            this.breadcrumbsStampList.add((BreadcrumbsStamp)node.as(BreadcrumbsStamp.class));
        }
        if (node.is("Hyperlinks#Catalog$Mold$Block$Stamp")) {
            this.hyperlinksStampList.add((HyperlinksStamp)node.as(HyperlinksStamp.class));
        }
        if (node.is("Display#Catalog$Mold$Block$Stamp")) {
            this.displayStampList.add((DisplayStamp)node.as(DisplayStamp.class));
        }
        if (node.is("Page#Catalog$Mold$Block$Stamp")) {
            this.pageStampList.add((PageStamp)node.as(PageStamp.class));
        }
        if (node.is("InternalPage#Catalog$Mold$Block$Stamp")) {
            this.internalPageStampList.add((InternalPageStamp)node.as(InternalPageStamp.class));
        }
        if (node.is("ExternalPage#Catalog$Mold$Block$Stamp")) {
            this.externalPageStampList.add((ExternalPageStamp)node.as(ExternalPageStamp.class));
        }
        if (node.is("Snippet#Catalog$Mold$Block$Stamp")) {
            this.snippetStampList.add((SnippetStamp)node.as(SnippetStamp.class));
        }
        if (node.is("Expanded#Catalog$Mold$Block")) {
            this.expandedBlockList.add((ExpandedBlock)node.as(ExpandedBlock.class));
        }
        if (node.is("Cluster")) {
            this.clusterList.add((Cluster)node.as(Cluster.class));
        }
        if (node.is("Filter")) {
            this.filterList.add((Filter)node.as(Filter.class));
        }
        if (node.is("Palette")) {
            this.palette = (Palette)node.as(Palette.class);
        }
    }

    protected void removeNode$(Node node) {
        if (node.is("Record")) {
            this.recordList.remove(node.as(Record.class));
        }
        if (node.is("TemporalRecord")) {
            this.temporalRecordList.remove(node.as(TemporalRecord.class));
        }
        if (node.is("Entity")) {
            this.entityList.remove(node.as(Entity.class));
        }
        if (node.is("Event")) {
            this.eventList.remove(node.as(Event.class));
        }
        if (node.is("Episode")) {
            this.episodeList.remove(node.as(Episode.class));
        }
        if (node.is("Report")) {
            this.reportList.remove(node.as(Report.class));
        }
        if (node.is("Cube")) {
            this.cubeList.remove(node.as(Cube.class));
        }
        if (node.is("Checker")) {
            this.checkerList.remove(node.as(Checker.class));
        }
        if (node.is("Geolocated#Entity")) {
            this.geolocatedEntityList.remove(node.as(GeolocatedEntity.class));
        }
        if (node.is("Dynamic#Entity")) {
            this.dynamicEntityList.remove(node.as(DynamicEntity.class));
        }
        if (node.is("Lock#Entity")) {
            this.lockEntityList.remove(node.as(LockEntity.class));
        }
        if (node.is("Aspect#Entity")) {
            this.aspectEntityList.remove(node.as(AspectEntity.class));
        }
        if (node.is("KeyStore")) {
            this.keyStoreList.remove(node.as(KeyStore.class));
        }
        if (node.is("Categorization")) {
            this.categorizationList.remove(node.as(Categorization.class));
        }
        if (node.is("AbstractMetric")) {
            this.abstractMetricList.remove(node.as(AbstractMetric.class));
        }
        if (node.is("Metric")) {
            this.metricList.remove(node.as(Metric.class));
        }
        if (node.is("TemporalMetric")) {
            this.temporalMetricList.remove(node.as(TemporalMetric.class));
        }
        if (node.is("Ticket")) {
            this.ticketList.remove(node.as(Ticket.class));
        }
        if (node.is("NameSpace")) {
            this.nameSpaceList.remove(node.as(NameSpace.class));
        }
        if (node.is("Olap")) {
            this.olapList.remove(node.as(Olap.class));
        }
        if (node.is("Catalog")) {
            this.catalogList.remove(node.as(Catalog.class));
        }
        if (node.is("Container#Catalog")) {
            this.containerCatalogList.remove(node.as(ContainerCatalog.class));
        }
        if (node.is("EntityContainer#Catalog")) {
            this.entityContainerCatalogList.remove(node.as(EntityContainerCatalog.class));
        }
        if (node.is("TemporalContainer#Catalog")) {
            this.temporalContainerCatalogList.remove(node.as(TemporalContainerCatalog.class));
        }
        if (node.is("EventContainer#Catalog")) {
            this.eventContainerCatalogList.remove(node.as(EventContainerCatalog.class));
        }
        if (node.is("ReportContainer#Catalog")) {
            this.reportContainerCatalogList.remove(node.as(ReportContainerCatalog.class));
        }
        if (node.is("Shape#Catalog$Mold$Block$Stamp")) {
            this.shapeStampList.remove(node.as(ShapeStamp.class));
        }
        if (node.is("Picture#Catalog$Mold$Block$Stamp")) {
            this.pictureStampList.remove(node.as(PictureStamp.class));
        }
        if (node.is("Icon#Catalog$Mold$Block$Stamp")) {
            this.iconStampList.remove(node.as(IconStamp.class));
        }
        if (node.is("PolymerIcon#Catalog$Mold$Block$Stamp")) {
            this.polymerIconStampList.remove(node.as(PolymerIconStamp.class));
        }
        if (node.is("Base64Icon#Catalog$Mold$Block$Stamp")) {
            this.base64IconStampList.remove(node.as(Base64IconStamp.class));
        }
        if (node.is("ResourceIcon#Catalog$Mold$Block$Stamp")) {
            this.resourceIconStampList.remove(node.as(ResourceIconStamp.class));
        }
        if (node.is("Highlight#Catalog$Mold$Block$Stamp")) {
            this.highlightStampList.remove(node.as(HighlightStamp.class));
        }
        if (node.is("Title#Catalog$Mold$Block$Stamp")) {
            this.titleStampList.remove(node.as(TitleStamp.class));
        }
        if (node.is("Description#Catalog$Mold$Block$Stamp")) {
            this.descriptionStampList.remove(node.as(DescriptionStamp.class));
        }
        if (node.is("Rating#Catalog$Mold$Block$Stamp")) {
            this.ratingStampList.remove(node.as(RatingStamp.class));
        }
        if (node.is("Operation#Catalog$Mold$Block$Stamp")) {
            this.operationStampList.remove(node.as(OperationStamp.class));
        }
        if (node.is("OpenDialogOperation#Catalog$Mold$Block$Stamp")) {
            this.openDialogOperationStampList.remove(node.as(OpenDialogOperationStamp.class));
        }
        if (node.is("DownloadOperation#Catalog$Mold$Block$Stamp")) {
            this.downloadOperationStampList.remove(node.as(DownloadOperationStamp.class));
        }
        if (node.is("Location#Catalog$Mold$Block$Stamp")) {
            this.locationStampList.remove(node.as(LocationStamp.class));
        }
        if (node.is("Breadcrumbs#Catalog$Mold$Block$Stamp")) {
            this.breadcrumbsStampList.remove(node.as(BreadcrumbsStamp.class));
        }
        if (node.is("Hyperlinks#Catalog$Mold$Block$Stamp")) {
            this.hyperlinksStampList.remove(node.as(HyperlinksStamp.class));
        }
        if (node.is("Display#Catalog$Mold$Block$Stamp")) {
            this.displayStampList.remove(node.as(DisplayStamp.class));
        }
        if (node.is("Page#Catalog$Mold$Block$Stamp")) {
            this.pageStampList.remove(node.as(PageStamp.class));
        }
        if (node.is("InternalPage#Catalog$Mold$Block$Stamp")) {
            this.internalPageStampList.remove(node.as(InternalPageStamp.class));
        }
        if (node.is("ExternalPage#Catalog$Mold$Block$Stamp")) {
            this.externalPageStampList.remove(node.as(ExternalPageStamp.class));
        }
        if (node.is("Snippet#Catalog$Mold$Block$Stamp")) {
            this.snippetStampList.remove(node.as(SnippetStamp.class));
        }
        if (node.is("Expanded#Catalog$Mold$Block")) {
            this.expandedBlockList.remove(node.as(ExpandedBlock.class));
        }
        if (node.is("Cluster")) {
            this.clusterList.remove(node.as(Cluster.class));
        }
        if (node.is("Filter")) {
            this.filterList.remove(node.as(Filter.class));
        }
        if (node.is("Palette")) {
            this.palette = null;
        }
    }

    public URL resourceAsMessage$(String language, String key) {
        return this.graph.loadResource(this.graph.i18n().message(language, key, new Object[0]));
    }

    public List<Record> recordList() {
        return this.recordList;
    }

    public List<TemporalRecord> temporalRecordList() {
        return this.temporalRecordList;
    }

    public List<Entity> entityList() {
        return this.entityList;
    }

    public List<Event> eventList() {
        return this.eventList;
    }

    public List<Episode> episodeList() {
        return this.episodeList;
    }

    public List<Report> reportList() {
        return this.reportList;
    }

    public List<Cube> cubeList() {
        return this.cubeList;
    }

    public List<Checker> checkerList() {
        return this.checkerList;
    }

    public List<GeolocatedEntity> geolocatedEntityList() {
        return this.geolocatedEntityList;
    }

    public List<DynamicEntity> dynamicEntityList() {
        return this.dynamicEntityList;
    }

    public List<LockEntity> lockEntityList() {
        return this.lockEntityList;
    }

    public List<AspectEntity> aspectEntityList() {
        return this.aspectEntityList;
    }

    public List<KeyStore> keyStoreList() {
        return this.keyStoreList;
    }

    public List<Categorization> categorizationList() {
        return this.categorizationList;
    }

    public List<AbstractMetric> abstractMetricList() {
        return this.abstractMetricList;
    }

    public List<Metric> metricList() {
        return this.metricList;
    }

    public List<TemporalMetric> temporalMetricList() {
        return this.temporalMetricList;
    }

    public List<Ticket> ticketList() {
        return this.ticketList;
    }

    public List<NameSpace> nameSpaceList() {
        return this.nameSpaceList;
    }

    public List<Olap> olapList() {
        return this.olapList;
    }

    public List<Catalog> catalogList() {
        return this.catalogList;
    }

    public List<ContainerCatalog> containerCatalogList() {
        return this.containerCatalogList;
    }

    public List<EntityContainerCatalog> entityContainerCatalogList() {
        return this.entityContainerCatalogList;
    }

    public List<TemporalContainerCatalog> temporalContainerCatalogList() {
        return this.temporalContainerCatalogList;
    }

    public List<EventContainerCatalog> eventContainerCatalogList() {
        return this.eventContainerCatalogList;
    }

    public List<ReportContainerCatalog> reportContainerCatalogList() {
        return this.reportContainerCatalogList;
    }

    public List<ShapeStamp> shapeStampList() {
        return this.shapeStampList;
    }

    public List<PictureStamp> pictureStampList() {
        return this.pictureStampList;
    }

    public List<IconStamp> iconStampList() {
        return this.iconStampList;
    }

    public List<PolymerIconStamp> polymerIconStampList() {
        return this.polymerIconStampList;
    }

    public List<Base64IconStamp> base64IconStampList() {
        return this.base64IconStampList;
    }

    public List<ResourceIconStamp> resourceIconStampList() {
        return this.resourceIconStampList;
    }

    public List<HighlightStamp> highlightStampList() {
        return this.highlightStampList;
    }

    public List<TitleStamp> titleStampList() {
        return this.titleStampList;
    }

    public List<DescriptionStamp> descriptionStampList() {
        return this.descriptionStampList;
    }

    public List<RatingStamp> ratingStampList() {
        return this.ratingStampList;
    }

    public List<OperationStamp> operationStampList() {
        return this.operationStampList;
    }

    public List<OpenDialogOperationStamp> openDialogOperationStampList() {
        return this.openDialogOperationStampList;
    }

    public List<DownloadOperationStamp> downloadOperationStampList() {
        return this.downloadOperationStampList;
    }

    public List<LocationStamp> locationStampList() {
        return this.locationStampList;
    }

    public List<BreadcrumbsStamp> breadcrumbsStampList() {
        return this.breadcrumbsStampList;
    }

    public List<HyperlinksStamp> hyperlinksStampList() {
        return this.hyperlinksStampList;
    }

    public List<DisplayStamp> displayStampList() {
        return this.displayStampList;
    }

    public List<PageStamp> pageStampList() {
        return this.pageStampList;
    }

    public List<InternalPageStamp> internalPageStampList() {
        return this.internalPageStampList;
    }

    public List<ExternalPageStamp> externalPageStampList() {
        return this.externalPageStampList;
    }

    public List<SnippetStamp> snippetStampList() {
        return this.snippetStampList;
    }

    public List<ExpandedBlock> expandedBlockList() {
        return this.expandedBlockList;
    }

    public List<Cluster> clusterList() {
        return this.clusterList;
    }

    public List<Filter> filterList() {
        return this.filterList;
    }

    public Palette palette() {
        return this.palette;
    }

    public Stream<Record> recordList(Predicate<Record> filter) {
        return this.recordList.stream().filter(filter);
    }

    public Record record(int index) {
        return this.recordList.get(index);
    }

    public Stream<TemporalRecord> temporalRecordList(Predicate<TemporalRecord> filter) {
        return this.temporalRecordList.stream().filter(filter);
    }

    public TemporalRecord temporalRecord(int index) {
        return this.temporalRecordList.get(index);
    }

    public Stream<Entity> entityList(Predicate<Entity> filter) {
        return this.entityList.stream().filter(filter);
    }

    public Entity entity(int index) {
        return this.entityList.get(index);
    }

    public Stream<Event> eventList(Predicate<Event> filter) {
        return this.eventList.stream().filter(filter);
    }

    public Event event(int index) {
        return this.eventList.get(index);
    }

    public Stream<Episode> episodeList(Predicate<Episode> filter) {
        return this.episodeList.stream().filter(filter);
    }

    public Episode episode(int index) {
        return this.episodeList.get(index);
    }

    public Stream<Report> reportList(Predicate<Report> filter) {
        return this.reportList.stream().filter(filter);
    }

    public Report report(int index) {
        return this.reportList.get(index);
    }

    public Stream<Cube> cubeList(Predicate<Cube> filter) {
        return this.cubeList.stream().filter(filter);
    }

    public Cube cube(int index) {
        return this.cubeList.get(index);
    }

    public Stream<Checker> checkerList(Predicate<Checker> filter) {
        return this.checkerList.stream().filter(filter);
    }

    public Checker checker(int index) {
        return this.checkerList.get(index);
    }

    public Stream<GeolocatedEntity> geolocatedEntityList(Predicate<GeolocatedEntity> filter) {
        return this.geolocatedEntityList.stream().filter(filter);
    }

    public GeolocatedEntity geolocatedEntity(int index) {
        return this.geolocatedEntityList.get(index);
    }

    public Stream<DynamicEntity> dynamicEntityList(Predicate<DynamicEntity> filter) {
        return this.dynamicEntityList.stream().filter(filter);
    }

    public DynamicEntity dynamicEntity(int index) {
        return this.dynamicEntityList.get(index);
    }

    public Stream<LockEntity> lockEntityList(Predicate<LockEntity> filter) {
        return this.lockEntityList.stream().filter(filter);
    }

    public LockEntity lockEntity(int index) {
        return this.lockEntityList.get(index);
    }

    public Stream<AspectEntity> aspectEntityList(Predicate<AspectEntity> filter) {
        return this.aspectEntityList.stream().filter(filter);
    }

    public AspectEntity aspectEntity(int index) {
        return this.aspectEntityList.get(index);
    }

    public Stream<KeyStore> keyStoreList(Predicate<KeyStore> filter) {
        return this.keyStoreList.stream().filter(filter);
    }

    public KeyStore keyStore(int index) {
        return this.keyStoreList.get(index);
    }

    public Stream<Categorization> categorizationList(Predicate<Categorization> filter) {
        return this.categorizationList.stream().filter(filter);
    }

    public Categorization categorization(int index) {
        return this.categorizationList.get(index);
    }

    public Stream<AbstractMetric> abstractMetricList(Predicate<AbstractMetric> filter) {
        return this.abstractMetricList.stream().filter(filter);
    }

    public AbstractMetric abstractMetric(int index) {
        return this.abstractMetricList.get(index);
    }

    public Stream<Metric> metricList(Predicate<Metric> filter) {
        return this.metricList.stream().filter(filter);
    }

    public Metric metric(int index) {
        return this.metricList.get(index);
    }

    public Stream<TemporalMetric> temporalMetricList(Predicate<TemporalMetric> filter) {
        return this.temporalMetricList.stream().filter(filter);
    }

    public TemporalMetric temporalMetric(int index) {
        return this.temporalMetricList.get(index);
    }

    public Stream<Ticket> ticketList(Predicate<Ticket> filter) {
        return this.ticketList.stream().filter(filter);
    }

    public Ticket ticket(int index) {
        return this.ticketList.get(index);
    }

    public Stream<NameSpace> nameSpaceList(Predicate<NameSpace> filter) {
        return this.nameSpaceList.stream().filter(filter);
    }

    public NameSpace nameSpace(int index) {
        return this.nameSpaceList.get(index);
    }

    public Stream<Olap> olapList(Predicate<Olap> filter) {
        return this.olapList.stream().filter(filter);
    }

    public Olap olap(int index) {
        return this.olapList.get(index);
    }

    public Stream<Catalog> catalogList(Predicate<Catalog> filter) {
        return this.catalogList.stream().filter(filter);
    }

    public Catalog catalog(int index) {
        return this.catalogList.get(index);
    }

    public Stream<ContainerCatalog> containerCatalogList(Predicate<ContainerCatalog> filter) {
        return this.containerCatalogList.stream().filter(filter);
    }

    public ContainerCatalog containerCatalog(int index) {
        return this.containerCatalogList.get(index);
    }

    public Stream<EntityContainerCatalog> entityContainerCatalogList(Predicate<EntityContainerCatalog> filter) {
        return this.entityContainerCatalogList.stream().filter(filter);
    }

    public EntityContainerCatalog entityContainerCatalog(int index) {
        return this.entityContainerCatalogList.get(index);
    }

    public Stream<TemporalContainerCatalog> temporalContainerCatalogList(Predicate<TemporalContainerCatalog> filter) {
        return this.temporalContainerCatalogList.stream().filter(filter);
    }

    public TemporalContainerCatalog temporalContainerCatalog(int index) {
        return this.temporalContainerCatalogList.get(index);
    }

    public Stream<EventContainerCatalog> eventContainerCatalogList(Predicate<EventContainerCatalog> filter) {
        return this.eventContainerCatalogList.stream().filter(filter);
    }

    public EventContainerCatalog eventContainerCatalog(int index) {
        return this.eventContainerCatalogList.get(index);
    }

    public Stream<ReportContainerCatalog> reportContainerCatalogList(Predicate<ReportContainerCatalog> filter) {
        return this.reportContainerCatalogList.stream().filter(filter);
    }

    public ReportContainerCatalog reportContainerCatalog(int index) {
        return this.reportContainerCatalogList.get(index);
    }

    public Stream<ShapeStamp> shapeStampList(Predicate<ShapeStamp> filter) {
        return this.shapeStampList.stream().filter(filter);
    }

    public ShapeStamp shapeStamp(int index) {
        return this.shapeStampList.get(index);
    }

    public Stream<PictureStamp> pictureStampList(Predicate<PictureStamp> filter) {
        return this.pictureStampList.stream().filter(filter);
    }

    public PictureStamp pictureStamp(int index) {
        return this.pictureStampList.get(index);
    }

    public Stream<IconStamp> iconStampList(Predicate<IconStamp> filter) {
        return this.iconStampList.stream().filter(filter);
    }

    public IconStamp iconStamp(int index) {
        return this.iconStampList.get(index);
    }

    public Stream<PolymerIconStamp> polymerIconStampList(Predicate<PolymerIconStamp> filter) {
        return this.polymerIconStampList.stream().filter(filter);
    }

    public PolymerIconStamp polymerIconStamp(int index) {
        return this.polymerIconStampList.get(index);
    }

    public Stream<Base64IconStamp> base64IconStampList(Predicate<Base64IconStamp> filter) {
        return this.base64IconStampList.stream().filter(filter);
    }

    public Base64IconStamp base64IconStamp(int index) {
        return this.base64IconStampList.get(index);
    }

    public Stream<ResourceIconStamp> resourceIconStampList(Predicate<ResourceIconStamp> filter) {
        return this.resourceIconStampList.stream().filter(filter);
    }

    public ResourceIconStamp resourceIconStamp(int index) {
        return this.resourceIconStampList.get(index);
    }

    public Stream<HighlightStamp> highlightStampList(Predicate<HighlightStamp> filter) {
        return this.highlightStampList.stream().filter(filter);
    }

    public HighlightStamp highlightStamp(int index) {
        return this.highlightStampList.get(index);
    }

    public Stream<TitleStamp> titleStampList(Predicate<TitleStamp> filter) {
        return this.titleStampList.stream().filter(filter);
    }

    public TitleStamp titleStamp(int index) {
        return this.titleStampList.get(index);
    }

    public Stream<DescriptionStamp> descriptionStampList(Predicate<DescriptionStamp> filter) {
        return this.descriptionStampList.stream().filter(filter);
    }

    public DescriptionStamp descriptionStamp(int index) {
        return this.descriptionStampList.get(index);
    }

    public Stream<RatingStamp> ratingStampList(Predicate<RatingStamp> filter) {
        return this.ratingStampList.stream().filter(filter);
    }

    public RatingStamp ratingStamp(int index) {
        return this.ratingStampList.get(index);
    }

    public Stream<OperationStamp> operationStampList(Predicate<OperationStamp> filter) {
        return this.operationStampList.stream().filter(filter);
    }

    public OperationStamp operationStamp(int index) {
        return this.operationStampList.get(index);
    }

    public Stream<OpenDialogOperationStamp> openDialogOperationStampList(Predicate<OpenDialogOperationStamp> filter) {
        return this.openDialogOperationStampList.stream().filter(filter);
    }

    public OpenDialogOperationStamp openDialogOperationStamp(int index) {
        return this.openDialogOperationStampList.get(index);
    }

    public Stream<DownloadOperationStamp> downloadOperationStampList(Predicate<DownloadOperationStamp> filter) {
        return this.downloadOperationStampList.stream().filter(filter);
    }

    public DownloadOperationStamp downloadOperationStamp(int index) {
        return this.downloadOperationStampList.get(index);
    }

    public Stream<LocationStamp> locationStampList(Predicate<LocationStamp> filter) {
        return this.locationStampList.stream().filter(filter);
    }

    public LocationStamp locationStamp(int index) {
        return this.locationStampList.get(index);
    }

    public Stream<BreadcrumbsStamp> breadcrumbsStampList(Predicate<BreadcrumbsStamp> filter) {
        return this.breadcrumbsStampList.stream().filter(filter);
    }

    public BreadcrumbsStamp breadcrumbsStamp(int index) {
        return this.breadcrumbsStampList.get(index);
    }

    public Stream<HyperlinksStamp> hyperlinksStampList(Predicate<HyperlinksStamp> filter) {
        return this.hyperlinksStampList.stream().filter(filter);
    }

    public HyperlinksStamp hyperlinksStamp(int index) {
        return this.hyperlinksStampList.get(index);
    }

    public Stream<DisplayStamp> displayStampList(Predicate<DisplayStamp> filter) {
        return this.displayStampList.stream().filter(filter);
    }

    public DisplayStamp displayStamp(int index) {
        return this.displayStampList.get(index);
    }

    public Stream<PageStamp> pageStampList(Predicate<PageStamp> filter) {
        return this.pageStampList.stream().filter(filter);
    }

    public PageStamp pageStamp(int index) {
        return this.pageStampList.get(index);
    }

    public Stream<InternalPageStamp> internalPageStampList(Predicate<InternalPageStamp> filter) {
        return this.internalPageStampList.stream().filter(filter);
    }

    public InternalPageStamp internalPageStamp(int index) {
        return this.internalPageStampList.get(index);
    }

    public Stream<ExternalPageStamp> externalPageStampList(Predicate<ExternalPageStamp> filter) {
        return this.externalPageStampList.stream().filter(filter);
    }

    public ExternalPageStamp externalPageStamp(int index) {
        return this.externalPageStampList.get(index);
    }

    public Stream<SnippetStamp> snippetStampList(Predicate<SnippetStamp> filter) {
        return this.snippetStampList.stream().filter(filter);
    }

    public SnippetStamp snippetStamp(int index) {
        return this.snippetStampList.get(index);
    }

    public Stream<ExpandedBlock> expandedBlockList(Predicate<ExpandedBlock> filter) {
        return this.expandedBlockList.stream().filter(filter);
    }

    public ExpandedBlock expandedBlock(int index) {
        return this.expandedBlockList.get(index);
    }

    public Stream<Cluster> clusterList(Predicate<Cluster> filter) {
        return this.clusterList.stream().filter(filter);
    }

    public Cluster cluster(int index) {
        return this.clusterList.get(index);
    }

    public Stream<Filter> filterList(Predicate<Filter> filter) {
        return this.filterList.stream().filter(filter);
    }

    public Filter filter(int index) {
        return this.filterList.get(index);
    }

    public Graph core$() {
        return this.graph;
    }

    public I18n i18n$() {
        return this.graph.i18n();
    }

    public Create create() {
        return new Create("Misc", null);
    }

    public Create create(String stash) {
        return new Create(stash, null);
    }

    public Create create(String stash, String name) {
        return new Create(stash, name);
    }

    public Clear clear() {
        return new Clear();
    }

    public class Clear {
        public void cube(Predicate<Cube> filter) {
            new ArrayList<Cube>(AbstractGraph.this.cubeList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void checker(Predicate<Checker> filter) {
            new ArrayList<Checker>(AbstractGraph.this.checkerList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void keyStore(Predicate<KeyStore> filter) {
            new ArrayList<KeyStore>(AbstractGraph.this.keyStoreList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void categorization(Predicate<Categorization> filter) {
            new ArrayList<Categorization>(AbstractGraph.this.categorizationList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void metric(Predicate<Metric> filter) {
            new ArrayList<Metric>(AbstractGraph.this.metricList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void temporalMetric(Predicate<TemporalMetric> filter) {
            new ArrayList<TemporalMetric>(AbstractGraph.this.temporalMetricList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void ticket(Predicate<Ticket> filter) {
            new ArrayList<Ticket>(AbstractGraph.this.ticketList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void nameSpace(Predicate<NameSpace> filter) {
            new ArrayList<NameSpace>(AbstractGraph.this.nameSpaceList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void olap(Predicate<Olap> filter) {
            new ArrayList<Olap>(AbstractGraph.this.olapList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void catalog(Predicate<Catalog> filter) {
            new ArrayList<Catalog>(AbstractGraph.this.catalogList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void entityContainerCatalog(Predicate<EntityContainerCatalog> filter) {
            new ArrayList<EntityContainerCatalog>(AbstractGraph.this.entityContainerCatalogList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void eventContainerCatalog(Predicate<EventContainerCatalog> filter) {
            new ArrayList<EventContainerCatalog>(AbstractGraph.this.eventContainerCatalogList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void reportContainerCatalog(Predicate<ReportContainerCatalog> filter) {
            new ArrayList<ReportContainerCatalog>(AbstractGraph.this.reportContainerCatalogList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void pictureStamp(Predicate<PictureStamp> filter) {
            new ArrayList<PictureStamp>(AbstractGraph.this.pictureStampList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void polymerIconStamp(Predicate<PolymerIconStamp> filter) {
            new ArrayList<PolymerIconStamp>(AbstractGraph.this.polymerIconStampList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void base64IconStamp(Predicate<Base64IconStamp> filter) {
            new ArrayList<Base64IconStamp>(AbstractGraph.this.base64IconStampList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void resourceIconStamp(Predicate<ResourceIconStamp> filter) {
            new ArrayList<ResourceIconStamp>(AbstractGraph.this.resourceIconStampList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void highlightStamp(Predicate<HighlightStamp> filter) {
            new ArrayList<HighlightStamp>(AbstractGraph.this.highlightStampList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void titleStamp(Predicate<TitleStamp> filter) {
            new ArrayList<TitleStamp>(AbstractGraph.this.titleStampList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void descriptionStamp(Predicate<DescriptionStamp> filter) {
            new ArrayList<DescriptionStamp>(AbstractGraph.this.descriptionStampList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void ratingStamp(Predicate<RatingStamp> filter) {
            new ArrayList<RatingStamp>(AbstractGraph.this.ratingStampList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void operationStamp(Predicate<OperationStamp> filter) {
            new ArrayList<OperationStamp>(AbstractGraph.this.operationStampList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void openDialogOperationStamp(Predicate<OpenDialogOperationStamp> filter) {
            new ArrayList<OpenDialogOperationStamp>(AbstractGraph.this.openDialogOperationStampList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void downloadOperationStamp(Predicate<DownloadOperationStamp> filter) {
            new ArrayList<DownloadOperationStamp>(AbstractGraph.this.downloadOperationStampList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void locationStamp(Predicate<LocationStamp> filter) {
            new ArrayList<LocationStamp>(AbstractGraph.this.locationStampList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void breadcrumbsStamp(Predicate<BreadcrumbsStamp> filter) {
            new ArrayList<BreadcrumbsStamp>(AbstractGraph.this.breadcrumbsStampList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void hyperlinksStamp(Predicate<HyperlinksStamp> filter) {
            new ArrayList<HyperlinksStamp>(AbstractGraph.this.hyperlinksStampList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void displayStamp(Predicate<DisplayStamp> filter) {
            new ArrayList<DisplayStamp>(AbstractGraph.this.displayStampList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void internalPageStamp(Predicate<InternalPageStamp> filter) {
            new ArrayList<InternalPageStamp>(AbstractGraph.this.internalPageStampList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void externalPageStamp(Predicate<ExternalPageStamp> filter) {
            new ArrayList<ExternalPageStamp>(AbstractGraph.this.externalPageStampList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void snippetStamp(Predicate<SnippetStamp> filter) {
            new ArrayList<SnippetStamp>(AbstractGraph.this.snippetStampList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void expandedBlock(Predicate<ExpandedBlock> filter) {
            new ArrayList<ExpandedBlock>(AbstractGraph.this.expandedBlockList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void cluster(Predicate<Cluster> filter) {
            new ArrayList<Cluster>(AbstractGraph.this.clusterList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void filter(Predicate<Filter> filter) {
            new ArrayList<Filter>(AbstractGraph.this.filterList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        private final String stash;
        private final String name;

        public Create(String stash, String name) {
            this.stash = stash;
            this.name = name;
        }

        public Cube cube() {
            Cube newElement = (Cube)((Cube)AbstractGraph.this.graph.createRoot(Cube.class, this.stash, this.name)).core$().as(Cube.class);
            return newElement;
        }

        public Checker checker(Concept record) {
            Checker newElement = (Checker)((Checker)AbstractGraph.this.graph.createRoot(Checker.class, this.stash, this.name)).core$().as(Checker.class);
            newElement.core$().set((Layer)newElement, "record", Collections.singletonList(record));
            return newElement;
        }

        public KeyStore keyStore() {
            KeyStore newElement = (KeyStore)((KeyStore)AbstractGraph.this.graph.createRoot(KeyStore.class, this.stash, this.name)).core$().as(KeyStore.class);
            return newElement;
        }

        public Categorization categorization(String label, Concept entity, Attribute attribute) {
            Categorization newElement = (Categorization)((Categorization)AbstractGraph.this.graph.createRoot(Categorization.class, this.stash, this.name)).core$().as(Categorization.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "entity", Collections.singletonList(entity));
            newElement.core$().set((Layer)newElement, "attribute", Collections.singletonList(attribute));
            return newElement;
        }

        public Metric metric() {
            Metric newElement = (Metric)((Metric)AbstractGraph.this.graph.createRoot(Metric.class, this.stash, this.name)).core$().as(Metric.class);
            return newElement;
        }

        public TemporalMetric temporalMetric() {
            TemporalMetric newElement = (TemporalMetric)((TemporalMetric)AbstractGraph.this.graph.createRoot(TemporalMetric.class, this.stash, this.name)).core$().as(TemporalMetric.class);
            return newElement;
        }

        public Ticket ticket(String label, String shortLabel, List<Concept> events) {
            Ticket newElement = (Ticket)((Ticket)AbstractGraph.this.graph.createRoot(Ticket.class, this.stash, this.name)).core$().as(Ticket.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "shortLabel", Collections.singletonList(shortLabel));
            newElement.core$().set((Layer)newElement, "events", events);
            return newElement;
        }

        public NameSpace nameSpace(String label) {
            NameSpace newElement = (NameSpace)((NameSpace)AbstractGraph.this.graph.createRoot(NameSpace.class, this.stash, this.name)).core$().as(NameSpace.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        public Olap olap(String label, List<NameSpace> nameSpaces, List<Ticket> tickets) {
            Olap newElement = (Olap)((Olap)AbstractGraph.this.graph.createRoot(Olap.class, this.stash, this.name)).core$().as(Olap.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "nameSpaces", nameSpaces);
            newElement.core$().set((Layer)newElement, "tickets", tickets);
            return newElement;
        }

        public Catalog catalog(String label) {
            Catalog newElement = (Catalog)((Catalog)AbstractGraph.this.graph.createRoot(Catalog.class, this.stash, this.name)).core$().as(Catalog.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        public EntityContainerCatalog entityContainerCatalog(Concept entity) {
            EntityContainerCatalog newElement = (EntityContainerCatalog)((EntityContainerCatalog)AbstractGraph.this.graph.createRoot(EntityContainerCatalog.class, this.stash, this.name)).core$().as(EntityContainerCatalog.class);
            newElement.core$().set((Layer)newElement, "entity", Collections.singletonList(entity));
            return newElement;
        }

        public EventContainerCatalog eventContainerCatalog(List<TimeScale> scales, NameSpace nameSpace, Concept event) {
            EventContainerCatalog newElement = (EventContainerCatalog)((EventContainerCatalog)AbstractGraph.this.graph.createRoot(EventContainerCatalog.class, this.stash, this.name)).core$().as(EventContainerCatalog.class);
            newElement.core$().set((Layer)newElement, "scales", scales);
            newElement.core$().set((Layer)newElement, "nameSpace", Collections.singletonList(nameSpace));
            newElement.core$().set((Layer)newElement, "event", Collections.singletonList(event));
            return newElement;
        }

        public ReportContainerCatalog reportContainerCatalog(List<TimeScale> scales, NameSpace nameSpace, Concept report) {
            ReportContainerCatalog newElement = (ReportContainerCatalog)((ReportContainerCatalog)AbstractGraph.this.graph.createRoot(ReportContainerCatalog.class, this.stash, this.name)).core$().as(ReportContainerCatalog.class);
            newElement.core$().set((Layer)newElement, "scales", scales);
            newElement.core$().set((Layer)newElement, "nameSpace", Collections.singletonList(nameSpace));
            newElement.core$().set((Layer)newElement, "report", Collections.singletonList(report));
            return newElement;
        }

        public PictureStamp pictureStamp(URL defaultPicture) {
            PictureStamp newElement = (PictureStamp)((PictureStamp)AbstractGraph.this.graph.createRoot(PictureStamp.class, this.stash, this.name)).core$().as(PictureStamp.class);
            newElement.core$().set((Layer)newElement, "defaultPicture", Collections.singletonList(defaultPicture));
            return newElement;
        }

        public PolymerIconStamp polymerIconStamp(CatalogStampTextValue icon) {
            PolymerIconStamp newElement = (PolymerIconStamp)((PolymerIconStamp)AbstractGraph.this.graph.createRoot(PolymerIconStamp.class, this.stash, this.name)).core$().as(PolymerIconStamp.class);
            newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
            return newElement;
        }

        public Base64IconStamp base64IconStamp(CatalogStampTextValue icon) {
            Base64IconStamp newElement = (Base64IconStamp)((Base64IconStamp)AbstractGraph.this.graph.createRoot(Base64IconStamp.class, this.stash, this.name)).core$().as(Base64IconStamp.class);
            newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
            return newElement;
        }

        public ResourceIconStamp resourceIconStamp(CatalogStampResourceValue icon) {
            ResourceIconStamp newElement = (ResourceIconStamp)((ResourceIconStamp)AbstractGraph.this.graph.createRoot(ResourceIconStamp.class, this.stash, this.name)).core$().as(ResourceIconStamp.class);
            newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
            return newElement;
        }

        public HighlightStamp highlightStamp(CatalogStampTextValue value, CatalogStampColor color) {
            HighlightStamp newElement = (HighlightStamp)((HighlightStamp)AbstractGraph.this.graph.createRoot(HighlightStamp.class, this.stash, this.name)).core$().as(HighlightStamp.class);
            newElement.core$().set((Layer)newElement, "value", Collections.singletonList(value));
            newElement.core$().set((Layer)newElement, "color", Collections.singletonList(color));
            return newElement;
        }

        public TitleStamp titleStamp(CatalogStampTextValue title) {
            TitleStamp newElement = (TitleStamp)((TitleStamp)AbstractGraph.this.graph.createRoot(TitleStamp.class, this.stash, this.name)).core$().as(TitleStamp.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public DescriptionStamp descriptionStamp(CatalogStampTextValue description) {
            DescriptionStamp newElement = (DescriptionStamp)((DescriptionStamp)AbstractGraph.this.graph.createRoot(DescriptionStamp.class, this.stash, this.name)).core$().as(DescriptionStamp.class);
            newElement.core$().set((Layer)newElement, "description", Collections.singletonList(description));
            return newElement;
        }

        public RatingStamp ratingStamp(CatalogStampDoubleValue rating) {
            RatingStamp newElement = (RatingStamp)((RatingStamp)AbstractGraph.this.graph.createRoot(RatingStamp.class, this.stash, this.name)).core$().as(RatingStamp.class);
            newElement.core$().set((Layer)newElement, "rating", Collections.singletonList(rating));
            return newElement;
        }

        public OperationStamp operationStamp() {
            OperationStamp newElement = (OperationStamp)((OperationStamp)AbstractGraph.this.graph.createRoot(OperationStamp.class, this.stash, this.name)).core$().as(OperationStamp.class);
            return newElement;
        }

        public OpenDialogOperationStamp openDialogOperationStamp(CatalogStampPagePath path) {
            OpenDialogOperationStamp newElement = (OpenDialogOperationStamp)((OpenDialogOperationStamp)AbstractGraph.this.graph.createRoot(OpenDialogOperationStamp.class, this.stash, this.name)).core$().as(OpenDialogOperationStamp.class);
            newElement.core$().set((Layer)newElement, "path", Collections.singletonList(path));
            return newElement;
        }

        public DownloadOperationStamp downloadOperationStamp(CatalogStampDownload execute) {
            DownloadOperationStamp newElement = (DownloadOperationStamp)((DownloadOperationStamp)AbstractGraph.this.graph.createRoot(DownloadOperationStamp.class, this.stash, this.name)).core$().as(DownloadOperationStamp.class);
            newElement.core$().set((Layer)newElement, "execute", Collections.singletonList(execute));
            return newElement;
        }

        public LocationStamp locationStamp(CatalogStampTextValue wkt) {
            LocationStamp newElement = (LocationStamp)((LocationStamp)AbstractGraph.this.graph.createRoot(LocationStamp.class, this.stash, this.name)).core$().as(LocationStamp.class);
            newElement.core$().set((Layer)newElement, "wkt", Collections.singletonList(wkt));
            return newElement;
        }

        public BreadcrumbsStamp breadcrumbsStamp(CatalogStampBreadcrumbsTree tree) {
            BreadcrumbsStamp newElement = (BreadcrumbsStamp)((BreadcrumbsStamp)AbstractGraph.this.graph.createRoot(BreadcrumbsStamp.class, this.stash, this.name)).core$().as(BreadcrumbsStamp.class);
            newElement.core$().set((Layer)newElement, "tree", Collections.singletonList(tree));
            return newElement;
        }

        public HyperlinksStamp hyperlinksStamp(CatalogStampHyperlinks links) {
            HyperlinksStamp newElement = (HyperlinksStamp)((HyperlinksStamp)AbstractGraph.this.graph.createRoot(HyperlinksStamp.class, this.stash, this.name)).core$().as(HyperlinksStamp.class);
            newElement.core$().set((Layer)newElement, "links", Collections.singletonList(links));
            return newElement;
        }

        public DisplayStamp displayStamp() {
            DisplayStamp newElement = (DisplayStamp)((DisplayStamp)AbstractGraph.this.graph.createRoot(DisplayStamp.class, this.stash, this.name)).core$().as(DisplayStamp.class);
            return newElement;
        }

        public InternalPageStamp internalPageStamp(CatalogStampPagePath path) {
            InternalPageStamp newElement = (InternalPageStamp)((InternalPageStamp)AbstractGraph.this.graph.createRoot(InternalPageStamp.class, this.stash, this.name)).core$().as(InternalPageStamp.class);
            newElement.core$().set((Layer)newElement, "path", Collections.singletonList(path));
            return newElement;
        }

        public ExternalPageStamp externalPageStamp(CatalogStampPageUrl url) {
            ExternalPageStamp newElement = (ExternalPageStamp)((ExternalPageStamp)AbstractGraph.this.graph.createRoot(ExternalPageStamp.class, this.stash, this.name)).core$().as(ExternalPageStamp.class);
            newElement.core$().set((Layer)newElement, "url", Collections.singletonList(url));
            return newElement;
        }

        public SnippetStamp snippetStamp(CatalogStampTextValue code) {
            SnippetStamp newElement = (SnippetStamp)((SnippetStamp)AbstractGraph.this.graph.createRoot(SnippetStamp.class, this.stash, this.name)).core$().as(SnippetStamp.class);
            newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
            return newElement;
        }

        public ExpandedBlock expandedBlock() {
            ExpandedBlock newElement = (ExpandedBlock)((ExpandedBlock)AbstractGraph.this.graph.createRoot(ExpandedBlock.class, this.stash, this.name)).core$().as(ExpandedBlock.class);
            return newElement;
        }

        public Cluster cluster(Catalog catalog, String label, String username) {
            Cluster newElement = (Cluster)((Cluster)AbstractGraph.this.graph.createRoot(Cluster.class, this.stash, this.name)).core$().as(Cluster.class);
            newElement.core$().set((Layer)newElement, "catalog", Collections.singletonList(catalog));
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "username", Collections.singletonList(username));
            return newElement;
        }

        public Filter filter(String label, String username) {
            Filter newElement = (Filter)((Filter)AbstractGraph.this.graph.createRoot(Filter.class, this.stash, this.name)).core$().as(Filter.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "username", Collections.singletonList(username));
            return newElement;
        }

        public Palette palette() {
            Palette newElement = (Palette)((Palette)AbstractGraph.this.graph.createRoot(Palette.class, this.stash, this.name)).core$().as(Palette.class);
            return newElement;
        }
    }
}

