/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.datawarehouse.store;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Table {
    private Map<String, Integer> index;
    private List<String> columns;
    private List<String> rows;
    private List<int[]> cells;

    public Table(InputStream inputStream) {
        this.fromBytes(inputStream);
        this.createIndex();
    }

    public Table(String[] columns) {
        this.columns = Arrays.asList(columns);
        this.rows = new ArrayList<String>();
        this.cells = new ArrayList<int[]>();
        this.createIndex();
    }

    public int cols() {
        return this.columns.size();
    }

    public int rows() {
        return this.rows.size();
    }

    public String col(int index) {
        return this.columns.get(index);
    }

    public int col(String column) {
        int colIndex = this.indexOf(column);
        if (colIndex == -1) {
            throw new RuntimeException("Table does not have a column named " + column + ". Available columns: " + String.join((CharSequence)", ", this.columns));
        }
        return colIndex;
    }

    public String row(int index) {
        return this.rows.get(index);
    }

    public int row(String row) {
        return this.indexOf(row);
    }

    public int cell(String row, String col) {
        return this.cell(this.row(row), this.col(col));
    }

    public int cell(int row, int col) {
        return this.cells.get(row)[col];
    }

    public int set(String row, String col, int value) {
        int n = value;
        this.cells.get((int)this.row((String)row))[this.col((String)col)] = n;
        return n;
    }

    public int set(int row, int col, int value) {
        int n = value;
        this.cells.get((int)row)[col] = n;
        return n;
    }

    public void createRowsWith(String ... keys) {
        for (String key : keys) {
            this.rows.add(key);
            this.index.put(key, this.cells.size());
            this.cells.add(new int[this.cols()]);
        }
    }

    private int indexOf(String key) {
        return this.index.getOrDefault(key, -1);
    }

    void createIndex() {
        int i;
        this.index = new HashMap<String, Integer>();
        for (i = 0; i < this.columns.size(); ++i) {
            this.index.put(this.columns.get(i), i);
        }
        for (i = 0; i < this.rows.size(); ++i) {
            this.index.put(this.rows.get(i), i);
        }
    }

    public byte[] toBytes() {
        try {
            return this.serialize(new ByteArrayOutputStream(65536)).toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void fromBytes(InputStream inputStream) {
        try {
            this.deserialize(inputStream);
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private ByteArrayOutputStream serialize(ByteArrayOutputStream out) throws IOException {
        DataOutputStream stream = new DataOutputStream(out);
        this.writeString(stream, String.join((CharSequence)"\n", this.columns));
        this.writeString(stream, String.join((CharSequence)"\n", this.rows));
        this.writeLongs(stream);
        stream.flush();
        return out;
    }

    private void deserialize(InputStream inputStream) throws IOException {
        DataInputStream stream = new DataInputStream(inputStream);
        this.columns = new ArrayList<String>(Arrays.asList(this.readString(stream).split("\n")));
        this.rows = new ArrayList<String>(Arrays.asList(this.readString(stream).split("\n")));
        this.cells = this.readLongs(stream);
        stream.close();
    }

    private void writeString(DataOutputStream stream, String columns) throws IOException {
        stream.writeInt(columns.length());
        stream.write(columns.getBytes("UTF-8"));
    }

    private void writeLongs(DataOutputStream stream) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.cellsSizeInBytes()]);
        for (int[] row : this.cells) {
            for (int cell : row) {
                buffer.putInt(cell);
            }
        }
        stream.write(buffer.array());
    }

    private String readString(DataInputStream stream) throws IOException {
        int bytes = stream.readInt();
        byte[] result = new byte[bytes];
        stream.read(result);
        return new String(result, "UTF-8");
    }

    public List<int[]> readLongs(DataInputStream stream) throws IOException {
        ArrayList<int[]> result = new ArrayList<int[]>();
        byte[] bytes = new byte[this.cellsSizeInBytes()];
        stream.read(bytes);
        ByteBuffer wrap = ByteBuffer.wrap(bytes);
        for (int i = 0; i < this.rows.size(); ++i) {
            result.add(new int[this.cols()]);
            for (int j = 0; j < this.columns.size(); ++j) {
                ((int[])result.get((int)i))[j] = wrap.getInt();
            }
        }
        return result;
    }

    private int cellsSizeInBytes() {
        return this.rows.size() * this.columns.size() * 4;
    }
}

