/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.resources;

import io.intino.konos.exceptions.KonosException;
import io.intino.konos.server.activity.displays.Display;
import io.intino.konos.server.activity.displays.DisplayNotifierProvider;
import io.intino.konos.server.activity.displays.DisplayRepository;
import io.intino.konos.server.activity.displays.Soul;
import io.intino.konos.server.activity.services.push.ActivityClient;
import io.intino.konos.server.activity.spark.ActivitySparkManager;
import io.intino.konos.server.activity.spark.resources.Resource;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.actions.ErrorPageAction;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;

public class ErrorPageResource
extends Resource {
    private final SumusBox box;

    public ErrorPageResource(SumusBox box, ActivitySparkManager manager, DisplayNotifierProvider notifierProvider) {
        super(manager, notifierProvider);
        this.box = box;
    }

    public void execute() throws KonosException {
        super.execute();
        this.render();
    }

    private void render() {
        String clientId = UUID.randomUUID().toString();
        ErrorPageAction action = new ErrorPageAction();
        action.session = this.manager.currentSession();
        action.session.whenLogin((Function)new Function<String, String>(){

            @Override
            public String apply(String baseUrl) {
                return ErrorPageResource.this.authenticate(baseUrl);
            }
        });
        action.session.whenLogout(b -> this.logout());
        action.box = this.box;
        action.clientId = clientId;
        this.manager.pushService().onOpen(client -> {
            if (!client.id().equals(action.clientId)) {
                return false;
            }
            if (client.soul() != null) {
                return false;
            }
            Soul soul = action.prepareSoul((ActivityClient)client);
            soul.addRegisterDisplayListener(display -> {
                display.inject(this.notifier(action.session, (ActivityClient)client, (Display)display));
                display.inject(action.session);
                display.inject((DisplayRepository)soul);
                display.inject(() -> soul);
            });
            client.soul(soul);
            return true;
        });
        this.manager.pushService().onClose(clientId).execute((Consumer)new Consumer<ActivityClient>(){

            @Override
            public void accept(ActivityClient client) {
                ErrorPageResource.this.manager.unRegister(client);
            }
        });
        this.manager.write((Object)action.execute());
    }
}

