/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays.builders;

import io.intino.sumus.box.schemas.CatalogView;
import io.intino.sumus.box.schemas.Center;
import io.intino.sumus.box.schemas.Mold;
import io.intino.sumus.box.schemas.MoldBlock;
import io.intino.sumus.box.schemas.Property;
import io.intino.sumus.box.schemas.Stamp;
import io.intino.sumus.box.schemas.Zoom;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.downloadoperation.catalog.mold.block.DownloadOperationStamp;
import io.intino.sumus.graph.shape.catalog.mold.block.ShapeStamp;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class CatalogViewBuilder {
    public static CatalogView build(io.intino.sumus.analytics.viewmodels.CatalogView view) {
        CatalogView result = new CatalogView().name(view.name()).label(view.label());
        result.mold(CatalogViewBuilder.buildMold(view.mold()));
        result.type(view.type());
        result.canCreateClusters(view.canCreateClusters());
        result.clusters(view.clusters());
        CatalogViewBuilder.addMapViewProperties(result, view);
        return result;
    }

    public static List<CatalogView> buildList(List<io.intino.sumus.analytics.viewmodels.CatalogView> viewList) {
        return viewList.stream().map(CatalogViewBuilder::build).collect(Collectors.toList());
    }

    private static Mold buildMold(Catalog.Mold mold) {
        return new Mold().moldBlockList(mold.blockList().stream().map(CatalogViewBuilder::buildBlock).collect(Collectors.toList()));
    }

    private static MoldBlock buildBlock(Catalog.Mold.Block block) {
        return new MoldBlock().expanded(block.isExpanded()).hiddenIfMobile(block.hiddenIfMobile()).layout(block.layout().stream().map(Enum::toString).collect(Collectors.joining(" "))).width(block.width()).moldBlockList(block.blockList().stream().map(CatalogViewBuilder::buildBlock).collect(Collectors.toList())).stampList(block.stampList().stream().map(CatalogViewBuilder::buildStamp).collect(Collectors.toList()));
    }

    private static Stamp buildStamp(Catalog.Mold.Block.Stamp stamp) {
        Stamp result = new Stamp().name(stamp.name$()).label(stamp.label()).shape(CatalogViewBuilder.shapeOf(stamp)).layout(stamp.layout().toString()).height(stamp.height());
        ArrayList<Property> propertyList = new ArrayList<Property>();
        CatalogViewBuilder.addCommonProperties(propertyList, stamp);
        CatalogViewBuilder.addRatingProperties(propertyList, stamp);
        CatalogViewBuilder.addIconProperties(propertyList, stamp);
        CatalogViewBuilder.addDownloadOperationProperties(propertyList, stamp);
        result.propertyList(propertyList);
        return result;
    }

    private static void addMapViewProperties(CatalogView result, io.intino.sumus.analytics.viewmodels.CatalogView view) {
        Catalog.View rawView = view.rawView();
        if (!rawView.core$().is(Catalog.MapView.class)) {
            return;
        }
        Catalog.MapView mapView = (Catalog.MapView)rawView.core$().as(Catalog.MapView.class);
        Catalog.MapView.Zoom zoom = mapView.zoom();
        Catalog.MapView.Center center = mapView.center();
        result.center(new Center().latitude(center.latitude()).longitude(center.longitude()));
        result.zoom(new Zoom().min(zoom.min()).max(zoom.max()).defaultValue(zoom.default$()));
    }

    private static String shapeOf(Catalog.Mold.Block.Stamp stamp) {
        if (stamp.isTitle()) {
            return "title";
        }
        if (stamp.isDescription()) {
            return "description";
        }
        if (stamp.isIcon()) {
            return "icon";
        }
        if (stamp.isRating()) {
            return "rating";
        }
        if (stamp.isHighlight()) {
            return "highlight";
        }
        if (stamp.isPicture()) {
            return "picture";
        }
        if (stamp.isOpenDialogOperation()) {
            return "open-dialog-operation";
        }
        if (stamp.isDownloadOperation()) {
            return "download-operation";
        }
        if (stamp.isPage()) {
            return "page";
        }
        if (stamp.isDisplay()) {
            return "display";
        }
        if (stamp.isLocation()) {
            return "location";
        }
        if (stamp.isBreadcrumbs()) {
            return "breadcrumbs";
        }
        if (stamp.isHyperlinks()) {
            return "hyperlinks";
        }
        if (stamp.isSnippet()) {
            return "snippet";
        }
        return "";
    }

    private static void addCommonProperties(List<Property> propertyList, Catalog.Mold.Block.Stamp stamp) {
        if (!stamp.isShape()) {
            return;
        }
        ShapeStamp shapeStamp = stamp.asShape();
        if (!shapeStamp.suffix().isEmpty()) {
            propertyList.add(CatalogViewBuilder.shapeProperty("suffix", shapeStamp.suffix()));
        }
        if (!shapeStamp.defaultStyle().isEmpty()) {
            propertyList.add(CatalogViewBuilder.shapeProperty("defaultStyle", shapeStamp.defaultStyle()));
        }
    }

    private static void addRatingProperties(List<Property> propertyList, Catalog.Mold.Block.Stamp stamp) {
        if (!stamp.isRating()) {
            return;
        }
        propertyList.add(CatalogViewBuilder.shapeProperty("icon", stamp.asRating().ratingIcon()));
    }

    private static void addIconProperties(List<Property> propertyList, Catalog.Mold.Block.Stamp stamp) {
        if (!stamp.isIcon()) {
            return;
        }
        propertyList.add(CatalogViewBuilder.shapeProperty("icon-type", stamp.isPolymerIcon() ? "polymer" : ""));
    }

    private static void addDownloadOperationProperties(List<Property> propertyList, Catalog.Mold.Block.Stamp stamp) {
        if (!stamp.isDownloadOperation()) {
            return;
        }
        DownloadOperationStamp downloadStamp = stamp.asDownloadOperation();
        propertyList.add(CatalogViewBuilder.shapeProperty("title", downloadStamp.title()));
        propertyList.add(CatalogViewBuilder.shapeProperty("options", String.join((CharSequence)",", downloadStamp.options())));
    }

    private static Property shapeProperty(String name, String value) {
        return new Property().name(name).value(value);
    }
}

