/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays.builders;

import com.google.gson.Gson;
import io.intino.konos.server.activity.Asset;
import io.intino.sumus.box.schemas.CatalogItem;
import io.intino.sumus.box.schemas.CatalogItemStamp;
import io.intino.sumus.box.schemas.Property;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Event;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.functions.CatalogStampBreadcrumbsTree;
import io.intino.sumus.graph.functions.CatalogStampHyperlinks;
import io.intino.sumus.graph.rules.TimeScale;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class CatalogItemBuilder {
    public static CatalogItem build(Record record, List<Catalog.Mold.Block.Stamp> stampList, TimeScale scale, URL baseAssetUrl) {
        return new CatalogItem().name(new String(Base64.getEncoder().encode(record.core$().id().getBytes()))).group(CatalogItemBuilder.group(record, scale)).label(CatalogItemBuilder.label(record, stampList)).catalogItemStampList(CatalogItemBuilder.catalogItemStampList(record, stampList, baseAssetUrl));
    }

    public static List<CatalogItem> buildList(List<Record> recordList, List<Catalog.Mold.Block.Stamp> stampList, TimeScale scale, URL baseAssetUrl) {
        return recordList.stream().map(record -> CatalogItemBuilder.build(record, stampList, scale, baseAssetUrl)).collect(Collectors.toList());
    }

    private static String label(Record record, List<Catalog.Mold.Block.Stamp> stampList) {
        return stampList.stream().filter(Catalog.Mold.Block.Stamp::isTitle).findAny().map(stamp -> (String)stamp.internalValue(record)).orElseGet(() -> ((Record)record).name$());
    }

    private static Instant group(Record record, TimeScale scale) {
        if (!record.core$().is(Event.class)) {
            return null;
        }
        return scale.normalise(((Event)record.core$().as(Event.class)).created());
    }

    private static List<CatalogItemStamp> catalogItemStampList(Record record, List<Catalog.Mold.Block.Stamp> stampList, URL baseAssetUrl) {
        return stampList.stream().map(stamp -> CatalogItemBuilder.catalogItemStamp(record, baseAssetUrl, stamp)).collect(Collectors.toList());
    }

    private static CatalogItemStamp catalogItemStamp(Record record, URL baseAssetUrl, Catalog.Mold.Block.Stamp stamp) {
        return new CatalogItemStamp().name(stamp.name$()).values(CatalogItemBuilder.valuesOf(stamp, record, baseAssetUrl)).propertyList(CatalogItemBuilder.propertiesOf(stamp, record, baseAssetUrl));
    }

    private static List<String> valuesOf(Catalog.Mold.Block.Stamp stamp, Record record, URL baseAssetUrl) {
        Object value = stamp.internalValue(record);
        if (value instanceof List) {
            List<URL> values = (List<URL>)value;
            if (values.isEmpty() && stamp.isPicture()) {
                values = Collections.singletonList(stamp.asPicture().defaultPicture());
            }
            return values.stream().map(v -> CatalogItemBuilder.valueOf(stamp, v, baseAssetUrl)).collect(Collectors.toList());
        }
        return Collections.singletonList(CatalogItemBuilder.valueOf(stamp, value, baseAssetUrl));
    }

    private static String valueOf(Catalog.Mold.Block.Stamp stamp, Object value, URL baseAssetUrl) {
        if (stamp.isBreadcrumbs()) {
            CatalogStampBreadcrumbsTree.Tree tree = (CatalogStampBreadcrumbsTree.Tree)value;
            return new Gson().toJson((Object)tree);
        }
        if (stamp.isHyperlinks()) {
            CatalogStampHyperlinks.Hyperlinks links = (CatalogStampHyperlinks.Hyperlinks)value;
            return new Gson().toJson((Object)links);
        }
        if (stamp.isPicture()) {
            if (value == null) {
                value = stamp.asPicture().defaultPicture();
            }
            return value != null ? Asset.toResource((URL)baseAssetUrl, (URL)((URL)value)).toUrl().toString() : "";
        }
        if (stamp.isResourceIcon()) {
            return value != null ? Asset.toResource((URL)baseAssetUrl, (URL)((URL)value)).toUrl().toString() : "";
        }
        return value != null ? String.valueOf(value) : "";
    }

    private static List<Property> propertiesOf(Catalog.Mold.Block.Stamp stamp, Record record, URL baseAssetUrl) {
        URL icon;
        String style;
        ArrayList<Property> result = new ArrayList<Property>();
        if (stamp.isShape() && !(style = stamp.asShape().style(record)).isEmpty()) {
            result.add(CatalogItemBuilder.propertyOf("style", style));
        }
        if (stamp.isHighlight()) {
            result.add(CatalogItemBuilder.propertyOf("color", stamp.asHighlight().color(record)));
        }
        if (stamp.isHyperlinks()) {
            result.add(CatalogItemBuilder.propertyOf("title", stamp.asHyperlinks().title(record)));
        }
        if (stamp.isLocation() && (icon = stamp.asLocation().icon(record)) != null) {
            result.add(CatalogItemBuilder.propertyOf("icon", Asset.toResource((URL)baseAssetUrl, (URL)icon).toUrl().toString()));
        }
        return result;
    }

    private static Property propertyOf(String name, String value) {
        return new Property().name(name).value(value);
    }
}

