/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays.builders;

import io.intino.sumus.Category;
import io.intino.sumus.box.displays.builders.CatalogSortingBuilder;
import io.intino.sumus.box.schemas.Catalog;
import io.intino.sumus.box.schemas.Group;
import io.intino.sumus.box.schemas.Grouping;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Cluster;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class CatalogBuilder {
    public static Catalog build(io.intino.sumus.graph.Catalog catalog) {
        return new Catalog().name(catalog.name$()).label(catalog.label()).groupingList(CatalogBuilder.buildGroupingList(catalog.abstractGroupingList())).sortingList(CatalogSortingBuilder.buildList(catalog.sortingList()));
    }

    private static List<Grouping> buildGroupingList(List<Catalog.AbstractGrouping> groupingList) {
        return groupingList.stream().map(CatalogBuilder::buildGrouping).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Grouping buildGrouping(Catalog.AbstractGrouping grouping) {
        List<Group> groupList = CatalogBuilder.buildGroupList(grouping);
        int countItems = groupList.stream().mapToInt(Group::count).sum();
        if (countItems <= 0) {
            return null;
        }
        return new Grouping().name(grouping.name$()).label(grouping.label()).histogram(grouping.histogram().toString()).type(CatalogBuilder.typeOf(grouping)).groupList(groupList).countItems(countItems);
    }

    private static String typeOf(Catalog.AbstractGrouping grouping) {
        return grouping.core$().is(Catalog.Grouping.class) ? "Grouping" : "ClusterGrouping";
    }

    private static List<Group> buildGroupList(Catalog.AbstractGrouping grouping) {
        if (grouping.core$().is(Catalog.Grouping.class)) {
            return CatalogBuilder.buildCategorizationGroupList(((Catalog.Grouping)grouping.core$().as(Catalog.Grouping.class)).categorization().categoryList());
        }
        if (grouping.core$().is(Catalog.ClusterGrouping.class)) {
            return CatalogBuilder.buildClusterGroupList(((Catalog.ClusterGrouping)grouping.core$().as(Catalog.ClusterGrouping.class)).cluster().groupList());
        }
        return Collections.emptyList();
    }

    private static List<Group> buildCategorizationGroupList(List<Category> categories) {
        return categories.stream().map(CatalogBuilder::buildGroup).collect(Collectors.toList());
    }

    private static Group buildGroup(Category category) {
        return new Group().name(category.name()).label(category.label()).count(category.entityIds().size());
    }

    private static List<Group> buildClusterGroupList(List<Cluster.Group> groups) {
        return groups.stream().map(CatalogBuilder::buildGroup).collect(Collectors.toList());
    }

    private static Group buildGroup(Cluster.Group group) {
        return new Group().name(group.name$()).label(group.label()).count(group.entities().size());
    }
}

