/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.sumus.analytics.TimeRange;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.ChartNavigatorDisplay;
import io.intino.sumus.box.displays.builders.RangeBuilder;
import io.intino.sumus.box.displays.builders.ScaleBuilder;
import io.intino.sumus.box.displays.notifiers.TimeNavigatorDisplayNotifier;
import io.intino.sumus.box.schemas.DateNavigatorState;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.sumus.helpers.TimeScaleHandler;
import java.time.Instant;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;

public class TimeNavigatorDisplay
extends ChartNavigatorDisplay<TimeNavigatorDisplayNotifier> {
    private Instant date;
    private TimeScale scale;
    private Consumer<Instant> moveListeners = null;
    private Timer playerStepTimer = null;
    private Timer moveTimer = null;
    private static final int PlayDelay = 3000;

    public TimeNavigatorDisplay(SumusBox box) {
        super(box);
    }

    @Override
    protected void addListeners(TimeScaleHandler timeScaleHandler) {
        timeScaleHandler.onRangeChange(this::refreshDate);
        timeScaleHandler.onScaleChange(this::refreshScale);
    }

    protected void init() {
        super.init();
        TimeRange range = this.timeScaleHandler().range();
        this.scale = range.scale();
        this.date = this.scale.normalise(range.from());
        ((TimeNavigatorDisplayNotifier)this.notifier).refreshScales(ScaleBuilder.buildList(this.scales(), this.currentLanguage()));
        ((TimeNavigatorDisplayNotifier)this.notifier).refreshScale(this.scale.name());
        ((TimeNavigatorDisplayNotifier)this.notifier).refreshOlapRange(RangeBuilder.build(this.timeScaleHandler().boundsRange()));
        ((TimeNavigatorDisplayNotifier)this.notifier).refreshDate(this.date);
        ((TimeNavigatorDisplayNotifier)this.notifier).refreshState(this.state());
    }

    public TimeScale scale() {
        return this.scale;
    }

    public void selectScale(String value) {
        TimeScale scale = TimeScale.valueOf(value);
        this.timeScaleHandler().updateInstant(scale.normalise(this.date), scale);
        this.notifyMove(scale.normalise(this.date));
    }

    public Instant date() {
        return this.date;
    }

    public void selectDate(Instant date) {
        this.timeScaleHandler().updateInstant(this.scale.normalise(date), this.scale);
        this.notifyMove(this.scale.normalise(date));
    }

    public void previousDate() {
        this.addToDate(-1);
        this.notifyMoveDelayed();
    }

    public void play() {
        this.playerStep();
        ((TimeNavigatorDisplayNotifier)this.notifier).refreshState(this.state());
    }

    public void pause() {
        if (this.playerStepTimer == null) {
            return;
        }
        this.playerStepTimer.cancel();
        this.playerStepTimer = null;
        ((TimeNavigatorDisplayNotifier)this.notifier).refreshState(this.state());
    }

    private void playerStep() {
        if (!this.canNext().booleanValue()) {
            this.playerStepTimer = null;
            return;
        }
        this.nextDate();
        this.playerStepTimer = new Timer();
        this.playerStepTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                TimeNavigatorDisplay.this.playerStep();
                ((TimeNavigatorDisplayNotifier)TimeNavigatorDisplay.this.notifier).refreshState(TimeNavigatorDisplay.this.state());
            }
        }, 3000L);
    }

    public void nextDate() {
        if (this.date.isAfter(Instant.now())) {
            return;
        }
        this.addToDate(1);
        this.notifyMoveDelayed();
    }

    private void notifyMoveDelayed() {
        if (this.moveTimer != null) {
            this.moveTimer.cancel();
        }
        this.moveTimer = new Timer();
        this.moveTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                TimeNavigatorDisplay.this.notifyMove(TimeNavigatorDisplay.this.date);
            }
        }, 500L);
    }

    public void onMove(Consumer<Instant> listener) {
        this.moveListeners = listener;
    }

    private void addToDate(int count) {
        this.date = this.scale.addTo(this.date, count);
        this.timeScaleHandler().updateInstant(this.scale.normalise(this.date), this.scale);
    }

    private void notifyMove(Instant value) {
        if (this.moveListeners != null) {
            this.moveListeners.accept(value);
        }
    }

    private DateNavigatorState state() {
        return new DateNavigatorState().canPrevious(this.canPrevious()).canNext(this.canNext()).canPlay(this.canNext()).playing(this.playerStepTimer != null);
    }

    private Boolean canPrevious() {
        TimeRange range = this.timeScaleHandler().boundsRange();
        return this.date.isAfter(this.scale.normalise(range.from()));
    }

    private Boolean canNext() {
        TimeRange range = this.timeScaleHandler().boundsRange();
        Instant maxDate = this.scale.addTo(this.scale.normalise(range.to()), -1L);
        return this.date.isBefore(maxDate) || this.date.equals(maxDate);
    }

    private void refreshDate(TimeRange timeRange) {
        this.date = this.scale.normalise(timeRange.from());
        ((TimeNavigatorDisplayNotifier)this.notifier).refreshDate(this.date);
        ((TimeNavigatorDisplayNotifier)this.notifier).refreshState(this.state());
    }

    private void refreshScale(TimeRange timeRange) {
        this.scale = timeRange.scale();
        ((TimeNavigatorDisplayNotifier)this.notifier).refreshScale(this.scale.name());
        ((TimeNavigatorDisplayNotifier)this.notifier).refreshState(this.state());
    }
}

