/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.DisplayNotifier;
import io.intino.sumus.analytics.TimeRange;
import io.intino.sumus.analytics.exporters.Document;
import io.intino.sumus.analytics.viewmodels.FilterCondition;
import io.intino.sumus.analytics.viewmodels.Histogram;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.ChartDisplay;
import io.intino.sumus.box.displays.TimeNavigatorDisplay;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Ticket;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.sumus.helpers.ChartSpec;
import io.intino.sumus.queries.HistogramQuery;
import java.time.Instant;
import java.util.List;

public abstract class TimeHistogramDisplay<DN extends DisplayNotifier>
extends ChartDisplay<DN, TimeNavigatorDisplay> {
    private final String tag;

    public TimeHistogramDisplay(SumusBox box, String tag) {
        super(box, new TimeNavigatorDisplay(box));
        this.tag = tag;
    }

    private void refresh(Instant instant) {
        this.doQuery();
    }

    @Override
    public void addNavigatorListeners(TimeNavigatorDisplay display) {
        display.onMove(this::refresh);
    }

    @Override
    public boolean allowMultipleTickets() {
        return true;
    }

    @Override
    public boolean allowDrill() {
        return false;
    }

    @Override
    public Document export(Instant from, Instant to) {
        return null;
    }

    @Override
    public boolean isShowingEvents() {
        return false;
    }

    @Override
    public boolean allowTemporalFiltering() {
        return false;
    }

    @Override
    public void update() {
        this.sendCategorization();
        this.sendTicketCount();
        this.doQuery();
    }

    public void refresh() {
        super.refresh();
        this.doQuery();
    }

    protected abstract void sendCategorization();

    protected abstract void sendTicketCount();

    protected abstract void sendHistogram(Histogram var1);

    protected void doQuery() {
        Categorization categorization = this.categorization();
        if (categorization == null) {
            return;
        }
        this.notifyLoading(true);
        Histogram histogram = this.queryEngine().histogram(this.buildQuery());
        this.sendHistogram(histogram);
        this.notifyLoading(false);
    }

    protected Categorization categorization() {
        List<Categorization> categorizationList = this.specification().categorizationList(this.tag);
        return categorizationList.size() > 0 ? categorizationList.get(0) : null;
    }

    private HistogramQuery buildQuery() {
        ChartSpec specification = this.specification();
        List<Ticket> tickets = specification.ticketList();
        List<FilterCondition> filters = specification.filterList();
        return new HistogramQuery.Builder().filter(filters).addTickets(tickets).build(this.nameSpace(), this.categorization(), this.range(), null);
    }

    private TimeRange range() {
        TimeScale scale = ((TimeNavigatorDisplay)((Object)this.navigatorDisplay())).scale();
        Instant date = ((TimeNavigatorDisplay)((Object)this.navigatorDisplay())).date();
        return new TimeRange(date, scale.addTo(date, 1L), scale);
    }
}

