/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.sumus.analytics.categorization.TemporalCategorization;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.ChartDialogDisplay;
import io.intino.sumus.box.displays.SumusDisplay;
import io.intino.sumus.box.displays.TimeBarChartDialogDisplay;
import io.intino.sumus.box.displays.TimeCrossTableDialogDisplay;
import io.intino.sumus.box.displays.TimeScatterChartDialogDisplay;
import io.intino.sumus.box.displays.TimeSeriesChartDialogDisplay;
import io.intino.sumus.box.displays.builders.TicketBuilder;
import io.intino.sumus.box.displays.notifiers.TimeChartDesignDisplayNotifier;
import io.intino.sumus.graph.rules.Chart;
import io.intino.sumus.helpers.ChartSpec;
import io.intino.sumus.helpers.ChartSpecHandler;
import io.intino.sumus.helpers.TimeScaleHandler;
import java.util.List;
import java.util.Optional;

public class TimeChartDesignDisplay
extends SumusDisplay<TimeChartDesignDisplayNotifier> {
    private TimeScaleHandler timeScaleHandler;
    private ChartSpecHandler chartSpecHandler;
    private Chart selectedChart = null;

    public TimeChartDesignDisplay(SumusBox box) {
        super(box);
    }

    public void timeScaleHandler(TimeScaleHandler timeScaleHandler) {
        this.timeScaleHandler = timeScaleHandler;
    }

    public void chartSpecHandler(ChartSpecHandler chartSpecHandler) {
        this.chartSpecHandler = chartSpecHandler;
        this.chartSpecHandler.onChange(this::refresh);
    }

    public void selectChart(Chart chart) {
        this.selectedChart = chart;
        ((TimeChartDesignDisplayNotifier)this.notifier).refreshSelectedChart(chart.toString());
    }

    public void selectTickets(String[] tickets) {
        this.dialogDisplay().ifPresent(d -> d.selectTickets(tickets));
    }

    protected void init() {
        super.init();
        this.buildChartDialogs();
        ((TimeChartDesignDisplayNotifier)this.notifier).refreshTicketList(TicketBuilder.buildList(this.chartSpecHandler.olapTickets()));
    }

    public void refresh() {
        super.refresh();
        this.refresh(this.chartSpecHandler.specification());
    }

    private void refresh(ChartSpec chartSpec) {
        ((TimeChartDesignDisplayNotifier)this.notifier).refreshSelectedTicketList(TicketBuilder.buildList(chartSpec.ticketList()));
    }

    private void buildChartDialogs() {
        this.add(new TimeSeriesChartDialogDisplay(this.box));
        this.add(new TimeCrossTableDialogDisplay(this.box));
        this.add(new TimeBarChartDialogDisplay(this.box));
        this.add(new TimeScatterChartDialogDisplay(this.box));
    }

    private void add(ChartDialogDisplay display) {
        display.timeScaleHandler(this.timeScaleHandler);
        display.chartSpecHandler(this.chartSpecHandler);
        this.addAndPersonify(display);
    }

    public void updateTemporalCategorizations(List<TemporalCategorization> categorizations) {
        ((TimeCrossTableDialogDisplay)this.child(TimeCrossTableDialogDisplay.class)).updateTemporalCategorizations(categorizations);
    }

    private Optional<ChartDialogDisplay> dialogDisplay() {
        return this.children(ChartDialogDisplay.class).stream().filter(d -> d.type() == this.selectedChart).findFirst();
    }
}

