/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.sumus.analytics.viewmodels.Histogram;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.TimeHistogramDisplay;
import io.intino.sumus.box.displays.builders.HistogramBuilder;
import io.intino.sumus.box.displays.builders.ItemBuilder;
import io.intino.sumus.box.displays.notifiers.TimeBarChartDisplayNotifier;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.helpers.ChartSpec;

public class TimeBarChartDisplay
extends TimeHistogramDisplay<TimeBarChartDisplayNotifier> {
    public static final String Tag = "time-bar-chart";

    public TimeBarChartDisplay(SumusBox box) {
        super(box, Tag);
    }

    @Override
    protected void sendCategorization() {
        Categorization categorization = this.categorization();
        ((TimeBarChartDisplayNotifier)this.notifier).refreshCategorization(categorization != null ? ItemBuilder.build(categorization) : null);
    }

    @Override
    protected void sendTicketCount() {
        ((TimeBarChartDisplayNotifier)this.notifier).refreshTicketCount(this.specification().ticketList().size());
    }

    @Override
    protected void sendHistogram(Histogram histogram) {
        ((TimeBarChartDisplayNotifier)this.notifier).refreshHistogram(HistogramBuilder.build(histogram));
    }

    @Override
    public boolean isValidSpecification(ChartSpec spec) {
        return spec.ticketList().size() > 0 && this.categorization() != null;
    }

    @Override
    public void showDialog() {
        super.showDialog();
    }
}

