/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.DisplayNotifier;
import io.intino.sumus.analytics.TimeRange;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.CatalogDisplay;
import io.intino.sumus.box.displays.CatalogViewDisplayProvider;
import io.intino.sumus.box.displays.TimeNavigatorDisplay;
import io.intino.sumus.box.schemas.GroupingSelection;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.rules.Mode;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.sumus.graph.temporalcontainer.TemporalContainerCatalog;
import io.intino.sumus.helpers.Bounds;
import io.intino.sumus.helpers.TimeScaleHandler;
import io.intino.sumus.queries.TemporalRecordQuery;
import io.intino.tara.magritte.Concept;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public abstract class TemporalCatalogDisplay<C extends TemporalContainerCatalog, DN extends DisplayNotifier>
extends CatalogDisplay<C, DN> {
    private TimeScaleHandler timeScaleHandler;

    public TemporalCatalogDisplay(SumusBox box) {
        super(box);
    }

    @Override
    protected int countRecords(String condition) {
        return this.queryEngine().temporalRecordsCount(this.query(condition));
    }

    @Override
    protected List<Record> records(int start, int limit, String condition, CatalogViewDisplayProvider.Sorting sorting) {
        return this.queryEngine().temporalRecords(this.query(condition, sorting), start, limit).stream().map(e -> (Record)e.core$().as(Record.class)).collect(Collectors.toList());
    }

    @Override
    protected Record record(String id) {
        return this.queryEngine().temporalRecord(id);
    }

    @Override
    protected boolean canCreateClusters() {
        return false;
    }

    @Override
    public void selectGrouping(GroupingSelection value) {
        super.selectGrouping(value);
    }

    @Override
    protected void init() {
        this.timeScaleHandler = this.buildTimeScaleHandler();
        super.init();
        this.buildTimeNavigator(this.timeScaleHandler);
    }

    private void buildTimeNavigator(TimeScaleHandler timeScaleHandler) {
        TimeNavigatorDisplay display = new TimeNavigatorDisplay(this.box);
        display.timeScaleHandler(timeScaleHandler);
        display.onMove(this::refresh);
        this.addAndPersonify(display);
    }

    private void refresh(Instant instant) {
        this.refreshView();
    }

    private TimeScaleHandler buildTimeScaleHandler() {
        TimeRange range = this.queryEngine().temporalRecordRange(((TemporalContainerCatalog)this.catalog).nameSpace());
        TimeScaleHandler.Bounds bounds = new TimeScaleHandler.Bounds();
        List<TimeScale> scales = ((TemporalContainerCatalog)this.catalog).scales();
        HashMap<TimeScale, Bounds.Zoom> zoomMap = new HashMap<TimeScale, Bounds.Zoom>();
        bounds.range(new TimeRange(range.from(), range.to(), TimeScale.Minute));
        bounds.mode(Mode.ToTheLast);
        scales.forEach(scale -> zoomMap.put((TimeScale)((Object)scale), new Bounds.Zoom().min(0).max(200)));
        bounds.zooms(zoomMap);
        TimeScaleHandler timeScaleHandler = new TimeScaleHandler(bounds, scales, scales.get(0));
        timeScaleHandler.availableScales(this.localizedScales(scales));
        timeScaleHandler.updateInstant(range.to(), scales.get(0));
        return timeScaleHandler;
    }

    @Override
    protected TimeScale scale() {
        return this.timeScaleHandler.range().scale();
    }

    private TemporalRecordQuery query(String condition) {
        return this.query(condition, null);
    }

    private TemporalRecordQuery query(String condition, CatalogViewDisplayProvider.Sorting sorting) {
        TemporalRecordQuery.Builder builder = new TemporalRecordQuery.Builder();
        builder.sorting(sorting);
        builder.condition(condition);
        builder.timeRange(this.timeScaleHandler.range());
        builder.nameSpace(((TemporalContainerCatalog)this.catalog).nameSpace());
        return builder.build(this.recordConcept());
    }

    protected abstract Concept recordConcept();
}

