/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.Display;
import io.intino.konos.server.activity.displays.DisplayNotifier;
import io.intino.konos.server.activity.services.push.ActivityClient;
import io.intino.konos.server.activity.services.push.ActivitySession;
import io.intino.konos.server.activity.services.push.User;
import io.intino.sumus.QueryEngine;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.graph.SumusGraph;
import io.intino.sumus.graph.rules.TimeScale;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class SumusDisplay<N extends DisplayNotifier>
extends Display<N> {
    private QueryEngine queryEngine;
    final SumusBox box;

    public SumusDisplay(SumusBox box) {
        this.box = box;
    }

    SumusGraph platform() {
        return this.box.graph();
    }

    Optional<User> currentUser() {
        ActivityClient client = (ActivityClient)this.session().currentClient();
        return Optional.ofNullable(this.session().user());
    }

    String currentLanguage() {
        ActivitySession session = this.session();
        if (session == null) {
            return "en";
        }
        ActivityClient client = (ActivityClient)session.currentClient();
        return client != null ? client.language() : this.session().browser().languageFromMetadata();
    }

    List<TimeScale> localizedScales(List<TimeScale> scales) {
        return scales.stream().map(this::scaleWithLabel).collect(Collectors.toList());
    }

    TimeScale scaleWithLabel(TimeScale scale) {
        scale.label(this.box.translatorHelper().translate(scale.toString()).into(this.currentLanguage()));
        return scale;
    }

    URL baseAssetUrl() {
        try {
            return new URL(this.session().browser().baseAssetUrl());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    QueryEngine queryEngine() {
        if (this.queryEngine == null) {
            this.queryEngine = new QueryEngine(this.box);
        }
        return this.queryEngine;
    }
}

