/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.Display;
import io.intino.sumus.analytics.viewmodels.CatalogView;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.CatalogListViewDisplay;
import io.intino.sumus.box.displays.CatalogMagazineViewDisplay;
import io.intino.sumus.box.displays.CatalogMapViewDisplay;
import io.intino.sumus.box.displays.CatalogOlapViewDisplay;
import io.intino.sumus.box.displays.CatalogViewDisplay;
import io.intino.sumus.box.displays.CatalogViewDisplayProvider;
import io.intino.sumus.box.displays.SumusDisplay;
import io.intino.sumus.box.displays.builders.ItemBuilder;
import io.intino.sumus.box.displays.notifiers.CatalogViewListDisplayNotifier;
import io.intino.sumus.box.schemas.DialogLocation;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Cluster;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class CatalogViewListDisplay
extends SumusDisplay<CatalogViewListDisplayNotifier> {
    private List<Consumer<CatalogViewDisplay>> selectListeners = new ArrayList<Consumer<CatalogViewDisplay>>();
    private Map<String, Function<CatalogView, ? extends Display>> builders = new HashMap<String, Function<CatalogView, ? extends Display>>();
    private List<CatalogView> viewList;
    private CatalogViewDisplayProvider provider;
    private List<Consumer<Boolean>> loadingListeners = new ArrayList<Consumer<Boolean>>();
    private List<Consumer<DialogLocation>> openDialogListeners = new ArrayList<Consumer<DialogLocation>>();
    private List<Consumer<Cluster>> createClusterListeners = new ArrayList<Consumer<Cluster>>();
    private Map<String, CatalogViewDisplay> viewDisplayMap = new HashMap<String, CatalogViewDisplay>();

    public CatalogViewListDisplay(SumusBox box) {
        super(box);
        this.registerBuilders();
    }

    public void recordProvider(CatalogViewDisplayProvider provider) {
        this.provider = provider;
    }

    public void viewList(List<CatalogView> viewList) {
        this.viewList = viewList;
    }

    public void onSelectView(Consumer<CatalogViewDisplay> listener) {
        this.selectListeners.add(listener);
    }

    public void onLoading(Consumer<Boolean> listener) {
        this.loadingListeners.add(listener);
    }

    public void onCreateCluster(Consumer<Cluster> listener) {
        this.createClusterListeners.add(listener);
    }

    public void onOpenDialog(Consumer<DialogLocation> listener) {
        this.openDialogListeners.add(listener);
    }

    private void registerBuilders() {
        this.builders.put(Catalog.MagazineView.class.getSimpleName(), this::buildMagazineViewDisplay);
        this.builders.put(Catalog.ListView.class.getSimpleName(), this::buildListViewDisplay);
        this.builders.put(Catalog.GridView.class.getSimpleName(), this::buildListViewDisplay);
        this.builders.put(Catalog.MapView.class.getSimpleName(), this::buildMapViewDisplay);
        this.builders.put(Catalog.OlapView.class.getSimpleName(), this::buildOlapViewDisplay);
    }

    public void selectView(String name) {
        CatalogViewDisplay display = this.viewDisplayMap.get(name);
        this.selectListeners.forEach(l -> l.accept(display));
    }

    protected void init() {
        super.init();
        this.sendViewList();
        this.buildViewListDisplays();
        if (this.viewList.size() > 0) {
            this.selectView(this.viewList.get(0).name());
        }
    }

    private void sendViewList() {
        ((CatalogViewListDisplayNotifier)this.notifier).refreshViewList(ItemBuilder.buildCatalogViewList(this.viewList));
    }

    private void buildViewListDisplays() {
        this.viewList.forEach(view -> this.builders.get(view.type()).apply((CatalogView)view));
    }

    private CatalogMagazineViewDisplay buildMagazineViewDisplay(CatalogView view) {
        CatalogMagazineViewDisplay display = new CatalogMagazineViewDisplay(this.box);
        this.registerViewDisplay(display, view);
        this.add(display);
        display.personifyOnce();
        return display;
    }

    private CatalogListViewDisplay buildListViewDisplay(CatalogView view) {
        CatalogListViewDisplay display = new CatalogListViewDisplay(this.box);
        this.registerViewDisplay(display, view);
        this.add((Display)display);
        display.personifyOnce();
        return display;
    }

    private CatalogMapViewDisplay buildMapViewDisplay(CatalogView view) {
        CatalogMapViewDisplay display = new CatalogMapViewDisplay(this.box);
        this.registerViewDisplay(display, view);
        this.add((Display)display);
        display.personifyOnce();
        return display;
    }

    private CatalogOlapViewDisplay buildOlapViewDisplay(CatalogView view) {
        CatalogOlapViewDisplay display = new CatalogOlapViewDisplay(this.box);
        this.registerViewDisplay(display, view);
        this.add(display);
        display.personifyOnce();
        return display;
    }

    private void registerViewDisplay(CatalogViewDisplay display, CatalogView view) {
        display.provider(this.provider);
        display.onOpenDialog(this::openDialog);
        display.onCreateCluster(this::notifyCreateCluster);
        display.view(view);
        this.viewDisplayMap.put(view.name(), display);
    }

    private void openDialog(DialogLocation location) {
        this.openDialogListeners.forEach(l -> l.accept(location));
    }

    private void notifyLoading(Boolean loading) {
        this.loadingListeners.forEach(l -> l.accept(loading));
    }

    private void notifyCreateCluster(Cluster cluster) {
        this.createClusterListeners.forEach(l -> l.accept(cluster));
    }
}

