/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.PageDisplay;
import io.intino.sumus.analytics.viewmodels.CatalogView;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.CatalogViewDisplay;
import io.intino.sumus.box.displays.CatalogViewDisplayProvider;
import io.intino.sumus.box.displays.builders.CatalogItemBuilder;
import io.intino.sumus.box.displays.builders.CatalogViewBuilder;
import io.intino.sumus.box.displays.notifiers.CatalogMapViewDisplayNotifier;
import io.intino.sumus.box.schemas.Bounds;
import io.intino.sumus.box.schemas.CatalogItem;
import io.intino.sumus.box.schemas.DialogLocation;
import io.intino.sumus.graph.Cluster;
import io.intino.sumus.helpers.Asset;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class CatalogMapViewDisplay
extends PageDisplay<CatalogMapViewDisplayNotifier>
implements CatalogViewDisplay {
    private CatalogView view;
    private CatalogViewDisplayProvider provider;
    private SumusBox box;
    private List<Consumer<DialogLocation>> openDialogListeners = new ArrayList<Consumer<DialogLocation>>();

    public CatalogMapViewDisplay(SumusBox box) {
        this.box = box;
    }

    @Override
    public void view(CatalogView view) {
        this.view = view;
    }

    @Override
    public void provider(CatalogViewDisplayProvider provider) {
        this.provider = provider;
    }

    @Override
    public void onOpenDialog(Consumer<DialogLocation> location) {
        this.openDialogListeners.add(location);
    }

    @Override
    public void onCreateCluster(Consumer<Cluster> listener) {
    }

    public int countItems() {
        return this.provider.countRecords(null);
    }

    public void page(Integer value) {
        super.page(value.intValue());
    }

    public void location(Bounds value) {
    }

    protected void init() {
        super.init();
        this.sendView();
    }

    protected void sendItems(int start, int limit) {
        ((CatalogMapViewDisplayNotifier)this.notifier).refresh(CatalogItemBuilder.buildList(this.provider.records(start, limit, null), this.provider.stamps(), this.provider.scale(), Asset.baseAssetUrl(this.session())));
    }

    protected void sendClear() {
        ((CatalogMapViewDisplayNotifier)this.notifier).clear();
    }

    protected void sendCount(int count) {
        ((CatalogMapViewDisplayNotifier)this.notifier).refreshCount(count);
    }

    private void sendView() {
        ((CatalogMapViewDisplayNotifier)this.notifier).refreshView(CatalogViewBuilder.build(this.view));
    }

    public void openDialog(DialogLocation location) {
        this.openDialogListeners.forEach(l -> l.accept(location));
    }

    @Override
    public void refreshItem(CatalogItem item) {
        ((CatalogMapViewDisplayNotifier)this.notifier).refreshItem(item);
    }
}

