/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.Display;
import io.intino.konos.server.activity.spark.ActivityFile;
import io.intino.sumus.analytics.viewmodels.CatalogView;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.CatalogViewDisplay;
import io.intino.sumus.box.displays.CatalogViewDisplayProvider;
import io.intino.sumus.box.displays.PageContainerDisplay;
import io.intino.sumus.box.displays.RecordDisplay;
import io.intino.sumus.box.displays.SumusDisplay;
import io.intino.sumus.box.displays.builders.CatalogItemBuilder;
import io.intino.sumus.box.displays.builders.CatalogViewBuilder;
import io.intino.sumus.box.displays.notifiers.CatalogMagazineViewDisplayNotifier;
import io.intino.sumus.box.schemas.CatalogItem;
import io.intino.sumus.box.schemas.DialogLocation;
import io.intino.sumus.box.schemas.DownloadItemParameters;
import io.intino.sumus.box.schemas.PageLocation;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Cluster;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.functions.CatalogStampDownload;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class CatalogMagazineViewDisplay
extends SumusDisplay<CatalogMagazineViewDisplayNotifier>
implements CatalogViewDisplay {
    private CatalogView view;
    private CatalogViewDisplayProvider provider;
    private List<Consumer<DialogLocation>> openDialogListeners = new ArrayList<Consumer<DialogLocation>>();
    private Record record = null;
    private String condition = null;
    private boolean recordDisplaysCreated = false;

    public CatalogMagazineViewDisplay(SumusBox box) {
        super(box);
    }

    @Override
    public void view(CatalogView view) {
        this.view = view;
    }

    @Override
    public void provider(CatalogViewDisplayProvider provider) {
        this.provider = provider;
    }

    @Override
    public void onOpenDialog(Consumer<DialogLocation> location) {
        this.openDialogListeners.add(location);
    }

    @Override
    public void onCreateCluster(Consumer<Cluster> listener) {
    }

    public void openDialog(DialogLocation location) {
        this.openDialogListeners.forEach(l -> l.accept(location));
    }

    @Override
    public void refreshItem(CatalogItem item) {
        ((CatalogMagazineViewDisplayNotifier)this.notifier).refreshItem(item);
    }

    protected void init() {
        super.init();
        this.sendView();
        this.loadRecord();
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.record == null) {
            return;
        }
        this.children(RecordDisplay.class).forEach(display -> {
            display.record(this.record.name$());
            display.refresh();
        });
        this.remove(PageContainerDisplay.class);
        this.send(this.record);
    }

    public void filter(String value) {
        this.condition = value;
        this.loadRecord();
        this.refresh();
    }

    public void itemStampsReady(String id) {
        if (!this.recordDisplaysCreated) {
            this.displays(this.record).forEach(display -> {
                this.add((Display)display);
                display.personifyOnce(id);
                display.refresh();
            });
        }
        this.pages(this.record).forEach(display -> {
            this.add((Display)display);
            display.personifyOnce(id);
            display.refresh();
        });
        this.recordDisplaysCreated = true;
    }

    public void selectRecord(String name) {
        this.record = this.provider.record(name);
        this.refresh();
    }

    public ActivityFile downloadItem(DownloadItemParameters parameters) {
        Catalog.Mold.Block.Stamp stamp = this.provider.stamps().stream().filter((? super T s) -> s.name$().equals(parameters.stamp())).findFirst().orElse(null);
        final CatalogStampDownload.Resource resource = stamp.asDownloadOperation().execute(this.record, parameters.option());
        return new ActivityFile(){

            public String label() {
                return resource.label();
            }

            public InputStream content() {
                return resource.content();
            }
        };
    }

    private void send(Record record) {
        ((CatalogMagazineViewDisplayNotifier)this.notifier).refreshItem(CatalogItemBuilder.build(record, this.provider.stamps(), this.provider.scale(), this.baseAssetUrl()));
    }

    private void sendView() {
        ((CatalogMagazineViewDisplayNotifier)this.notifier).refreshView(CatalogViewBuilder.build(this.view));
    }

    private void loadRecord() {
        int count = this.provider.countRecords(this.condition);
        this.record = count > 0 ? this.provider.records(0, 1, this.condition).get(0) : null;
    }

    private List<Display> displays(Record record) {
        return this.provider.stamps().stream().filter(Catalog.Mold.Block.Stamp::isDisplay).map(stamp -> this.provider.display(stamp.name$())).filter(Objects::nonNull).map(display -> display.record(record.name$())).collect(Collectors.toList());
    }

    private List<Display> pages(Record record) {
        return this.provider.stamps().stream().filter(Catalog.Mold.Block.Stamp::isPage).map(stamp -> new PageContainerDisplay(this.box).pageLocation(this.location((Catalog.Mold.Block.Stamp)((Object)stamp), record))).collect(Collectors.toList());
    }

    private PageLocation location(Catalog.Mold.Block.Stamp stamp, Record record) {
        PageLocation location = new PageLocation();
        if (stamp.isExternalPage()) {
            return location.value(stamp.asExternalPage().url(record.name$()).toString()).internal(false);
        }
        return location.value(stamp.asInternalPage().path(record.name$())).internal(true);
    }
}

