/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.DisplayNotifier;
import io.intino.sumus.Category;
import io.intino.sumus.analytics.viewmodels.CatalogView;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.CatalogViewDisplay;
import io.intino.sumus.box.displays.CatalogViewDisplayProvider;
import io.intino.sumus.box.displays.CatalogViewListDisplay;
import io.intino.sumus.box.displays.DialogContainerDisplay;
import io.intino.sumus.box.displays.RecordDisplay;
import io.intino.sumus.box.displays.StampDisplayProvider;
import io.intino.sumus.box.displays.SumusDisplay;
import io.intino.sumus.box.displays.builders.CatalogItemBuilder;
import io.intino.sumus.box.schemas.CatalogItem;
import io.intino.sumus.box.schemas.DialogLocation;
import io.intino.sumus.box.schemas.GroupingGroup;
import io.intino.sumus.box.schemas.GroupingSelection;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Cluster;
import io.intino.sumus.graph.Entity;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.container.ContainerCatalog;
import io.intino.sumus.graph.entitycontainer.EntityContainerCatalog;
import io.intino.sumus.graph.eventcontainer.EventContainerCatalog;
import io.intino.sumus.graph.reportcontainer.ReportContainerCatalog;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.tara.magritte.Concept;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public abstract class CatalogDisplay<C extends ContainerCatalog, DN extends DisplayNotifier>
extends SumusDisplay<DN> {
    protected Map<String, GroupingSelection> groupingSelectionMap = new HashMap<String, GroupingSelection>();
    protected Map<String, List<Entity>> activeEntities = null;
    protected List<Consumer<Boolean>> loadingListeners = new ArrayList<Consumer<Boolean>>();
    protected C catalog;
    private CatalogViewDisplay currentView = null;
    private String currentRecord = null;
    private StampDisplayProvider stampDisplayProvider = null;

    public CatalogDisplay(SumusBox box) {
        super(box);
    }

    public void catalog(C catalog) {
        this.catalog = catalog;
    }

    public void stampDisplayProvider(StampDisplayProvider provider) {
        this.stampDisplayProvider = provider;
    }

    public void onLoading(Consumer<Boolean> listener) {
        this.loadingListeners.add(listener);
    }

    public void selectGrouping(GroupingSelection selection) {
        Catalog.AbstractGrouping abstractGrouping = this.groupingOf(selection.name());
        if (abstractGrouping.histogram() == Catalog.AbstractGrouping.Histogram.Absolute && selection.groups().size() <= 0) {
            this.groupingSelectionMap.remove(selection.name());
        } else {
            this.groupingSelectionMap.put(selection.name(), selection);
        }
        this.refreshGrouping();
    }

    public void deleteGroupingGroup(GroupingGroup groupingGroup) {
        Catalog.AbstractGrouping abstractGrouping = this.groupingOf(groupingGroup.grouping());
        if (!abstractGrouping.core$().is(Catalog.ClusterGrouping.class)) {
            return;
        }
        Catalog.ClusterGrouping grouping = (Catalog.ClusterGrouping)abstractGrouping.core$().as(Catalog.ClusterGrouping.class);
        Cluster.Group group = grouping.cluster().groupList().stream().filter(g -> g.name$().equals(groupingGroup.name())).findFirst().orElse(null);
        if (group == null) {
            return;
        }
        group.delete$();
        grouping.cluster().save$();
        this.sendCatalog();
        if (this.groupingSelectionMap.containsKey(groupingGroup.grouping())) {
            GroupingSelection groupingSelection = this.groupingSelectionMap.get(groupingGroup.grouping());
            groupingSelection.groups().remove(group.label());
            this.selectGrouping(groupingSelection);
        }
    }

    private void refreshGrouping() {
        this.refreshLoading(true);
        this.refreshActiveEntities();
        this.queryEngine().filter(this.activeEntities);
        this.refreshView();
        this.refreshLoading(false);
    }

    protected Optional<CatalogViewDisplay> currentView() {
        return Optional.ofNullable(this.currentView);
    }

    private void updateCurrentView(CatalogViewDisplay display) {
        this.currentView = display;
        this.refreshView();
    }

    public void refreshView() {
        this.refreshLoading(true);
        this.currentView().ifPresent(CatalogViewDisplay::refresh);
        this.refreshLoading(false);
    }

    protected CatalogView catalogViewOf(final Catalog.View view) {
        return new CatalogView(){

            @Override
            public String name() {
                return view.core$().name();
            }

            @Override
            public String label() {
                return CatalogDisplay.this.catalogViewLabelOf(view);
            }

            @Override
            public String type() {
                return ((Object)((Object)view)).getClass().getSimpleName();
            }

            @Override
            public String option() {
                if (!view.core$().is(Catalog.OlapView.class)) {
                    return null;
                }
                return ((Catalog.OlapView)view.core$().as(Catalog.OlapView.class)).olap().name$();
            }

            @Override
            public Catalog.Mold mold() {
                if (view.core$().is(Catalog.MagazineView.class)) {
                    return ((Catalog.MagazineView)view.core$().as(Catalog.MagazineView.class)).mold();
                }
                if (view.core$().is(Catalog.ListView.class)) {
                    return ((Catalog.ListView)view.core$().as(Catalog.ListView.class)).mold();
                }
                if (view.core$().is(Catalog.GridView.class)) {
                    return ((Catalog.GridView)view.core$().as(Catalog.GridView.class)).mold();
                }
                if (view.core$().is(Catalog.MapView.class)) {
                    return ((Catalog.MapView)view.core$().as(Catalog.MapView.class)).mold();
                }
                return null;
            }

            @Override
            public Catalog.View rawView() {
                return view;
            }

            @Override
            public boolean canCreateClusters() {
                return CatalogDisplay.this.canCreateClusters();
            }

            @Override
            public List<String> clusters() {
                return ((ContainerCatalog)((Object)CatalogDisplay.this.catalog)).clusterGroupingList().stream().map(Catalog.AbstractGrouping::label).collect(Collectors.toList());
            }

            @Override
            public Catalog catalog() {
                return (Catalog)CatalogDisplay.this.catalog.core$().as(Catalog.class);
            }
        };
    }

    protected void init() {
        super.init();
        this.buildViewList();
        this.sendCatalog();
        this.createDialogContainer();
    }

    protected abstract void refreshLoading(boolean var1);

    protected abstract void sendCatalog();

    protected abstract void showDialog();

    protected abstract int countRecords(String var1);

    protected abstract List<Record> records(int var1, int var2, String var3, CatalogViewDisplayProvider.Sorting var4);

    protected abstract Record record(String var1);

    protected abstract boolean canCreateClusters();

    protected abstract TimeScale scale();

    protected List<CatalogView> viewList() {
        return ((ContainerCatalog)((Object)this.catalog)).viewList().stream().map(this::catalogViewOf).collect(Collectors.toList());
    }

    private void buildViewList() {
        CatalogViewListDisplay display = new CatalogViewListDisplay(this.box);
        display.recordProvider(new CatalogViewDisplayProvider(){

            @Override
            public Concept context() {
                if (CatalogDisplay.this.catalog.core$().is(EntityContainerCatalog.class)) {
                    return ((EntityContainerCatalog)CatalogDisplay.this.catalog.core$().as(EntityContainerCatalog.class)).entity();
                }
                if (CatalogDisplay.this.catalog.core$().is(EventContainerCatalog.class)) {
                    return ((EventContainerCatalog)CatalogDisplay.this.catalog.core$().as(EventContainerCatalog.class)).event();
                }
                if (CatalogDisplay.this.catalog.core$().is(ReportContainerCatalog.class)) {
                    return ((ReportContainerCatalog)CatalogDisplay.this.catalog.core$().as(ReportContainerCatalog.class)).report();
                }
                return null;
            }

            @Override
            public int countRecords(String condition) {
                return CatalogDisplay.this.countRecords(condition);
            }

            @Override
            public List<Record> records(int start, int limit, String condition) {
                return this.records(start, limit, condition, null);
            }

            @Override
            public List<Record> records(int start, int limit, String condition, CatalogViewDisplayProvider.Sorting sorting) {
                return CatalogDisplay.this.records(start, limit, condition, sorting);
            }

            @Override
            public Record record(String name) {
                return CatalogDisplay.this.record(name);
            }

            @Override
            public List<Catalog.Sorting> sortings() {
                return ((ContainerCatalog)((Object)CatalogDisplay.this.catalog)).sortingList();
            }

            @Override
            public TimeScale scale() {
                return CatalogDisplay.this.scale();
            }

            @Override
            public List<Catalog.Mold.Block.Stamp> stamps() {
                return CatalogDisplay.this.stamps();
            }

            @Override
            public List<Catalog.Mold.Block.Stamp> expandedStamps() {
                return CatalogDisplay.this.expandedStamps();
            }

            @Override
            public RecordDisplay display(String stamp) {
                return CatalogDisplay.this.stampDisplayProvider != null ? CatalogDisplay.this.stampDisplayProvider.display(stamp) : null;
            }

            @Override
            public Catalog.Sorting sorting(String key) {
                return ((ContainerCatalog)((Object)CatalogDisplay.this.catalog)).sortingList().stream().filter(s -> s.name$().equals(key) || s.label().equals(key)).findFirst().orElse(null);
            }
        });
        display.viewList(this.viewList());
        display.onSelectView(this::updateCurrentView);
        display.onOpenDialog(this::openDialog);
        display.onLoading(this::notifyLoading);
        display.onCreateCluster(this::refreshCatalog);
        this.add(display);
        display.personifyOnce();
    }

    private void refreshCatalog(Cluster cluster) {
        this.sendCatalog();
    }

    private void openDialog(DialogLocation location) {
        this.currentRecord = new String(Base64.getDecoder().decode(location.item()));
        DialogContainerDisplay display = (DialogContainerDisplay)this.child(DialogContainerDisplay.class);
        Catalog.Mold.Block.Stamp stamp = this.stamp(location.stamp());
        display.dialogLocation(stamp.asOpenDialogOperation().path(location.item()));
        display.refresh();
        this.showDialog();
    }

    private void refreshActiveEntities() {
        if (this.groupingSelectionMap.size() <= 0) {
            this.activeEntities = null;
            return;
        }
        if (this.activeEntities == null) {
            this.activeEntities = new HashMap<String, List<Entity>>();
        }
        this.activeEntities.clear();
        this.activeEntities.putAll(this.groupingSelectionMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.union((GroupingSelection)e.getValue()))));
    }

    private List<Entity> union(GroupingSelection selection) {
        return selection.groups().stream().map(group -> this.entities(selection.name(), (String)group)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<Entity> entities(String groupingName, String groupName) {
        Catalog.AbstractGrouping grouping = this.groupingOf(groupingName);
        return this.entitiesOf(grouping, groupName);
    }

    private List<Entity> entitiesOf(Catalog.AbstractGrouping grouping, String groupLabel) {
        if (grouping.core$().is(Catalog.Grouping.class)) {
            return new ArrayList<Entity>(this.entitiesOf(((Category)((Catalog.Grouping)grouping.core$().as(Catalog.Grouping.class)).categorization().categoryMap().get(groupLabel)).entityIds()));
        }
        Catalog.ClusterGrouping clusterGrouping = (Catalog.ClusterGrouping)grouping.core$().as(Catalog.ClusterGrouping.class);
        Cluster.Group group = clusterGrouping.cluster().groupList().stream().filter(g -> g.label().equals(groupLabel)).findFirst().orElse(null);
        return group.entities();
    }

    private List<Entity> entitiesOf(Set<String> ids) {
        return ids.stream().map(this::entity).collect(Collectors.toList());
    }

    protected Entity entity(String id) {
        return (Entity)this.box.graph().core$().load(id).as(Entity.class);
    }

    private Catalog.AbstractGrouping groupingOf(String groupingName) {
        return ((ContainerCatalog)((Object)this.catalog)).abstractGroupingList().stream().filter(g -> g.name$().equals(groupingName)).findFirst().orElse(null);
    }

    private String catalogViewLabelOf(Catalog.View view) {
        if (view.core$().is(Catalog.MagazineView.class)) {
            return ((Catalog.MagazineView)view.core$().as(Catalog.MagazineView.class)).label();
        }
        if (view.core$().is(Catalog.ListView.class)) {
            return ((Catalog.ListView)view.core$().as(Catalog.ListView.class)).label();
        }
        if (view.core$().is(Catalog.GridView.class)) {
            return ((Catalog.GridView)view.core$().as(Catalog.GridView.class)).label();
        }
        if (view.core$().is(Catalog.MapView.class)) {
            return ((Catalog.MapView)view.core$().as(Catalog.MapView.class)).label();
        }
        if (view.core$().is(Catalog.OlapView.class)) {
            String label = ((Catalog.OlapView)view.core$().as(Catalog.OlapView.class)).label();
            return !label.isEmpty() ? label : ((Catalog.OlapView)view.core$().as(Catalog.OlapView.class)).olap().label();
        }
        return "";
    }

    private List<Catalog.Mold.Block.Stamp> stamps() {
        return ((ContainerCatalog)((Object)this.catalog)).moldList().stream().map(Catalog.Mold::blockList).flatMap(Collection::stream).map(this::stamps).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<Catalog.Mold.Block.Stamp> expandedStamps() {
        return ((ContainerCatalog)((Object)this.catalog)).moldList().stream().map(Catalog.Mold::blockList).flatMap(Collection::stream).filter(Catalog.Mold.Block::isExpanded).map(this::stamps).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<Catalog.Mold.Block.Stamp> stamps(Catalog.Mold.Block block) {
        ArrayList<Catalog.Mold.Block.Stamp> stamps = new ArrayList<Catalog.Mold.Block.Stamp>();
        stamps.addAll(block.stampList());
        block.blockList().forEach(child -> stamps.addAll(this.stamps((Catalog.Mold.Block)((Object)child))));
        return stamps;
    }

    private Catalog.Mold.Block.Stamp stamp(String name) {
        return this.stamps().stream().filter(s -> s.name$().equals(name)).findFirst().orElse(null);
    }

    private void notifyLoading(Boolean loading) {
        this.loadingListeners.forEach(l -> l.accept(loading));
    }

    private void createDialogContainer() {
        DialogContainerDisplay display = new DialogContainerDisplay(this.box);
        display.onDialogAssertion(modification -> this.currentView().ifPresent(view -> {
            if (modification.toLowerCase().equals("itemmodified")) {
                view.refreshItem(this.currentItem());
            } else {
                view.refresh();
            }
        }));
        this.add(display);
        display.personifyOnce();
    }

    private CatalogItem currentItem() {
        Record record = this.record(this.currentRecord);
        return CatalogItemBuilder.build(record, this.stamps(), this.scale(), this.baseAssetUrl());
    }
}

