/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box;

import io.intino.konos.Box;
import io.intino.konos.LogFormatter;
import io.intino.konos.server.activity.ActivityKonosSpark;
import io.intino.konos.server.activity.services.AuthService;
import io.intino.sumus.box.PlatformWebActivity;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.SumusConfiguration;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractBox
extends Box {
    private static Logger LOG = Logger.getGlobal();
    protected SumusConfiguration configuration;

    public AbstractBox(String[] args) {
        this(new SumusConfiguration(args));
    }

    public AbstractBox(SumusConfiguration configuration) {
        this.configuration = configuration;
        if (this.configuration().platformWebConfiguration != null) {
            ActivityKonosSpark.setup((int)this.configuration().platformWebConfiguration.port, (String)this.configuration().platformWebConfiguration.webDirectory, (AuthService)this.configuration().platformWebConfiguration.authService);
        }
    }

    public SumusConfiguration configuration() {
        return this.configuration;
    }

    public Box put(Object o) {
        return this;
    }

    public Box open() {
        if (this.owner != null) {
            this.owner.open();
        }
        this.initActivities();
        this.initRESTServices();
        this.initJMXServices();
        this.initJMSServices();
        this.initDataLake();
        this.initTasks();
        this.initSlackBots();
        return this;
    }

    public void close() {
        if (this.owner != null) {
            this.owner.close();
        }
    }

    private void initRESTServices() {
    }

    private void initJMSServices() {
    }

    private void initJMXServices() {
    }

    private void initSlackBots() {
    }

    private void initActivities() {
        if (this.configuration().platformWebConfiguration == null) {
            return;
        }
        PlatformWebActivity.init(ActivityKonosSpark.instance(), (SumusBox)this);
    }

    private void initDataLake() {
    }

    private void initTasks() {
    }

    private void initLogger() {
        Logger logger = Logger.getGlobal();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.INFO);
        handler.setFormatter((Formatter)new LogFormatter("log"));
        logger.addHandler(handler);
    }
}

