/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.analytics.viewmodels;

import io.intino.sumus.Category;
import io.intino.sumus.analytics.Scaler;
import io.intino.sumus.graph.AbstractMetric;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CrossTable {
    private final AbstractMetric.Unit unit;
    private Double maxValue = null;
    private Map<String, Double> values = new HashMap<String, Double>();

    public CrossTable(AbstractMetric.Unit unit) {
        this.unit = unit;
    }

    public void register(List<Category> categories, double value) {
        String key = this.categoriesKey(categories);
        if (!this.values.containsKey(key)) {
            this.values.put(key, 0.0);
        }
        this.values.put(key, value += this.values.get(key).doubleValue());
        this.updateBounds(value);
    }

    public Double value(List<String> categories) {
        String key = this.categoriesKeyFromIds(categories);
        return this.values.containsKey(key) ? this.values.get(key) : Double.valueOf(0.0);
    }

    public Scaler scaler() {
        AbstractMetric metric = (AbstractMetric)this.unit.core$().ownerAs(AbstractMetric.class);
        Double maxValue = this.maxValue != null ? this.maxValue : -1.0;
        return metric.scaler().scaler(maxValue, this.unit);
    }

    private String categoriesKeyFromIds(List<String> categories) {
        categories.sort(Comparator.naturalOrder());
        return categories.stream().collect(Collectors.joining());
    }

    private String categoriesKey(List<Category> categories) {
        categories.sort(Comparator.comparing(Category::label));
        return categories.stream().map(Category::label).collect(Collectors.joining());
    }

    private void updateBounds(double value) {
        if (this.maxValue == null || this.maxValue < value) {
            this.maxValue = value;
        }
    }
}

