/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.analytics.viewmodels;

import io.intino.sumus.Category;
import io.intino.sumus.analytics.viewmodels.CategoryView;
import io.intino.sumus.graph.Categorization;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class CategorizationView {
    private final String name;
    private final String label;
    private final List<CategoryView> categories;
    private final String entity;

    public CategorizationView(Categorization categorization, List<Category> categories) {
        this.name = categorization.name$();
        this.label = categorization.label();
        this.categories = categories.stream().sorted(this.byLabel()).map(CategoryView::new).collect(Collectors.toList());
        this.entity = categorization.entity() != null ? categorization.entity().name() : "";
    }

    private Comparator<Category> byLabel() {
        return Comparator.comparing(Category::label);
    }

    public String name() {
        return this.name;
    }

    public String label() {
        return this.label;
    }

    public String entity() {
        return this.entity;
    }

    public List<CategoryView> categories() {
        return this.categories;
    }
}

