/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.analytics.categorization;

import io.intino.sumus.analytics.TimeRange;
import io.intino.sumus.analytics.categorization.TemporalCategorization;
import io.intino.sumus.analytics.categorization.temporal.DayCategorization;
import io.intino.sumus.analytics.categorization.temporal.FifteenMinutesCategorization;
import io.intino.sumus.analytics.categorization.temporal.HourCategorization;
import io.intino.sumus.analytics.categorization.temporal.MinuteCategorization;
import io.intino.sumus.analytics.categorization.temporal.MonthCategorization;
import io.intino.sumus.analytics.categorization.temporal.QuarterCategorization;
import io.intino.sumus.analytics.categorization.temporal.SecondCategorization;
import io.intino.sumus.analytics.categorization.temporal.SixHoursCategorization;
import io.intino.sumus.analytics.categorization.temporal.WeekCategorization;
import io.intino.sumus.analytics.categorization.temporal.YearCategorization;
import io.intino.sumus.graph.rules.TimeScale;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class TemporalCategorizationFactory {
    private static Map<TimeScale, Class<? extends TemporalCategorization>> categorizations = new HashMap<TimeScale, Class<? extends TemporalCategorization>>();

    public TemporalCategorizationFactory() {
        TemporalCategorizationFactory.init();
    }

    private static void init() {
        categorizations.put(TimeScale.Year, YearCategorization.class);
        categorizations.put(TimeScale.QuarterOfYear, QuarterCategorization.class);
        categorizations.put(TimeScale.Month, MonthCategorization.class);
        categorizations.put(TimeScale.Week, WeekCategorization.class);
        categorizations.put(TimeScale.Day, DayCategorization.class);
        categorizations.put(TimeScale.SixHours, SixHoursCategorization.class);
        categorizations.put(TimeScale.Hour, HourCategorization.class);
        categorizations.put(TimeScale.FifteenMinutes, FifteenMinutesCategorization.class);
        categorizations.put(TimeScale.Minute, MinuteCategorization.class);
        categorizations.put(TimeScale.Second, SecondCategorization.class);
    }

    public TemporalCategorization get(TimeRange range) {
        try {
            Class<? extends TemporalCategorization> aClass = categorizations.get((Object)range.scale());
            return aClass.getConstructor(TimeRange.class).newInstance(range);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        TemporalCategorizationFactory.init();
    }
}

