/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.analytics.categorization;

import io.intino.sumus.Category;
import io.intino.sumus.CategoryMap;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Entity;
import io.intino.sumus.graph.SumusGraph;
import io.intino.tara.magritte.Concept;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CategoryProcessor {
    private final List<Categorization> categorizations;
    private final Map<Concept, List<Entity>> entities;

    private CategoryProcessor(SumusGraph sumus) {
        this.categorizations = sumus.categorizationList();
        this.entities = this.entities(sumus);
    }

    public static void categorize(SumusGraph sumus) {
        new CategoryProcessor(sumus).categorize();
    }

    private Map<Concept, List<Entity>> entities(SumusGraph sumus) {
        HashMap<Concept, List<Entity>> entities = new HashMap<Concept, List<Entity>>();
        for (Entity entity : sumus.core$().find(Entity.class)) {
            for (Categorization categorization : this.categorizations) {
                if (!entity.core$().is(categorization.entity())) continue;
                if (!entities.containsKey(categorization.entity())) {
                    entities.put(categorization.entity(), new ArrayList());
                }
                ((List)entities.get(categorization.entity())).add(entity);
            }
        }
        return entities;
    }

    private void categorize() {
        this.categorize(this.categorizations);
    }

    private void categorize(List<Categorization> categorizations) {
        for (Categorization categorization : categorizations) {
            this.categorize(categorization);
        }
    }

    private void categorize(Categorization categorization) {
        CategoryMap categoryMap = categorization.categoryMap();
        categoryMap.clear();
        List entityList = this.entities.getOrDefault(categorization.entity(), new ArrayList());
        for (Entity entity : entityList) {
            String category = categorization.attribute(entity);
            if (!categoryMap.containsKey(category)) {
                categoryMap.put(category, new Category(category));
            }
            ((Category)categoryMap.get(category)).entityIds().add(entity.core$().id());
        }
    }
}

