/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.analytics;

import io.intino.sumus.graph.rules.TimeScale;
import java.time.Instant;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class TimeRange {
    private final Instant from;
    private final Instant to;
    private final TimeScale scale;

    public TimeRange(Instant from, Instant to, TimeScale scale) {
        this.from = from;
        this.to = to;
        this.scale = scale;
    }

    public Instant from() {
        return this.from;
    }

    public Instant to() {
        return this.to;
    }

    public TimeScale scale() {
        return this.scale;
    }

    public boolean inside(Instant instant) {
        return this.from().equals(instant) || this.to().equals(instant) || this.from().isBefore(instant) && this.to().isAfter(instant);
    }

    public void iterateRange(Consumer<Instant> action) {
        this.allInstants().forEach(action);
    }

    public Stream<Instant> allInstants() {
        return Stream.iterate(this.scale.normalise(this.from), this.scale::nextTime).limit(this.scale.instantsBetween(this.from, this.to));
    }

    public boolean isEmpty() {
        return this.from.equals(this.to) || this.to.isBefore(this.from);
    }
}

