/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.ui.datasources;

import io.intino.alexandria.Scale;
import io.intino.alexandria.ui.model.TimeScale;
import io.intino.alexandria.ui.model.datasource.temporal.TemporalDynamicTableDatasource;
import io.intino.alexandria.ui.services.push.UISession;
import io.intino.sumus.box.I18n;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.Fact;
import io.intino.sumus.engine.Slice;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class BaseCubeDatasource
extends TemporalDynamicTableDatasource<Fact> {
    private final SumusBox box;
    private final UISession session;
    private final String name;
    private final TimeScale scale;
    private final Map<String, String> translations;
    private Map<Dimension, Slice> attachedValues = new LinkedHashMap<Dimension, Slice>();

    public BaseCubeDatasource(SumusBox box, UISession session, String name, TimeScale scale) {
        this.box = box;
        this.session = session;
        this.name = name;
        this.scale = scale;
        this.translations = box.ledgerTranslations(name, this.language());
    }

    public Slice slice(Dimension dimension, String key) {
        return dimension.slices().stream().filter(c -> c.name().equals(key) || this.translate(c.name()).equals(key)).findFirst().orElse(null);
    }

    public String name() {
        return this.name;
    }

    public TimeScale timeScale() {
        return this.scale;
    }

    public Scale scale() {
        if (this.scale == TimeScale.Day) {
            return Scale.Day;
        }
        if (this.scale == TimeScale.Month) {
            return Scale.Month;
        }
        return Scale.Year;
    }

    public SumusBox box() {
        return this.box;
    }

    public UISession session() {
        return this.session;
    }

    public void removeAttachedValue(Dimension dimension) {
        this.attachedValues.remove(dimension);
    }

    public void putAttachedValue(Dimension dimension, Slice value) {
        this.attachedValues.put(dimension, value);
    }

    public boolean isAttached(Dimension dimension) {
        return this.attachedValues.containsKey(dimension);
    }

    public Slice attachedValue(Dimension dimension) {
        return this.attachedValues.getOrDefault(dimension, null);
    }

    public Map<Dimension, Slice> attachedValues() {
        return this.attachedValues;
    }

    public BaseCubeDatasource attachedValues(Map<Dimension, Slice> attachedValues) {
        this.attachedValues = attachedValues;
        return this;
    }

    public String language() {
        return this.session().discoverLanguage();
    }

    public String translate(String word) {
        return this.translations.getOrDefault(word, I18n.translate(word, this.language()));
    }

    protected Set<String> toSet(String value) {
        return new HashSet<String>(value != null ? Collections.singletonList(value) : Collections.emptyList());
    }
}

