/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box;

import com.google.gson.Gson;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.services.AuthService;
import io.intino.alexandria.ui.services.auth.Space;
import io.intino.alexandria.zip.Zip;
import io.intino.amidas.accessor.alexandria.core.AmidasOauthAccessor;
import io.intino.sumus.Archetype;
import io.intino.sumus.box.AbstractBox;
import io.intino.sumus.box.RealtimeBuilder;
import io.intino.sumus.box.SumusConfiguration;
import io.intino.sumus.box.ui.Theme;
import io.intino.sumus.box.ui.datasources.Range;
import io.intino.sumus.box.util.Formatters;
import io.intino.sumus.engine.Ledger;
import io.intino.sumus.model.LedgerDefinition;
import io.intino.sumus.reporting.loaders.LedgerLoader;
import io.intino.sumus.reporting.model.DashboardDefinition;
import io.intino.sumus.reporting.model.Scale;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import spark.utils.IOUtils;

public class SumusBox
extends AbstractBox {
    private Archetype archetype;
    private RealtimeBuilder realTimeBuilder;
    private LedgerLoader ledgerLoader;

    public SumusBox(String[] args) {
        this(new SumusConfiguration(args));
        this.archetype = new Archetype(this.configuration.home());
    }

    public SumusBox(SumusConfiguration configuration) {
        super(configuration);
        this.archetype = new Archetype(configuration.home());
        this.ledgerLoader = new LedgerLoader(this.archetype.datamarts().ledgers().root());
    }

    @Override
    public Box put(Object o) {
        super.put(o);
        if (o instanceof RealtimeBuilder) {
            this.realTimeBuilder = (RealtimeBuilder)o;
        }
        return this;
    }

    public Archetype archetype() {
        return this.archetype;
    }

    @Override
    public void beforeStart() {
    }

    @Override
    public void afterStart() {
    }

    @Override
    public void beforeStop() {
    }

    @Override
    public void afterStop() {
    }

    public RealtimeBuilder realtimeBuilder() {
        return this.realTimeBuilder;
    }

    @Override
    protected AuthService authService(URL authServiceUrl) {
        try {
            if (authServiceUrl == null) {
                return null;
            }
            return new AmidasOauthAccessor(new Space(new URL(this.configuration().url())), authServiceUrl);
        }
        catch (MalformedURLException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public List<String> dashboards() {
        File[] dashboards = this.archetype.datamarts().dashboards().root().listFiles();
        if (dashboards == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(dashboards).filter(c -> c.getName().endsWith(".dashboard")).map(f -> f.getName().replace(".dashboard", "")).sorted().collect(Collectors.toList());
    }

    public DashboardDefinition dashboardDefinition(String name) {
        try {
            File definitionFile = this.archetype.datamarts().dashboards().getDashboardDefinition(name);
            if (!definitionFile.exists()) {
                return new DashboardDefinition();
            }
            return DashboardDefinition.load((String)Files.readString(definitionFile.toPath()));
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return new DashboardDefinition();
        }
    }

    public Map<String, String> dashboardTranslations(String dashboard, String language) {
        return this.translations(this.archetype.datamarts().dashboards().getDashboardTranslations(dashboard, language));
    }

    public List<String> reports(String dashboard) {
        File[] reports = this.archetype.datamarts().dashboards().getDashboardReports(dashboard).listFiles();
        if (reports == null) {
            return new ArrayList<String>();
        }
        return Arrays.stream(reports).filter(File::isDirectory).map(File::getName).collect(Collectors.toList());
    }

    public String defaultReportNodeName(String dashboard, String report, Timetag period, Scale scale, String window) {
        try {
            File zipFile;
            if (period == null) {
                return "_All";
            }
            Archetype.Datamarts.Dashboards dashboards = this.archetype().datamarts().dashboards();
            String periodName = scale.timetag(period.datetime().toLocalDate());
            File file = zipFile = this.useWindow(window) ? dashboards.getDashboardReport(dashboard, report, periodName, window) : dashboards.getDashboardReport(dashboard, report, periodName);
            if (!zipFile.exists()) {
                return "_All";
            }
            Zip zip = new Zip(zipFile);
            return zip.entries().size() > 0 ? ((String)zip.entries().get(0)).split("/")[1].replace(".html", "") : "_All";
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return "_All";
        }
    }

    public String reportNode(String dashboard, String report, Timetag period, Scale scale, String window, String node) {
        try {
            File zipFile;
            if (period == null) {
                return null;
            }
            String periodName = scale.timetag(period.datetime().toLocalDate());
            Archetype.Datamarts.Dashboards dashboards = this.archetype().datamarts().dashboards();
            File file = zipFile = this.useWindow(window) ? dashboards.getDashboardReport(dashboard, report, periodName, window) : dashboards.getDashboardReport(dashboard, report, periodName);
            if (!zipFile.exists()) {
                return null;
            }
            return new Zip(zipFile).read(periodName + (String)(window != null ? "#" + window : "") + "/" + node + ".html");
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public String singletonReportNode(String dashboard, String report, String node) {
        try {
            Archetype.Datamarts.Dashboards dashboards = this.archetype().datamarts().dashboards();
            File zipFile = dashboards.getDashboardReport(dashboard, report, report);
            if (!zipFile.exists()) {
                return null;
            }
            return new Zip(zipFile).read(report + "/" + node + ".html");
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public String viewNode(String dashboard, String view, Timetag period, String node) {
        try {
            if (period == null) {
                return null;
            }
            Archetype.Datamarts.Dashboards dashboards = this.archetype().datamarts().dashboards();
            File zipFile = dashboards.getDashboardView(dashboard, view, period.value());
            if (!zipFile.exists()) {
                return null;
            }
            return new Zip(zipFile).read(period.value() + "/" + node + ".json");
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private boolean useWindow(String window) {
        return window != null && Integer.parseInt(window) != 1;
    }

    public List<String> ledgers() {
        File[] cubes = this.archetype.datamarts().ledgers().root().listFiles();
        if (cubes == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(cubes).filter(c -> c.getName().endsWith(".ledger")).map(f -> f.getName().replace(".ledger", "")).sorted().collect(Collectors.toList());
    }

    public Range ledgerRange(String ledgerKey) {
        Range result = new Range();
        List<File> files = this.archetype.datamarts().ledgers().getLedgerRange(ledgerKey);
        File first = files.stream().min(Comparator.comparing(File::getName)).orElse(null);
        File last = files.stream().max(Comparator.comparing(File::getName)).orElse(null);
        if (first != null) {
            result.min = Timetag.of((String)first.getName().replace(".tsv", ""));
        }
        if (last != null) {
            result.max = Timetag.of((String)last.getName().replace(".tsv", ""));
        }
        return result;
    }

    public LedgerDefinition ledgerDefinition(String ledgerKey) {
        try {
            File ledgerDefinitionFile = this.archetype.datamarts().ledgers().getLedgerDefinition(ledgerKey);
            return LedgerDefinition.load((File)ledgerDefinitionFile.getParentFile(), (File)ledgerDefinitionFile);
        }
        catch (ParseException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public Map<String, String> ledgerTranslations(String ledgerKey, String language) {
        return this.translations(this.archetype.datamarts().ledgers().getLedgerTranslations(ledgerKey, language));
    }

    public Ledger ledger(String ledgerKey, Timetag period) {
        return this.ledgerLoader.ledger(ledgerKey, new LocalDate[]{period.datetime().toLocalDate()});
    }

    public URL logoUrl() {
        try {
            String logo = this.configuration().logo();
            File logoFile = logo != null && !logo.isEmpty() ? new File(logo) : this.archetype().configuration().getLogo();
            return logoFile.exists() ? logoFile.toURI().toURL() : SumusBox.class.getResource("/logo.png");
        }
        catch (MalformedURLException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public String logoContent() {
        String string;
        block9: {
            File logo = this.archetype.configuration().getLogoBase64();
            if (logo.exists()) {
                return Files.readString(logo.toPath());
            }
            InputStream stream = Formatters.class.getResourceAsStream("/logo.base64.txt");
            try {
                string = new String(IOUtils.toByteArray((InputStream)stream));
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Logger.error((Throwable)e);
                    return null;
                }
            }
            stream.close();
        }
        return string;
    }

    public Theme theme() {
        try {
            File file = this.archetype.configuration().getTheme();
            if (!file.exists()) {
                return new Theme();
            }
            String content = Files.readString(file.toPath());
            Theme theme = new Theme();
            theme.putAll((Map)new Gson().fromJson(content, Map.class));
            return theme;
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return new Theme();
        }
    }

    private Map<String, String> translations(File file) {
        try {
            if (!file.exists()) {
                return new HashMap<String, String>();
            }
            String content = Files.readString(file.toPath());
            return (Map)new Gson().fromJson(content, Map.class);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return Collections.emptyMap();
        }
    }
}

