import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiOpenSite from "alexandria-ui-elements/src/displays/components/OpenSite";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTemporalSlider from "alexandria-ui-elements/src/displays/components/TemporalSlider";
import UiSelectorComboBox from "alexandria-ui-elements/src/displays/components/SelectorComboBox";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import UiOpenDialog from "alexandria-ui-elements/src/displays/components/OpenDialog";
import UiSelectorToggleBox from "alexandria-ui-elements/src/displays/components/SelectorToggleBox";
import UiMaterialIcon from "alexandria-ui-elements/src/displays/components/MaterialIcon";
import UiDownload from "alexandria-ui-elements/src/displays/components/Download";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiDecisionDialog from "alexandria-ui-elements/src/displays/components/DecisionDialog";
import UiSelectorListBox from "alexandria-ui-elements/src/displays/components/SelectorListBox";
import DisplaysAttachedTemplateItem from "sumus-elements/gen/displays/templates/AttachedTemplateItem";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import CubeDialogNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import CubeDialogRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class CubeDialog extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new CubeDialogNotifier(this);
		this.requester = new CubeDialogRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="cubeDialogStyle" layout="vertical" style={{...this.props.style,...display}}>
				<UiOpenSite context={this._context.bind(this)} owner={this._owner.bind(this)} id="a353360404" title="" target="blank" mode="Link" size="Medium">
				</UiOpenSite>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1157464163" format="containerAirMedium noAirTop" layout="horizontal center">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1157464163.a768768952" layout="vertical">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1157464163.a768768952.a_30114797" format="airLeft" layout="horizontal">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1157464163.a768768952.a_30114797.a1718917448" format="h6 airRight topSpaced" mode="normal">
							</UiText>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1157464163.a768768952.a_30114797.a363290481" format="topSpaced" layout="vertical">
								<UiTemporalSlider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1157464163.a768768952.a_30114797.a363290481.a186241734" arrangement="Horizontal" style="NavigationOnly" position="SliderTop">
								</UiTemporalSlider>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1157464163.a768768952.a146665402" layout="horizontal flexible center">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1157464163.a768768952.a146665402.a_1459083036" format="airLeft airRight middleTopSpaced" layout="vertical centercenter">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1157464163.a768768952.a146665402.a_1459083036.a_1581787290" layout="horizontal center">
									<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1157464163.a768768952.a146665402.a_1459083036.a_1581787290.a93278389" format="airRight" layout="vertical" width="300px" height="-1px">
										<UiSelectorComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1157464163.a768768952.a146665402.a_1459083036.a_1581787290.a93278389.a1764343650" multipleSelection={false} placeholder="Select an option" maxMenuHeight={300}>
										</UiSelectorComboBox>
									</UiBlock>
									<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1157464163.a768768952.a146665402.a_1459083036.a_1581787290.a_709909534" format="airRight" layout="vertical" width="300px" height="-1px">
										<UiSelectorComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1157464163.a768768952.a146665402.a_1459083036.a_1581787290.a_709909534.a726076142" multipleSelection={false} placeholder="Select an option" maxMenuHeight={300}>
										</UiSelectorComboBox>
									</UiBlock>
								</UiBlock>
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1157464163.a768768952.a146665402.a_1459083036.a_1520424675" format="middleAirTop" layout="horizontal center">
									<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1157464163.a768768952.a146665402.a_1459083036.a_1520424675.a_1788243374" format="middleAirRight" multiple={{instances:"attachedElements",arrangement:"Horizontal",noItemsMessage:"",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
									</UiMultiple>
									<UiOpenDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1157464163.a768768952.a146665402.a_1459083036.a_1520424675.a_1547667274" title="" target="self" mode="Link" size="Medium">
									</UiOpenDialog>
								</UiBlock>
							</UiBlock>
							<UiSelectorToggleBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1157464163.a768768952.a146665402.a_874235689" format="airRight viewSelectorStyle" multipleSelection={false} layout="Horizontal" size="Small">
								<UiMaterialIcon context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1157464163.a768768952.a146665402.a_874235689.a_459023669" name="listView" format="blackColor middleAirTop listViewStyle" icon="ViewHeadline">
								</UiMaterialIcon>
								<UiMaterialIcon context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1157464163.a768768952.a146665402.a_874235689.a1504409400" name="barChartView" format="blackColor middleAirTop rotate90 barChartStyle" icon="BarChart">
								</UiMaterialIcon>
								<UiMaterialIcon context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1157464163.a768768952.a146665402.a_874235689.a_2100582869" name="tableView" format="blackColor middleAirTop tableViewStyle" icon="Apps">
								</UiMaterialIcon>
							</UiSelectorToggleBox>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1157464163.a768768952.a146665402.a_846191604" format="airTop airBottom" layout="horizontal">
								<UiDownload context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1157464163.a768768952.a146665402.a_846191604.a1881608994" title="Download" target="self" mode="IconButton" size="Small" format="toolbarButton greyImage">
								</UiDownload>
								<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1157464163.a768768952.a146665402.a_846191604.a_2059403297" title="Transpose" target="self" mode="IconButton" readonly={true} size="Small" format="airLeft toolbarButton rotate">
								</UiAction>
								<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1157464163.a768768952.a146665402.a_846191604.a_140217597" title="View details" target="self" mode="MaterialIconButton" icon="OpenInNew" affirmed="Are you sure to open report?" size="Small" format="airLeft toolbarButton greyImage">
								</UiAction>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_314072779" format="filtersSummaryStyle" visible={false} layout="horizontal center">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_314072779.a_87382631" format="body2 airRight greyColor" mode="normal" translate={true} value="Applied filters">
					</UiText>
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_314072779.a_93442090" format="body2 bold" mode="normal" cropWithEllipsis={120}>
					</UiText>
					<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_314072779.a_1995080074" title="remove" target="self" mode="Link" size="Medium" format="body2 airLeft">
					</UiAction>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1243915374" format="addFiltersSummaryStyle" visible={false} layout="horizontal center">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1243915374.a_854090782" format="body2 bold" mode="normal" cropWithEllipsis={80}>
					</UiText>
					<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1243915374.a_723350470" title="add as filter" target="self" mode="Link" size="Medium" format="body2 airLeft">
					</UiAction>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a118526988" format="zoomLevelStyle" visible={false} layout="horizontal center">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a118526988.a_136086586" layout="vertical" width="100px" height="-1px">
						<UiSelectorComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a118526988.a_136086586.a1455883914" multipleSelection={false} placeholder="Level" maxMenuHeight={300} view="TextView">
						</UiSelectorComboBox>
					</UiBlock>
				</UiBlock>
				<UiDecisionDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1626965040" title="">
					<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1626965040.a_144176749" multipleSelection={false}>
					</UiSelectorListBox>
				</UiDecisionDialog>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(CubeDialog));
DisplayFactory.register("CubeDialog", withStyles(styles, { withTheme: true })(withSnackbar(CubeDialog)));