import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import CategoryTagNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import CategoryTagRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class CategoryTag extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new CategoryTagNotifier(this);
		this.requester = new CategoryTagRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="horizontal center" style={{...this.props.style,...display}}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1971528367" mode="normal">
				</UiText>
				<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1220495908" title="Remove" target="self" mode="MaterialIconButton" icon="Clear" size="Small" format="smallIconSize" visible={false}>
				</UiAction>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(CategoryTag));
DisplayFactory.register("CategoryTag", withStyles(styles, { withTheme: true })(withSnackbar(CategoryTag)));