import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiDateEditable from "alexandria-ui-elements/src/displays/components/DateEditable";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiSelectorComboBox from "alexandria-ui-elements/src/displays/components/SelectorComboBox";
import UiSelectorListBox from "alexandria-ui-elements/src/displays/components/SelectorListBox";
import DisplaysReportTemplate from "sumus-elements/gen/displays/templates/ReportTemplate";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import DashboardTemplateNotifier from "sumus-elements/gen/displays/notifiers/DashboardTemplateNotifier";
import DashboardTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class DashboardTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new DashboardTemplateNotifier(this);
		this.requester = new DashboardTemplateRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="overflowAuto" layout="horizontal flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2099675119" format="blueRightBordered columnMinWidth doubleAirRight doubleRightSpaced" layout="vertical" width="calc(20% - 20px)" height="100.0%">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2099675119.a108094056" format="bottomSpaced doubleLeftSpaced topSpaced" visible={false} mode="normal" translate={true} value="No reports found">
					</UiText>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2099675119.a_1642733843" format="bottomSpaced doubleLeftSpaced" layout="horizontal center">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2099675119.a_1642733843.a628626521" format="doubleAirRight" layout="vertical flexible">
							<UiDateEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2099675119.a_1642733843.a628626521.a19412575" pattern="DD/MM/YYYY" mode="tonow">
							</UiDateEditable>
						</UiBlock>
						<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2099675119.a_1642733843.a2037710634" title="Previous period" target="self" mode="MaterialIconButton" icon="ChevronLeft" size="Small" format="mediumIconSize middleAirRight">
						</UiAction>
						<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2099675119.a_1642733843.a1329494822" title="Next period" target="self" mode="MaterialIconButton" icon="ChevronRight" size="Small" format="mediumIconSize">
						</UiAction>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2099675119.a_209628698" layout="horizontal center">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2099675119.a_209628698.a_1820086687" format="bottomSpaced doubleLeftSpaced" visible={false} layout="vertical flexible">
							<UiSelectorComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2099675119.a_209628698.a_1820086687.a335460843" multipleSelection={false} maxMenuHeight={300}>
							</UiSelectorComboBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2099675119.a_209628698.a_530844191" format="bottomSpaced doubleLeftSpaced" visible={false} layout="vertical flexible">
							<UiSelectorComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2099675119.a_209628698.a_530844191.a_1656414707" multipleSelection={false} maxMenuHeight={300}>
							</UiSelectorComboBox>
						</UiBlock>
					</UiBlock>
					<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2099675119.a1419573746" format="doubleLeftSpaced" multipleSelection={false}>
					</UiSelectorListBox>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1616384791" format="doubleAirBottom middleAirTop" layout="horizontal flexible">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1616384791.a_266049974" format="overflowAuto" layout="vertical flexible" width="100px" height="-1px">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1616384791.a_266049974.a1738264471" layout="vertical flexible">
							<DisplaysReportTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1616384791.a_266049974.a1738264471.a1144463943">
							</DisplaysReportTemplate>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


	notifyProxyMessage = (name) => {
		if (!this.props.onProxyMessage) return;
		this.props.onProxyMessage(name);
	};
}

export default withStyles(styles, { withTheme: true })(withSnackbar(DashboardTemplate));
DisplayFactory.register("DashboardTemplate", withStyles(styles, { withTheme: true })(withSnackbar(DashboardTemplate)));