import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import UiDateEditable from "alexandria-ui-elements/src/displays/components/DateEditable";
import UiSelectorComboBox from "alexandria-ui-elements/src/displays/components/SelectorComboBox";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import DisplaysChatBotMessageTemplate from "sumus-elements/gen/displays/templates/ChatBotMessageTemplate";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import ChatBotTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import ChatBotTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class ChatBotTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new ChatBotTemplateNotifier(this);
		this.requester = new ChatBotTemplateRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="overflowAuto" layout="vertical flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a255993856" format="horizontalAutoMargin" layout="vertical" width="50.0%" height="100.0%">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a255993856.a1673478285" format="spaced" layout="vertical center" width="100.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a255993856.a1673478285.a_1608177154" format="airBottom h3" mode="normal" value="Chat bot">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a255993856.a1673478285.a1703195950" format="greyRoundedBorder lightgreyBackground messagePanelFormat overflowAuto" layout="vertical" width="100.0%" height="100.0%">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a255993856.a1673478285.a1703195950.a_1199910628" format="maxHeight100Percent" layout="verticalreverse">
								<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a255993856.a1673478285.a1703195950.a_1199910628.a871291998" multiple={{instances:"messagesList",arrangement:"Vertical",noItemsMessage:"",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
								</UiMultiple>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a255993856.a1673478285.a390765309" format="greyRoundedBorder heightAuto spaced" layout="horizontal end" width="100.0%" height="100.0%">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a255993856.a1673478285.a390765309.a_288319411" layout="vertical" width="30.0%" height="100.0%">
								<UiDateEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a255993856.a1673478285.a390765309.a_288319411.a_1777923813" pattern="DD/MM/YYYY" mode="tonow">
								</UiDateEditable>
								<UiSelectorComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a255993856.a1673478285.a390765309.a_288319411.a166664387" multipleSelection={false} placeholder="Select ledger" maxMenuHeight={300}>
								</UiSelectorComboBox>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a255993856.a1673478285.a390765309.a_1655941317" layout="horizontal" width="100.0%" height="100.0%">
								<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a255993856.a1673478285.a390765309.a_1655941317.a_796253304" format="airBottom airLeft middleAirTop" mode="normal" placeholder="Ask me anything...">
								</UiTextEditable>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(ChatBotTemplate));
DisplayFactory.register("ChatBotTemplate", withStyles(styles, { withTheme: true })(withSnackbar(ChatBotTemplate)));