import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import ChatBotMessageTemplateNotifier from "sumus-elements/gen/displays/notifiers/ChatBotMessageTemplateNotifier";
import ChatBotMessageTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class ChatBotMessageTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new ChatBotMessageTemplateNotifier(this);
		this.requester = new ChatBotMessageTemplateRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="overflowAuto" layout="horizontal" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_738462508" format="airBottom" layout="vertical">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_738462508.a1894680476" mode="normal">
					</UiText>
				</UiBlock>
			</UiBlock>
		);
	}


	notifyProxyMessage = (name) => {
		if (!this.props.onProxyMessage) return;
		this.props.onProxyMessage(name);
	};
}

export default withStyles(styles, { withTheme: true })(withSnackbar(ChatBotMessageTemplate));
DisplayFactory.register("ChatBotMessageTemplate", withStyles(styles, { withTheme: true })(withSnackbar(ChatBotMessageTemplate)));