import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiSpinner from "alexandria-ui-elements/src/displays/components/Spinner";
import UiBlockConditional from "alexandria-ui-elements/src/displays/components/BlockConditional";
import DisplaysHeader from "sumus-elements/gen/displays/templates/Header";
import DisplaysDashboardsTemplate from "sumus-elements/gen/displays/templates/DashboardsTemplate";
import DisplaysDashboardTemplate from "sumus-elements/gen/displays/templates/DashboardTemplate";
import DisplaysCubeTemplate from "sumus-elements/gen/displays/templates/CubeTemplate";
import DisplaysStoryboardsTemplate from "sumus-elements/gen/displays/templates/StoryboardsTemplate";
import DisplaysStoryboardTemplate from "sumus-elements/gen/displays/templates/StoryboardTemplate";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import AppTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import AppTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class AppTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new AppTemplateNotifier(this);
		this.requester = new AppTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical flexible" width="100.0%" height="calc(100% - 10px)" style={{...this.props.style,...display}}>
				<DisplaysHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a795989040">
				</DisplaysHeader>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_242799787" layout="horizontal flexible">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_242799787.a_410540673" layout="vertical flexible centercenter">
						<UiSpinner context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_242799787.a_410540673.a_987602156" format="secondary" mode="Rise">
						</UiSpinner>
					</UiBlock>
					<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_242799787.a131232235" layout="horizontal flexible">
						<DisplaysDashboardsTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_242799787.a131232235.a_1573691312">
						</DisplaysDashboardsTemplate>
					</UiBlockConditional>
					<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_242799787.a_689529530" layout="horizontal flexible">
						<DisplaysDashboardTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_242799787.a_689529530.a801587624">
						</DisplaysDashboardTemplate>
					</UiBlockConditional>
					<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_242799787.a_1583399807" layout="horizontal flexible">
						<DisplaysCubeTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_242799787.a_1583399807.a1894232656">
						</DisplaysCubeTemplate>
					</UiBlockConditional>
					<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_242799787.a_2010074508" layout="horizontal flexible">
						<DisplaysStoryboardsTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_242799787.a_2010074508.a_249069620">
						</DisplaysStoryboardsTemplate>
					</UiBlockConditional>
					<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_242799787.a1458153373" layout="horizontal flexible">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_242799787.a1458153373.a_464133957" format="horizontalAutoMargin" layout="vertical" width="60.0%" height="100.0%">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_242799787.a1458153373.a_464133957.a_136935514" format="spaced" layout="vertical centercenter">
								<DisplaysStoryboardTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_242799787.a1458153373.a_464133957.a_136935514.a_1837945066">
								</DisplaysStoryboardTemplate>
							</UiBlock>
						</UiBlock>
					</UiBlockConditional>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(AppTemplate));
DisplayFactory.register("AppTemplate", withStyles(styles, { withTheme: true })(withSnackbar(AppTemplate)));