import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiDisplayStamp from "alexandria-ui-elements/src/displays/components/DisplayStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import UiBlockConditional from "alexandria-ui-elements/src/displays/components/BlockConditional";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiSelectorMenu from "alexandria-ui-elements/src/displays/components/SelectorMenu";
import UiSelectorComboBox from "alexandria-ui-elements/src/displays/components/SelectorComboBox";
import DisplaysCategoryTag from "sumus-elements/gen/displays/templates/CategoryTag";
import DisplaysCubeBarChart from "sumus-elements/src/displays/CubeBarChart";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import CubeStoryboardStepTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import CubeStoryboardStepTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class CubeStoryboardStepTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new CubeStoryboardStepTemplateNotifier(this);
		this.requester = new CubeStoryboardStepTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="bordered spaced middleAirBottom" layout="vertical" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a911034619" layout="horizontal">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a911034619.a_72076016" layout="vertical flexible">
						<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a911034619.a_72076016.a1237080298" title="" target="self" mode="Link" size="Medium" format="h6">
						</UiAction>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a911034619.a_72076016.a_500858847" format="smallAirTop" layout="horizontal center">
							<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a911034619.a_72076016.a_500858847.a_197365355" multiple={{instances:"selectedCategories",arrangement:"Horizontal",noItemsMessage:"No categories selected",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
							</UiMultiple>
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a911034619.a_72076016.a_500858847.a_1154176674" title="Edit" target="self" mode="Button" size="Small" format="airLeft" highlighted="Outline" visible={false}>
							</UiAction>
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a911034619.a_72076016.a_500858847.a_971911365" title="Continue" target="self" mode="Button" size="Small" format="airLeft" highlighted="Outline" visible={false}>
							</UiAction>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a911034619.a266388742" layout="horizontal endjustified">
						<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a911034619.a266388742.a_2145134815" title="View details" target="self" mode="Link" size="Medium" format="middleAirTop" visible={false}>
						</UiAction>
					</UiBlock>
				</UiBlock>
				<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1306988644" layout="vertical">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1306988644.a_459885511" format="h6" mode="normal" translate={true} value="Add a filter by">
					</UiText>
					<UiSelectorMenu context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1306988644.a141863298" multipleSelection={false} layout="Vertical">
					</UiSelectorMenu>
				</UiBlockConditional>
				<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a938825278" format="doubleAirTop" layout="vertical">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a938825278.a_1557368983" format="relative" layout="horizontal">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a938825278.a_1557368983.a135544849" format="bold" mode="normal" translate={true} value="Select categories to include">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a938825278.a_1557368983.a1669277183" format="storyboardZoomLevelStyle" visible={false} layout="horizontal center">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a938825278.a_1557368983.a1669277183.a_1152222340" layout="vertical" width="100px" height="-1px">
								<UiSelectorComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a938825278.a_1557368983.a1669277183.a_1152222340.a_1717588822" multipleSelection={false} placeholder="Level" maxMenuHeight={300} view="TextView">
								</UiSelectorComboBox>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiDisplayStamp context={this._context.bind(this)} owner={this._owner.bind(this)} id="a938825278.a2034617153">
					</UiDisplayStamp>
				</UiBlockConditional>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(CubeStoryboardStepTemplate));
DisplayFactory.register("CubeStoryboardStepTemplate", withStyles(styles, { withTheme: true })(withSnackbar(CubeStoryboardStepTemplate)));