import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiOpenDialog from "alexandria-ui-elements/src/displays/components/OpenDialog";
import UiDialog from "alexandria-ui-elements/src/displays/components/Dialog";
import DisplaysStoryboardTemplate from "sumus-elements/gen/displays/templates/StoryboardTemplate";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import CubeStoryboardEntryTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import CubeStoryboardEntryTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class CubeStoryboardEntryTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new CubeStoryboardEntryTemplateNotifier(this);
		this.requester = new CubeStoryboardEntryTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="overflowAuto" layout="horizontal" style={{...this.props.style,...display}}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a461557071" mode="normal">
				</UiText>
				<UiOpenDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a596542676" title="[analyze]" target="self" mode="Link" size="Medium" format="airLeft">
				</UiOpenDialog>
				<UiDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a964735281" title="" fullscreen={true}>
					<DisplaysStoryboardTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a964735281.a667276324">
					</DisplaysStoryboardTemplate>
				</UiDialog>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(CubeStoryboardEntryTemplate));
DisplayFactory.register("CubeStoryboardEntryTemplate", withStyles(styles, { withTheme: true })(withSnackbar(CubeStoryboardEntryTemplate)));