import AlexandriaUiI18n from "alexandria-ui-elements/gen/I18n";

const I18n = (function () {
    var cache = {};

	var translators = {
		"pt" : {
			"Data" : "Dados",
			"Group" : "Grupo",
			"group" : "grupo",
			"Remove" : "Remover",
			"Download" : "Download",
			"Transpose" : "Transpor",
			"Level" : "Nível",
			"Drill by" : "Perfurar por",
			"Divide by" : "Dividido por",
			"Select indicators" : "Selecionar indicadores",
			"Show zeros" : "Mostrar zeros",
			"Show percentages" : "Mostrar porcentagens",
			"Open selected row" : "Abrir linha selecionada",
			"Are you sure to open selected row?" : "Tem certeza de abrir a linha selecionada?",
			"Sort by" : "Ordenar por",
			"name" : "nome",
			"greater value" : "maior valor",
			"lower value" : "valor mais baixo",
			"Download content" : "Baixar conteúdo",
			"Date" : "Encontro: Data",
			"Page" : "Página",
			"of" : "do",
			"to" : "para",
			"in" : "dentro",
			"for" : "para",
			"with" : "com",
			"during" : "no decorrer",
			"Close" : "Fechar",
			"Cancel" : "Cancelar",
			"Accept" : "Aceitar",
			"Logout" : "Sair",
			"Title" : "Título",
			"Applied filters" : "Filtros aplicados",
			"add as filter" : "adicionar como filtro",
			"Dashboards" : "Painéis",
			"Dashboard" : "Painel",
			"Reports" : "Relatórios",
			"No reports found" : "Nenhum relatório encontrado",
			"No report found" : "Nenhum relatório encontrado",
			"Cubes" : "Cubos",
			"No data found" : "Nenhum dado encontrado",
			"Home" : "Lar",
			"Generating report. This operation may take time. Please wait...puede tardar. Por favor, espere..." : "Gerando relatório. Esta operação pode demorar. Por favor, espere... puede tardar. Por favor, espere...",
			"Print page" : "Imprimir página",
			"[Week] YYYY-ww" : "[Semana] YYYY-ww",
			"Select dashboard" : "Selecionar painel",
			"Select storyboard" : "Selecionar storyboard",
			"Analyze by" : "Analisar por",
			"[analyze]" : "[analisar]",
			"[view]" : "[visualizar]",
			"Report generated" : "Relatório gerado",
			"No results" : "Sem resultados",
			"Year" : "Ano",
			"Quarter" : "Trimestre",
			"Month" : "Mês",
			"Week" : "Semana",
			"Day" : "Dia",
			"Date should not be before minimal date" : "A data não deve ser anterior à data mínima",
			"Date should not be after maximal date" : "A data não deve ser posterior à data máxima",
			"Previous date" : "Período anterior",
			"Next date" : "Próximo período",
			"What do you want to see?" : "O que você quer ver?",
			"No categories selected" : "Nenhuma categoria selecionada",
			"Select categories to include" : "Selecione as categorias a serem incluídas",
			"View details" : "Ver detalhes",
			"Edit" : "Editar",
			"Continue" : "Continuar",
			"Add a filter by" : "Adicione um filtro por",
			"Analysis" : "Análise"
		},
		"es" : {
			"Data" : "Datos",
			"Group" : "Grupo",
			"group" : "grupo",
			"remove" : "quitar",
			"Remove" : "Quitar",
			"Download" : "Descargar",
			"Transpose" : "Trasponer",
			"Level" : "Nivel",
			"Drill by" : "Desagregado por",
			"Divide by" : "Dividido por",
			"Select indicators" : "Seleccionar indicadores",
			"Show zeros" : "Mostrar ceros",
			"Show percentages" : "Mostrar porcentajes",
			"Open selected row" : "Mostrar reporte de la fila seleccionada",
			"Are you sure to open selected row?" : "¿Está seguro que desea abrir el reporte de la fila?",
			"Sort by" : "Ordenar por",
			"name" : "nombre",
			"greater value" : "mayor valor",
			"lower value" : "menor valor",
			"Download content" : "Descargar tabla",
			"Date" : "Fecha",
			"Page" : "Página",
			"of" : "de",
			"to" : "a",
			"in" : "en",
			"for" : "para",
			"with" : "con",
			"during" : "durante",
			"Close" : "Cerrar",
			"Cancel" : "Cancelar",
			"Accept" : "Aceptar",
			"Logout" : "Cerrar sesión",
			"Title" : "Título",
			"Applied filters" : "Filtros aplicados",
			"add as filter" : "añadir como filtro",
			"Dashboards" : "Cuadros de mando",
			"Dashboard" : "Cuadro de mando",
			"Reports" : "Informes",
			"No reports found" : "No se han encontrado informes",
			"No report found" : "No se ha encontrado el informe",
			"Cubes" : "Cubos",
			"No data found" : "No se han encontrado datos",
			"Home" : "Inicio",
			"Generating report. This operation may take time. Please wait..." : "Generando informe. Esta operación puede tardar. Por favor, espere...",
			"Print page" : "Imprimir página",
			"Week" : "Semana",
			"[Week] YYYY-ww" : "[Semana] YYYY-ww",
			"Select dashboard" : "Seleccione un cuadro de mando",
			"Select storyboard" : "Seleccione un storyboard",
			"Analyze by" : "Analizar por",
			"[analyze]" : "[analizar]",
			"[view]" : "[ver]",
			"Report generated" : "Informe generado",
			"No results" : "Sin datos",
			"Year" : "Año",
			"Quarter" : "Trimestre",
			"Month" : "Mes",
			"Week" : "Semana",
			"Day" : "Día",
			"Date should not be before minimal date" : "La fecha no debe ser anterior a la fecha mínima",
			"Date should not be after maximal date" : "La fecha no debe ser posterior a la fecha máxima",
			"Previous period" : "Periodo anterior",
			"Next period" : "Periodo siguiente",
			"What do you want to see?" : "¿Qué desea ver?",
			"No categories selected" : "No hay categorías seleccionadas",
			"Select categories to include" : "Seleccione las categorías a incluir",
			"View details" : "Ver detalles",
			"Edit" : "Editar",
			"Continue" : "Continuar",
			"Add a filter by" : "Añadir un filtro por",
			"Analysis" : "Analisis"
		}
	};

    function merge(dictionary, lang) {
        if (dictionary == null) dictionary = {};
        addWords(dictionary, AlexandriaUiI18n.load(lang));
        return dictionary;
    };

    function addWords(dictionary, words) {
        if (words == null) return;
        for (var index in words) dictionary[index] = words[index];
        return dictionary;
    };

	var loader = {
		load: (lang) => {
            if (cache[lang] == null) cache[lang] = merge(translators[lang], lang);
            return cache[lang];
		}
	};

	return loader;
})();

export default I18n;