import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import MessageTemplateNotifier from "sumus-elements/gen/displays/notifiers/MessageTemplateNotifier";
import MessageTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class MessageTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new MessageTemplateNotifier(this);
		this.requester = new MessageTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="overflowAuto" layout="horizontal" style={{...this.props.style,...display}}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1471067178" mode="normal">
				</UiText>
			</UiBlock>
		);
	}


	notifyProxyMessage = (name) => {
	    if (!this.props.onProxyMessage) return;
	    this.props.onProxyMessage(name);
	};
}

export default withStyles(styles, { withTheme: true })(withSnackbar(MessageTemplate));
DisplayFactory.register("MessageTemplate", withStyles(styles, { withTheme: true })(withSnackbar(MessageTemplate)));