import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import UiDateEditable from "alexandria-ui-elements/src/displays/components/DateEditable";
import UiSelectorComboBox from "alexandria-ui-elements/src/displays/components/SelectorComboBox";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import DisplaysChatBotMessageTemplate from "sumus-elements/gen/displays/templates/ChatBotMessageTemplate";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import ChatBotTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import ChatBotTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class ChatBotTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new ChatBotTemplateNotifier(this);
		this.requester = new ChatBotTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="overflowAuto" layout="vertical flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1244378941" format="horizontalAutoMargin" layout="vertical" width="50.0%" height="100.0%">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1244378941.a1147345261" format="spaced" layout="vertical center" width="100.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1244378941.a1147345261.a199277309" format="h3 airBottom" mode="normal" value="Chat bot">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1244378941.a1147345261.a_2081237169" format="messagePanelFormat lightgreyBackground overflowAuto" layout="vertical" width="100.0%" height="100.0%">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1244378941.a1147345261.a_2081237169.a562012860" format="maxHeight100Percent" layout="verticalreverse">
								<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1244378941.a1147345261.a_2081237169.a562012860.a1381826175" multiple={{instances:"messagesList",arrangement:"Vertical",noItemsMessage:"",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
								</UiMultiple>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1244378941.a1147345261.a896323934" format="spaced heightAuto lightgreyBackground" layout="horizontal end" width="100.0%" height="100.0%">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1244378941.a1147345261.a896323934.a_133560723" layout="vertical" width="30.0%" height="100.0%">
								<UiDateEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1244378941.a1147345261.a896323934.a_133560723.a_780851460" pattern="DD/MM/YYYY" mode="tonow">
								</UiDateEditable>
								<UiSelectorComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1244378941.a1147345261.a896323934.a_133560723.a1163736740" multipleSelection={false} placeholder="Select ledger" maxMenuHeight={300}>
								</UiSelectorComboBox>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1244378941.a1147345261.a896323934.a_1153389285" layout="horizontal" width="100.0%" height="100.0%">
								<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1244378941.a1147345261.a896323934.a_1153389285.a_502850297" format="airBottom middleAirTop airLeft" mode="normal" placeholder="Ask me anything...">
								</UiTextEditable>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(ChatBotTemplate));
DisplayFactory.register("ChatBotTemplate", withStyles(styles, { withTheme: true })(withSnackbar(ChatBotTemplate)));