import Notifier from "./Notifier";

export default class HtmlRendererNotifier extends Notifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("refresh").toSelf().execute((parameters) => this.element.refresh(parameters.v));
		this.when("refreshEvents").toSelf().execute(() => this.element.refreshEvents());
		this.when("generatingMicrosite").toSelf().execute(() => this.element.generatingMicrosite());
		this.when("gotoMicrosite").toSelf().execute((parameters) => this.element.gotoMicrosite(parameters.v));
		this.when("gotoView").toSelf().execute((parameters) => this.element.gotoView(parameters.v));
		this.when("printPage").toSelf().execute(() => this.element.printPage());
		this.pushLinked = true;
	};
}