import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiSpinner from "alexandria-ui-elements/src/displays/components/Spinner";
import UiBlockConditional from "alexandria-ui-elements/src/displays/components/BlockConditional";
import DisplaysHeader from "sumus-elements/gen/displays/templates/Header";
import DisplaysDashboardsTemplate from "sumus-elements/gen/displays/templates/DashboardsTemplate";
import DisplaysDashboardTemplate from "sumus-elements/gen/displays/templates/DashboardTemplate";
import DisplaysCubeTemplate from "sumus-elements/gen/displays/templates/CubeTemplate";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import AppTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import AppTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class AppTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new AppTemplateNotifier(this);
		this.requester = new AppTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical flexible" width="100.0%" height="calc(100% - 10px)" style={{...this.props.style,...display}}>
				<DisplaysHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a795989040">
				</DisplaysHeader>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_572722989" layout="horizontal flexible">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_572722989.a_1812669829" layout="vertical flexible centercenter">
						<UiSpinner context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_572722989.a_1812669829.a2053578524" format="secondary" mode="Rise">
						</UiSpinner>
					</UiBlock>
					<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_572722989.a_175445649" layout="horizontal flexible">
						<DisplaysDashboardsTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_572722989.a_175445649.a_1380692012">
						</DisplaysDashboardsTemplate>
					</UiBlockConditional>
					<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_572722989.a_1807801022" layout="horizontal flexible">
						<DisplaysDashboardTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_572722989.a_1807801022.a252068396">
						</DisplaysDashboardTemplate>
					</UiBlockConditional>
					<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_572722989.a_2099730683" layout="horizontal flexible">
						<DisplaysCubeTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_572722989.a_2099730683.a1456523220">
						</DisplaysCubeTemplate>
					</UiBlockConditional>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(AppTemplate));
DisplayFactory.register("AppTemplate", withStyles(styles, { withTheme: true })(withSnackbar(AppTemplate)));