/*
 * Decompiled with CFR 0.152.
 */
package io.intino.slackapi.events;

import io.intino.slackapi.SlackAttachment;
import io.intino.slackapi.SlackBot;
import io.intino.slackapi.SlackChannel;
import io.intino.slackapi.SlackFile;
import io.intino.slackapi.SlackUser;
import io.intino.slackapi.events.SlackEvent;
import io.intino.slackapi.events.SlackEventType;
import java.util.ArrayList;
import java.util.Map;

public class SlackMessagePosted
implements SlackEvent {
    private String messageContent;
    private SlackBot bot;
    private SlackUser user;
    private SlackChannel channel;
    private String timestamp;
    private MessageSubType msgSubType;
    private String threadTimestamp;
    private SlackFile slackFile;
    private String jsonSource;
    private Map<String, Integer> reactions;
    private ArrayList<SlackAttachment> attachments;

    public SlackMessagePosted(String messageContent, SlackBot bot, SlackUser user, SlackChannel channel, String timestamp, MessageSubType msgSubType) {
        this.channel = channel;
        this.messageContent = messageContent;
        this.user = user;
        this.bot = bot;
        this.timestamp = timestamp;
        this.msgSubType = msgSubType;
    }

    public SlackMessagePosted(String messageContent, SlackBot bot, SlackUser user, SlackChannel channel, String timestamp, SlackFile slackFile, String jsonSource, MessageSubType msgSubType, String threadTimestamp) {
        this.channel = channel;
        this.messageContent = messageContent;
        this.user = user;
        this.bot = bot;
        this.timestamp = timestamp;
        this.jsonSource = jsonSource;
        this.slackFile = slackFile;
        this.msgSubType = msgSubType;
        this.threadTimestamp = threadTimestamp;
    }

    public String toString() {
        return "SlackMessagePosted{messageContent=" + this.messageContent + ", user=" + this.user + ", bot=" + this.bot + ", channel=" + this.channel + ", timestamp=" + this.timestamp + ", reactions=" + this.reactions + "}";
    }

    public String getJsonSource() {
        return this.jsonSource;
    }

    public SlackFile getSlackFile() {
        return this.slackFile;
    }

    public String getMessageContent() {
        return this.messageContent;
    }

    public SlackUser getSender() {
        return this.user;
    }

    public SlackBot getBot() {
        return this.bot;
    }

    public SlackChannel getChannel() {
        return this.channel;
    }

    public String getTimeStamp() {
        return this.timestamp;
    }

    @Override
    public SlackEventType getEventType() {
        return SlackEventType.SLACK_MESSAGE_POSTED;
    }

    public Map<String, Integer> getReactions() {
        return this.reactions;
    }

    public void setReactions(Map<String, Integer> reactions) {
        this.reactions = reactions;
    }

    public void setAttachments(ArrayList<SlackAttachment> attachments) {
        this.attachments = attachments;
    }

    public int getTotalCountOfReactions() {
        return this.reactions == null ? 0 : this.reactions.size();
    }

    public MessageSubType getMessageSubType() {
        return this.msgSubType;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public ArrayList<SlackAttachment> getAttachments() {
        return this.attachments;
    }

    public String getThreadTimestamp() {
        return this.threadTimestamp;
    }

    public static enum MessageSubType {
        BOT_MESSAGE("bot_message"),
        CHANNEL_ARCHIVE("channel_archive"),
        CHANNEL_JOIN("channel_join"),
        CHANNEL_LEAVE("channel_leave"),
        CHANNEL_LEFT("channel_left"),
        CHANNEL_NAME("channel_name"),
        CHANNEL_PURPOSE("channel_purpose"),
        CHANNEL_TOPIC("channel_topic"),
        CHANNEL_UNARCHIVE("channel_unarchive"),
        FILE_COMMENT("file_comment"),
        FILE_MENTION("file_mention"),
        FILE_SHARE("file_share"),
        GROUP_JOIN("group_join"),
        GROUP_LEAVE("group_leave"),
        GROUP_NAME("group_name"),
        GROUP_PURPOSE("group_purpose"),
        GROUP_TOPIC("group_topic"),
        GROUP_UNARCHIVE("group_unarchive"),
        ME_MESSAGE("me_message"),
        MESSAGE_CHANGED("message_changed"),
        MESSAGE_DELETED("message_deleted"),
        PINNED_ITEM("pinned_item"),
        UNPINNED_ITEM("unpinned_item"),
        MESSAGE_REPLIED("message_replied"),
        UNKNOWN("");

        String code;

        private MessageSubType(String code) {
            this.code = code;
        }

        public static final MessageSubType fromCode(String code) {
            for (MessageSubType subType : MessageSubType.values()) {
                if (!subType.code.equals(code)) continue;
                return subType;
            }
            return UNKNOWN;
        }

        public String getCode() {
            return this.code;
        }
    }
}

