/*
 * Decompiled with CFR 0.152.
 */
package io.intino.slackapi;

import io.intino.slackapi.SlackAttachment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class SlackPreparedMessage {
    private String message;
    private boolean unfurl;
    private boolean linkNames;
    private List<SlackAttachment> attachments;
    private String threadTimestamp;
    private boolean replyBroadcast;

    private SlackPreparedMessage(String message, boolean unfurl, boolean linkNames, SlackAttachment[] attachments, String threadTimestamp, boolean replyBroadcast) {
        this.message = message;
        this.unfurl = unfurl;
        this.linkNames = linkNames;
        this.attachments = Arrays.asList(attachments);
        this.threadTimestamp = threadTimestamp;
        this.replyBroadcast = replyBroadcast;
    }

    public SlackPreparedMessage() {
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isUnfurl() {
        return this.unfurl;
    }

    public boolean isLinkNames() {
        return this.linkNames;
    }

    public SlackAttachment[] getAttachments() {
        return this.attachments.toArray(new SlackAttachment[0]);
    }

    public String getThreadTimestamp() {
        return this.threadTimestamp;
    }

    public boolean isReplyBroadcast() {
        return this.replyBroadcast;
    }

    public String toString() {
        return "SlackPreparedMessage{message='" + this.message + "', unfurl=" + this.unfurl + ", attachments=" + this.attachments + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlackPreparedMessage that = (SlackPreparedMessage)o;
        return this.isUnfurl() == that.isUnfurl() && this.isLinkNames() == that.isLinkNames() && this.isReplyBroadcast() == that.isReplyBroadcast() && Objects.equals(this.getMessage(), that.getMessage()) && Arrays.equals(this.getAttachments(), that.getAttachments()) && Objects.equals(this.getThreadTimestamp(), that.getThreadTimestamp());
    }

    public int hashCode() {
        int result = Objects.hash(this.getMessage(), this.isUnfurl(), this.isLinkNames(), this.getThreadTimestamp(), this.isReplyBroadcast());
        result = 31 * result + Arrays.hashCode(this.getAttachments());
        return result;
    }

    public static class Builder {
        String message;
        boolean unfurl;
        boolean linkNames;
        List<SlackAttachment> attachments = new ArrayList<SlackAttachment>();
        String threadTimestamp;
        boolean replyBroadcast;

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder withUnfurl(boolean unfurl) {
            this.unfurl = unfurl;
            return this;
        }

        public Builder withLinkNames(boolean linkNames) {
            this.linkNames = linkNames;
            return this;
        }

        public Builder addAttachment(SlackAttachment attachment) {
            if (attachment != null) {
                this.attachments.add(attachment);
            }
            return this;
        }

        public Builder addAttachments(List<SlackAttachment> attachments) {
            if (attachments != null) {
                this.attachments.addAll(attachments);
            }
            return this;
        }

        public Builder withAttachments(List<SlackAttachment> attachments) {
            this.attachments = attachments;
            return this;
        }

        public Builder withThreadTimestamp(String threadTimestamp) {
            this.threadTimestamp = threadTimestamp;
            return this;
        }

        public Builder withReplyBroadcast(boolean replyBroadcast) {
            this.replyBroadcast = replyBroadcast;
            return this;
        }

        public SlackPreparedMessage build() {
            return new SlackPreparedMessage(this.message, this.unfurl, this.linkNames, this.attachments.toArray(new SlackAttachment[0]), this.threadTimestamp, this.replyBroadcast);
        }
    }
}

